/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.wss;

import java.util.List;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.soap.SOAPFaultException;
import org.w3c.dom.Node;
import weblogic.security.UsernameAndPassword;
import weblogic.security.service.ContextHandler;
import weblogic.security.service.SecurityServiceManager;
import weblogic.xml.crypto.common.keyinfo.KeyProvider;
import weblogic.xml.crypto.utils.LogUtils;
import weblogic.xml.crypto.wss.SecurityTokenValidateResult;
import weblogic.xml.crypto.wss.SecurityUtils;
import weblogic.xml.crypto.wss.SignatureInfo;
import weblogic.xml.crypto.wss.UsernameTokenImpl;
import weblogic.xml.crypto.wss.UsernameTokenReference;
import weblogic.xml.crypto.wss.WSSConstants;
import weblogic.xml.crypto.wss.WSSecurityContext;
import weblogic.xml.crypto.wss.WSSecurityException;
import weblogic.xml.crypto.wss.api.NonceValidator;
import weblogic.xml.crypto.wss.api.UsernameToken;
import weblogic.xml.crypto.wss.nonce.NonceValidatorFactory;
import weblogic.xml.crypto.wss.policy.ClaimsBuilder;
import weblogic.xml.crypto.wss.provider.Purpose;
import weblogic.xml.crypto.wss.provider.SecurityToken;
import weblogic.xml.crypto.wss.provider.SecurityTokenHandler;
import weblogic.xml.crypto.wss.provider.SecurityTokenReference;
import weblogic.xml.dom.Util;
import weblogic.xml.dom.marshal.MarshalException;

public class UsernameTokenHandler
implements SecurityTokenHandler {
    private static final QName[] qnames = new QName[]{WSSConstants.UNT_QNAME};
    private static final String[] valueTypes = new String[]{"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken"};
    private static final String POLICY_URI = "http://www.bea.com/wls90/security/policy";
    private static final QName POLICY_SUBJECT_NAME = new QName("http://www.bea.com/wls90/security/policy", "PasswordType");
    private boolean passwordDigestSupported;
    public static final String OLD_USERNAME_TOKEN_URI = "http://www.docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0";
    private static final String OLD_PASSWORD_TYPE_TEXT = "http://www.docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText";
    private static final String OLD_PASSWORD_TYPE_DIGEST = "http://www.docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest";
    private NonceValidator nonceChecker = null;

    public String[] getValueTypes() {
        return valueTypes;
    }

    public KeyProvider getKeyProvider(SecurityToken securityToken, MessageContext messageContext) {
        return null;
    }

    public SecurityToken getSecurityToken(SecurityTokenReference securityTokenReference, MessageContext messageContext) {
        return null;
    }

    public SecurityTokenValidateResult validateUnmarshalled(SecurityToken securityToken, MessageContext messageContext) throws WSSecurityException {
        boolean bl = true;
        UsernameToken usernameToken = (UsernameToken)securityToken;
        if (UsernameTokenHandler.hasPassword(usernameToken)) {
            Object object;
            String string = usernameToken.getPasswordType();
            if (string.equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest")) {
                object = usernameToken.getPasswordDigest();
                String string2 = usernameToken.getEncodedNonce();
                if (string2 == null || string2.length() == 0 || object == null || ((String)object).length() == 0 || usernameToken.getCreated() == null) {
                    bl = false;
                }
            } else if (string.equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText") && ((object = (Object)usernameToken.getPassword()) == null || ((Object)object).length == 0)) {
                bl = false;
            }
            if (null != usernameToken.getEncodedNonce() && usernameToken.getEncodedNonce().length() > 0) {
                if (null != usernameToken.getCreated()) {
                    try {
                        this.nonceChecker = NonceValidatorFactory.getInstance();
                        this.nonceChecker.checkNonceAndTime(usernameToken.getEncodedNonce(), usernameToken.getCreated());
                    }
                    catch (SOAPFaultException sOAPFaultException) {
                        return new SecurityTokenValidateResult(false, "UNT Error:" + sOAPFaultException.getMessage());
                    }
                } else {
                    bl = false;
                }
            } else if (null != usernameToken.getCreated()) {
                bl = false;
            }
        }
        return new SecurityTokenValidateResult(bl, usernameToken.toString());
    }

    public SecurityTokenValidateResult validateProcessed(SecurityToken securityToken, MessageContext messageContext) {
        if (!UsernameTokenHandler.hasPassword((UsernameToken)securityToken)) {
            WSSecurityContext wSSecurityContext = WSSecurityContext.getSecurityContext(messageContext);
            Node node = wSSecurityContext.getNode(securityToken);
            List list = wSSecurityContext.getSignatures();
            for (SignatureInfo signatureInfo : list) {
                if (!signatureInfo.containsNode(node)) continue;
                return new SecurityTokenValidateResult(true);
            }
            return new SecurityTokenValidateResult(false);
        }
        return new SecurityTokenValidateResult(true);
    }

    public boolean matches(SecurityToken securityToken, String string, String string2, ContextHandler contextHandler, Purpose purpose) {
        if (securityToken == null) {
            return false;
        }
        if (!Purpose.IDENTITY.equals(purpose)) {
            return false;
        }
        if (!(securityToken instanceof UsernameToken)) {
            return false;
        }
        return this.matches((UsernameToken)securityToken, contextHandler);
    }

    private boolean matches(UsernameToken usernameToken, ContextHandler contextHandler) {
        Object object = contextHandler.getValue("weblogic.xml.crypto.wss.policy.Claims");
        if (object != null) {
            Node node = (Node)object;
            LogUtils.logWss("Trying to match UsernameToken to assertion " + Util.printNode(node));
            String string = ClaimsBuilder.getClaimFromAttr(node, WSSConstants.POLICY_USE_PASSWD_QNAME, WSSConstants.POLICY_USE_PASSWD_TYPE_QNAME);
            if (string != null && !this.isSamePasswordType(string, usernameToken.getPasswordType())) {
                LogUtils.logWss("Password type " + usernameToken.getPasswordType() + " does not match.");
                return false;
            }
            String string2 = ClaimsBuilder.getClaimFromAttr(node, WSSConstants.POLICY_USE_PASSWD_QNAME, UsernameTokenImpl.POLICY_PASSWD_ATTR);
            if (null != string2) {
                LogUtils.logWss("Trying to match UsernameToken to Nonce and Created assertions");
                if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#NonceCreate".equals(string2)) {
                    if (usernameToken.getCreated() == null) {
                        LogUtils.logWss("Missing Created element in UNT");
                        return false;
                    }
                    if (usernameToken.getEncodedNonce() == null) {
                        LogUtils.logWss("Missing Nonce element in UNT");
                        return false;
                    }
                } else {
                    if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#Nonce".equals(string2) && usernameToken.getEncodedNonce() == null) {
                        LogUtils.logWss("Missing Encoded Nonce in UNT");
                        return false;
                    }
                    if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#Create".equals(string2) && usernameToken.getCreated() == null) {
                        LogUtils.logWss("Missing Created in UNT");
                        return false;
                    }
                }
            }
            if (string != null && !this.isSamePasswordType(string, usernameToken.getPasswordType())) {
                LogUtils.logWss("Password type " + usernameToken.getPasswordType() + " does not match.");
                return false;
            }
        }
        return true;
    }

    private boolean isSamePasswordType(String string, String string2) {
        if (string.equals(string2)) {
            return true;
        }
        if (string2.equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText") && string.equals(OLD_PASSWORD_TYPE_TEXT)) {
            return true;
        }
        return string2.equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest") && string.equals(OLD_PASSWORD_TYPE_DIGEST);
    }

    public Subject getSubject(SecurityToken securityToken, MessageContext messageContext) throws WSSecurityException {
        UsernameToken usernameToken = (UsernameToken)securityToken;
        String string = SecurityServiceManager.getDefaultRealmName();
        if (UsernameTokenHandler.hasPassword(usernameToken)) {
            return SecurityUtils.assertIdentity(usernameToken, string);
        }
        return null;
    }

    private static boolean hasPassword(UsernameToken usernameToken) {
        return usernameToken.getPassword() != null || usernameToken.getPasswordDigest() != null;
    }

    public SecurityToken getSecurityToken(String string, Object object, ContextHandler contextHandler) throws WSSecurityException {
        if (object != null) {
            return new UsernameTokenImpl((UsernameAndPassword)object, contextHandler);
        }
        return null;
    }

    public SecurityToken getSecurityToken(String string, String string2, Purpose purpose, ContextHandler contextHandler) throws WSSecurityException {
        return null;
    }

    public SecurityToken newSecurityToken(Node node) throws weblogic.xml.crypto.api.MarshalException {
        UsernameTokenImpl usernameTokenImpl = new UsernameTokenImpl();
        try {
            usernameTokenImpl.unmarshal(node);
        }
        catch (MarshalException marshalException) {
            throw new weblogic.xml.crypto.api.MarshalException("Failed to unmarshal UserNameToken.", marshalException);
        }
        return usernameTokenImpl;
    }

    public QName[] getQNames() {
        return qnames;
    }

    public SecurityTokenReference getSTR(QName qName, String string, SecurityToken securityToken) throws WSSecurityException {
        return new UsernameTokenReference(qName, string, securityToken);
    }

    public SecurityTokenReference newSecurityTokenReference(Node node) {
        return new UsernameTokenReference();
    }

    public void setPasswordDigestSupported(boolean bl) {
        this.passwordDigestSupported = bl;
    }

    public boolean isPasswordDigestSupported() {
        return this.passwordDigestSupported;
    }
}

