/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.wss;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import weblogic.security.UsernameAndPassword;
import weblogic.security.WSUserPasswordDigest;
import weblogic.security.service.ContextHandler;
import weblogic.security.utils.PasswordDigestUtils;
import weblogic.utils.collections.ConcurrentHashMap;
import weblogic.xml.crypto.utils.DOMUtils;
import weblogic.xml.crypto.wss.Base64Encoding;
import weblogic.xml.crypto.wss.SecurityTokenImpl;
import weblogic.xml.crypto.wss.TimestampImpl;
import weblogic.xml.crypto.wss.UsernameTokenHandler;
import weblogic.xml.crypto.wss.WSSConstants;
import weblogic.xml.crypto.wss.WSSecurityConfigurationException;
import weblogic.xml.crypto.wss.WSSecurityException;
import weblogic.xml.crypto.wss.api.Encoding;
import weblogic.xml.crypto.wss.api.UsernameToken;
import weblogic.xml.crypto.wss.policy.ClaimsBuilder;
import weblogic.xml.crypto.wss.provider.Purpose;
import weblogic.xml.crypto.wss.provider.SecurityToken;
import weblogic.xml.crypto.wss.provider.SecurityTokenHandler;
import weblogic.xml.crypto.wss.provider.SecurityTokenPolicyInfo;
import weblogic.xml.dom.marshal.MarshalException;
import weblogic.xml.schema.types.XSDDateTime;
import weblogic.xml.security.utils.Utils;

public class UsernameTokenImpl
extends SecurityTokenImpl
implements UsernameToken,
SecurityTokenPolicyInfo,
WSUserPasswordDigest,
Serializable {
    private static final long serialVersionUID = 9185634049782890759L;
    private static final String[] valueTypes = new String[]{"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken"};
    private static final String defaultNonceEncodingType = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary";
    private static final String defaultPasswordType = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText";
    private static final boolean defaultUsePassword = true;
    private static final String DIGEST_ALGORITHM = "SHA-1";
    private static final String ASCII = "US-ASCII";
    private static final String UTF_8 = "UTF-8";
    private static final String ID_PREFIX = "unt";
    private static final String POLICY_URI = "http://www.bea.com/wls90/security/policy";
    private static final QName POLICY_USE_PASSWD = new QName("http://www.bea.com/wls90/security/policy", "UsePassword");
    private static final QName POLICY_PASSWD_TYPE = new QName("Type");
    public static final QName POLICY_PASSWD_ATTR = new QName("Attribute");
    private static final ConcurrentHashMap encodings = new ConcurrentHashMap();
    private static final short USERNAME = 0;
    private static final short PWD = 1;
    private static final short NONCE = 2;
    private static final short CREATED = 3;
    private String id;
    private String username;
    private transient char[] password;
    private transient String passwordDigest;
    private transient byte[] decodedPwdDigest;
    private String passwordType = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText";
    private boolean usePassword = true;
    private String passwordId;
    private byte[] nonce;
    private String encodedNonce;
    private String nonceEncodingType = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary";
    private boolean useNonce;
    private Calendar created;
    private String serializedCreated;
    private boolean useCreated;
    private transient UsernameAndPassword credential;

    public UsernameTokenImpl() {
    }

    private UsernameTokenImpl(UsernameAndPassword usernameAndPassword) throws WSSecurityException {
        this(usernameAndPassword, null);
    }

    public UsernameTokenImpl(UsernameAndPassword usernameAndPassword, ContextHandler contextHandler) throws WSSecurityException {
        super(usernameAndPassword);
        this.username = usernameAndPassword.getUsername();
        this.password = usernameAndPassword.getPassword();
        Node node = (Node)contextHandler.getValue("weblogic.xml.crypto.wss.policy.Claims");
        if (node != null && ClaimsBuilder.getClaimFromElt(node, POLICY_USE_PASSWD) != null) {
            this.passwordType = ClaimsBuilder.getClaimFromAttr(node, POLICY_USE_PASSWD, POLICY_PASSWD_TYPE);
        } else {
            this.usePassword = false;
            this.passwordType = null;
        }
        if (this.usePassword && this.password == null) {
            throw new WSSecurityException("No password provided for Password Type for UsernameToken: " + this.passwordType, WSSConstants.FAILURE_TOKEN_INVALID);
        }
        if (this.usePassword && this.password != null && !"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest".equals(this.passwordType) && !defaultPasswordType.equals(this.passwordType)) {
            throw new WSSecurityException("Invalid Password Type for UsernameToken: " + this.passwordType, WSSConstants.FAILURE_TOKEN_INVALID);
        }
        if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest".equals(this.passwordType)) {
            this.useNonce = true;
            this.useCreated = true;
        } else if (node != null) {
            String string = ClaimsBuilder.getClaimFromAttr(node, POLICY_USE_PASSWD, POLICY_PASSWD_ATTR);
            if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#NonceCreate".equals(string)) {
                this.useNonce = true;
                this.useCreated = true;
            } else if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#Nonce".equals(string)) {
                this.useNonce = true;
            } else if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#Create".equals(string)) {
                this.useCreated = true;
            }
        }
        this.id = DOMUtils.generateId(ID_PREFIX);
    }

    public static void initEncodings() {
        Base64Encoding base64Encoding = new Base64Encoding();
        UsernameTokenImpl.register(base64Encoding);
    }

    public static void register(Encoding encoding) {
        encodings.put((Object)encoding.getURI(), (Object)encoding);
    }

    public String getValueType() {
        return "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken";
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public PrivateKey getPrivateKey() {
        return null;
    }

    public PublicKey getPublicKey() {
        return null;
    }

    public Key getSecretKey() {
        return null;
    }

    public Object getCredential() {
        if (this.credential == null) {
            UsernameAndPassword usernameAndPassword;
            this.credential = usernameAndPassword = new UsernameAndPassword(this.username, this.password);
        }
        return this.credential;
    }

    public String getUsername() {
        return this.username;
    }

    public byte[] getDecodedPasswordDigest() {
        return this.decodedPwdDigest;
    }

    public byte[] getDecodedNonce() {
        return this.nonce;
    }

    public byte[] getPassword() {
        return this.password != null ? new String(this.password).getBytes() : null;
    }

    public String getPasswordType() {
        return this.passwordType;
    }

    public String getEncodedNonce() {
        return this.encodedNonce;
    }

    public String getNonceEncodingType() {
        return this.nonceEncodingType;
    }

    public Calendar getCreated() {
        return this.created;
    }

    public String getCreatedString() {
        return this.serializedCreated;
    }

    public SecurityToken getSecurityToken(String string, Object object, ContextHandler contextHandler) throws WSSecurityException {
        return new UsernameTokenImpl((UsernameAndPassword)object, contextHandler);
    }

    public void marshal(Element element, Node node, Map map) throws MarshalException {
        Element element2;
        Map map2 = DOMUtils.getNamespaceMap(element);
        String string = (String)map.get("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        String string2 = (String)map.get("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        Element element3 = DOMUtils.createElement(element, WSSConstants.UNT_QNAME, string);
        if (this.id != null) {
            DOMUtils.addPrefixedAttribute(element3, WSSConstants.WSU_ID_QNAME, string2, this.id);
            DOMUtils.declareNamespace(element3, WSSConstants.WSU_ID_QNAME.getNamespaceURI(), string2, map2);
        }
        Element element4 = DOMUtils.createAndAddElement(element3, WSSConstants.USERNAME_QNAME, string);
        DOMUtils.addText(element4, this.username);
        if (this.usePassword) {
            element2 = DOMUtils.createAndAddElement(element3, WSSConstants.PASSWORD_QNAME, string);
            if (this.passwordId != null) {
                DOMUtils.addPrefixedAttribute(element2, WSSConstants.WSU_ID_QNAME, string2, this.passwordId);
                DOMUtils.declareNamespace(element2, WSSConstants.WSU_ID_QNAME.getNamespaceURI(), string2, map2);
            }
            DOMUtils.addAttribute(element2, WSSConstants.TYPE_QNAME, this.passwordType);
            if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest".equals(this.passwordType)) {
                this.createPasswordDigest();
                DOMUtils.addText(element2, this.passwordDigest);
            } else {
                if (this.useCreated) {
                    this.createCreated();
                }
                if (this.useNonce) {
                    this.createNonce();
                }
                DOMUtils.addText(element2, new String(this.password));
            }
        }
        if (this.useNonce) {
            element2 = DOMUtils.createAndAddElement(element3, WSSConstants.NONCE_QNAME, string);
            DOMUtils.addAttribute(element2, WSSConstants.ENCODING_TYPE_QNAME, this.nonceEncodingType);
            DOMUtils.addText(element2, this.encodedNonce);
        }
        if (this.useCreated) {
            element2 = DOMUtils.createAndAddElement(element3, WSSConstants.CREATED_QNAME, string2);
            DOMUtils.addText(element2, XSDDateTime.getXml((Calendar)this.created));
        }
        if (node != null) {
            element.insertBefore(element3, node);
        } else {
            element.appendChild(element3);
        }
    }

    public void unmarshal(Node node) throws MarshalException {
        Element element = (Element)node;
        this.id = DOMUtils.getAttributeValue(element, WSSConstants.WSU_ID_QNAME);
        Element element2 = DOMUtils.getFirstElement(element);
        if (element2 == null) {
            throw new MarshalException("UsernameToken is empty.");
        }
        DOMUtils.require(element2, WSSConstants.USERNAME_QNAME);
        if (null == element2.getFirstChild()) {
            throw new MarshalException("UsernameToken username is empty.");
        }
        this.username = DOMUtils.getText(element2);
        Element element3 = DOMUtils.getNextElement(element2);
        while (element3 != null) {
            if (DOMUtils.is(element3, WSSConstants.PASSWORD_QNAME)) {
                this.unmarshalPassword(element3);
            } else if (DOMUtils.is(element3, WSSConstants.NONCE_QNAME)) {
                this.unmarshalNonce(element3);
            } else if (DOMUtils.is(element3, WSSConstants.CREATED_QNAME)) {
                this.unmarshalCreated(element3);
            } else {
                throw new MarshalException("Unsupported child element " + DOMUtils.getQName(element3) + " in " + "UsernameToken");
            }
            element3 = DOMUtils.getNextElement(element3);
        }
    }

    private void createCreated() {
        this.created = TimestampImpl.getCalendar();
        this.serializedCreated = XSDDateTime.getXml((Calendar)this.created);
    }

    private void createNonce() {
        this.nonce = Utils.generateNonce(32);
        this.encodedNonce = ((Encoding)encodings.get((Object)this.nonceEncodingType)).encode(this.nonce);
    }

    private void createPasswordDigest() {
        try {
            if (this.useCreated) {
                this.createCreated();
            }
            if (this.useNonce) {
                this.createNonce();
            }
            byte[] byArray = PasswordDigestUtils.passwordDigest(this.nonce, this.getCreatedString(), new String(this.password).getBytes(UTF_8));
            Encoding encoding = (Encoding)encodings.get((Object)defaultNonceEncodingType);
            this.passwordDigest = encoding.encode(byArray);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    private void unmarshalCreated(Element element) throws MarshalException {
        if (null == element.getFirstChild() || null == DOMUtils.getText(element)) {
            throw new MarshalException("Invalid Createde.");
        }
        if (this.serializedCreated != null) {
            throw new MarshalException("Only one Created element allowed in UsernameToken.");
        }
        this.serializedCreated = DOMUtils.getText(element);
        this.created = XSDDateTime.convertXml((String)this.serializedCreated);
    }

    private void unmarshalNonce(Element element) throws MarshalException {
        if (this.encodedNonce != null) {
            throw new MarshalException("Only one Nonce element allowed in UsernameToken.");
        }
        if (null == element.getFirstChild() || null == DOMUtils.getText(element)) {
            throw new MarshalException("Invalid Nonce.");
        }
        this.nonceEncodingType = DOMUtils.getAttributeValue(element, WSSConstants.ENCODING_TYPE_QNAME, defaultNonceEncodingType);
        this.encodedNonce = DOMUtils.getText(element);
        this.nonce = ((Encoding)encodings.get((Object)this.nonceEncodingType)).decode(this.encodedNonce);
    }

    private void unmarshalPassword(Element element) throws MarshalException {
        if (this.password != null || this.passwordDigest != null) {
            throw new MarshalException("Only one Password element allowed in UsernameToken.");
        }
        if (null == element.getFirstChild() || null == DOMUtils.getText(element)) {
            throw new MarshalException("Invalid Password.");
        }
        this.passwordId = DOMUtils.getAttributeValue(element, WSSConstants.WSU_ID_QNAME);
        String string = DOMUtils.getAttributeValue(element, WSSConstants.TYPE_QNAME);
        if (string != null) {
            this.passwordType = string;
        }
        if (defaultPasswordType.equals(this.passwordType)) {
            this.password = DOMUtils.getText(element).toCharArray();
        } else if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest".equals(this.passwordType)) {
            this.passwordDigest = DOMUtils.getText(element);
            this.decodedPwdDigest = Utils.base64(this.passwordDigest);
        } else {
            throw new MarshalException("Invalid Password Type.");
        }
    }

    public boolean isFeatureSupported(String string) {
        return false;
    }

    public boolean supports(Purpose purpose) {
        return Purpose.IDENTITY.equals(purpose);
    }

    public Element getSecurityTokenAssertion(Element element, Purpose purpose, ContextHandler contextHandler) throws WSSecurityConfigurationException {
        String string = DOMUtils.getPrefix(POLICY_URI, element);
        Element element2 = DOMUtils.createAndAddElement(element, WSSConstants.POLICY_TOKEN_QNAME, string);
        DOMUtils.addAttribute(element2, WSSConstants.POLICY_TOKEN_TYPE_QNAME, valueTypes[0]);
        Element element3 = DOMUtils.createAndAddElement(element2, WSSConstants.POLICY_USE_PASSWD_QNAME, string);
        boolean bl = false;
        List list = (List)contextHandler.getValue("com.bea.contextelement.wsee.tokenHandlers");
        if (list != null) {
            for (SecurityTokenHandler securityTokenHandler : list) {
                if (!(securityTokenHandler instanceof UsernameTokenHandler)) continue;
                bl = ((UsernameTokenHandler)securityTokenHandler).isPasswordDigestSupported();
                break;
            }
        }
        if (bl) {
            DOMUtils.addAttribute(element3, WSSConstants.POLICY_USE_PASSWD_TYPE_QNAME, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest");
        } else {
            DOMUtils.addAttribute(element3, WSSConstants.POLICY_USE_PASSWD_TYPE_QNAME, defaultPasswordType);
        }
        return element2;
    }

    public String getNonce() {
        return this.getEncodedNonce();
    }

    public long getCreatedTimeInMillis() {
        return this.getCreated().getTimeInMillis();
    }

    public String getPasswordDigest() {
        return this.passwordDigest;
    }

    static {
        UsernameTokenImpl.initEncodings();
    }
}

