/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.wss;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.wsee.security.configuration.TimestampConfiguration;
import weblogic.xml.crypto.NodeURIDereferencer;
import weblogic.xml.crypto.api.KeySelector;
import weblogic.xml.crypto.api.URIDereferencer;
import weblogic.xml.crypto.api.XMLCryptoContext;
import weblogic.xml.crypto.api.dom.DOMIdMap;
import weblogic.xml.crypto.common.keyinfo.KeyProvider;
import weblogic.xml.crypto.common.keyinfo.KeyResolver;
import weblogic.xml.crypto.common.keyinfo.KeySelectorResultImpl;
import weblogic.xml.crypto.dom.DOMIdMapImpl;
import weblogic.xml.crypto.dsig.XMLSignatureFactoryImpl;
import weblogic.xml.crypto.dsig.XMLSignatureImpl;
import weblogic.xml.crypto.dsig.api.Reference;
import weblogic.xml.crypto.dsig.api.XMLSignature;
import weblogic.xml.crypto.dsig.api.XMLSignatureFactory;
import weblogic.xml.crypto.encrypt.api.XMLEncryptionException;
import weblogic.xml.crypto.encrypt.api.XMLEncryptionFactory;
import weblogic.xml.crypto.utils.DOMUtils;
import weblogic.xml.crypto.utils.LogUtils;
import weblogic.xml.crypto.wss.BinarySecurityTokenHandler;
import weblogic.xml.crypto.wss.Encryption;
import weblogic.xml.crypto.wss.SecurityTokenReferenceImpl;
import weblogic.xml.crypto.wss.TimestampHandler;
import weblogic.xml.crypto.wss.UsernameTokenHandler;
import weblogic.xml.crypto.wss.WSSConstants;
import weblogic.xml.crypto.wss.WSSecurityException;
import weblogic.xml.crypto.wss.WSSecurityInfo;
import weblogic.xml.crypto.wss.WrapperCredentialProvider;
import weblogic.xml.crypto.wss.X509V3BSTType;
import weblogic.xml.crypto.wss.api.BinarySecurityToken;
import weblogic.xml.crypto.wss.api.BinarySecurityTokenType;
import weblogic.xml.crypto.wss.api.Timestamp;
import weblogic.xml.crypto.wss.api.WSSecurityFactory;
import weblogic.xml.crypto.wss.provider.CredentialProvider;
import weblogic.xml.crypto.wss.provider.SecurityToken;
import weblogic.xml.crypto.wss.provider.SecurityTokenHandler;
import weblogic.xml.crypto.wss.provider.SecurityTokenReference;
import weblogic.xml.dom.marshal.MarshalException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSSecurityContext
implements DOMIdMap,
XMLCryptoContext,
WSSecurityInfo,
Serializable {
    private static final long serialVersionUID = -4276590520722987533L;
    public static final String WS_SECURITY_CONTEXT = "weblogic.xml.crypto.wss.WSSecurityContext";
    public static final String MESSAGE_CONTEXT = "javax.xml.rpc.handler.MessageContext";
    public static final String CREDENTIAL_PROVIDER_LIST = "weblogic.wsee.security.wss.CredentialProviderList";
    public static final String SERVER_CERTFILE = "weblogic.xml.crypto.wss.provider.ServerCertfile";
    public static final String SERVER_KEYFILE = "weblogic.xml.crypto.wss.provider.ServerKeyfile";
    public static final String TRUST_MANAGER = "weblogic.wsee.security.wss.TrustManager";
    public static final String END_POINT_URL = "weblogic.wsee.security.wss.end_point_url";
    private static final String[] SAML_TOKEN_TYPE_URIS = new String[]{"http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0", "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1", "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID", "http://docs.oasis-open.org/wss/2004/01/oasis-2004-01-saml-token-profile-1.0#SAMLAssertionID"};
    public static final String INCLUSIVE_NS_PREFIX_LIST = "com.bea.weblogic.xml.crypto.dsig.IncluisveNSPrefixList";
    private static final ThreadLocal context = new ThreadLocal(){

        protected Object initialValue() {
            return new ArrayList();
        }
    };
    private transient Node parent;
    private transient Element securityElement;
    private transient Node nextSibling;
    private transient DOMIdMap idMap;
    private Set idQNames = new HashSet();
    private transient URIDereferencer uriDereferencer;
    private transient Map namespaces;
    private Map properties;
    private transient List securityTokens;
    private transient List cachedTokens;
    private transient List idTokens;
    private transient Map tokenMap;
    private transient Map nodeMap;
    private transient Map strMap;
    private transient Map strIdMap;
    private transient List signatures;
    private transient List encryptions;
    private transient Timestamp timestamp;
    private transient TimestampHandler timestampHandler;
    private transient List keyProviders;
    private transient KeyResolver keySelector;
    private transient List tokenOrderList;
    private transient Map tokenHandlers;
    private transient Map credentialProviders;
    private transient Map BSTTypes;
    private transient XMLEncryptionFactory encryptionFactory;
    private transient XMLSignatureFactory signatureFactory;
    private transient WSSecurityFactory securityFactory;

    protected void init() {
        this.tokenHandlers = new LinkedHashMap();
        this.setTokenHandler(new BinarySecurityTokenHandler());
        this.setTokenHandler(new UsernameTokenHandler());
        this.setTimestampHandler(new TimestampConfiguration());
        this.credentialProviders = new LinkedHashMap();
        this.BSTTypes = new HashMap();
        this.keyProviders = new ArrayList();
        this.idTokens = new ArrayList();
        this.tokenMap = new HashMap();
        this.nodeMap = new HashMap();
        this.strMap = new HashMap();
        this.strIdMap = new HashMap();
        this.signatures = new ArrayList();
        this.encryptions = new ArrayList();
        this.securityTokens = new ArrayList();
        this.cachedTokens = new ArrayList();
        this.setBSTType(new X509V3BSTType());
        this.signatureFactory = new XMLSignatureFactoryImpl();
        try {
            this.encryptionFactory = XMLEncryptionFactory.getInstance();
        }
        catch (XMLEncryptionException xMLEncryptionException) {
            // empty catch block
        }
        this.securityFactory = WSSecurityFactory.getInstance();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.init();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.properties.remove(MESSAGE_CONTEXT);
        objectOutputStream.defaultWriteObject();
    }

    public WSSecurityContext(SOAPMessageContext sOAPMessageContext) throws SOAPException {
        this.idQNames.addAll(WSSConstants.BUILTIN_ID_QNAMES);
        this.properties = new HashMap();
        this.securityTokens = new ArrayList();
        this.cachedTokens = new ArrayList();
        this.idTokens = new ArrayList();
        this.tokenMap = new HashMap();
        this.nodeMap = new HashMap();
        this.strMap = new HashMap();
        this.strIdMap = new HashMap();
        this.signatures = new ArrayList();
        this.encryptions = new ArrayList();
        this.keyProviders = new ArrayList();
        this.init();
        this.init(sOAPMessageContext);
    }

    public WSSecurityContext(Node node) {
        this.idQNames.addAll(WSSConstants.BUILTIN_ID_QNAMES);
        this.properties = new HashMap();
        this.securityTokens = new ArrayList();
        this.cachedTokens = new ArrayList();
        this.idTokens = new ArrayList();
        this.tokenMap = new HashMap();
        this.nodeMap = new HashMap();
        this.strMap = new HashMap();
        this.strIdMap = new HashMap();
        this.signatures = new ArrayList();
        this.encryptions = new ArrayList();
        this.keyProviders = new ArrayList();
        this.init();
        this.init(node.getParentNode(), null, null, null);
        this.securityElement = (Element)node;
    }

    public WSSecurityContext(Node node, Node node2, Set set, Map map) {
        this.idQNames.addAll(WSSConstants.BUILTIN_ID_QNAMES);
        this.properties = new HashMap();
        this.securityTokens = new ArrayList();
        this.cachedTokens = new ArrayList();
        this.idTokens = new ArrayList();
        this.tokenMap = new HashMap();
        this.nodeMap = new HashMap();
        this.strMap = new HashMap();
        this.strIdMap = new HashMap();
        this.signatures = new ArrayList();
        this.encryptions = new ArrayList();
        this.keyProviders = new ArrayList();
        this.init();
        this.init(node, node2, set, map);
    }

    @Override
    public Element getElementById(String string) {
        return this.idMap.getElementById(string);
    }

    @Override
    public void setIdAttributeNS(Element element, String string, String string2) {
        this.idMap.setIdAttributeNS(element, string, string2);
    }

    public Node getNode() {
        return this.parent;
    }

    public Node getNextSibling() {
        return this.nextSibling;
    }

    public void setSecurityElement(Element element) {
        this.securityElement = element;
    }

    public Element getSecurityElement() {
        return this.securityElement;
    }

    @Override
    public URIDereferencer getURIDereferencer() {
        return this.uriDereferencer;
    }

    @Override
    public void setBaseURI(String string) {
    }

    @Override
    public void setKeySelector(KeySelector keySelector) {
    }

    @Override
    public void setURIDereferencer(URIDereferencer uRIDereferencer) {
        this.uriDereferencer = uRIDereferencer;
    }

    public Map getNamespaces() {
        return this.namespaces;
    }

    public void addIdQNames(Set set) {
        set.addAll(set);
    }

    public Set getIdQNames() {
        return this.idQNames;
    }

    @Override
    public Object setProperty(String string, Object object) {
        return this.properties.put(string, object);
    }

    @Override
    public Object getProperty(String string) {
        return this.properties.get(string);
    }

    public void addSecurityToken(SecurityToken securityToken) {
        if (!this.securityTokens.contains(securityToken)) {
            this.securityTokens.add(securityToken);
        }
    }

    @Override
    public List getSecurityTokens(String string) {
        ArrayList<SecurityToken> arrayList = new ArrayList<SecurityToken>();
        for (SecurityToken securityToken : this.securityTokens) {
            if (!securityToken.getValueType().equals(string)) continue;
            arrayList.add(securityToken);
        }
        for (SecurityToken securityToken : this.cachedTokens) {
            if (!securityToken.getValueType().equals(string)) continue;
            arrayList.add(securityToken);
        }
        return arrayList;
    }

    @Override
    public List getSecurityTokens() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.securityTokens);
        arrayList.addAll(this.cachedTokens);
        return arrayList;
    }

    protected List getCurrentTokens() {
        return this.securityTokens;
    }

    public void addToken(SecurityToken securityToken, Element element) {
        this.tokenMap.put(element, securityToken);
        this.nodeMap.put(securityToken, element);
    }

    public SecurityToken getToken(Element element) {
        return (SecurityToken)this.tokenMap.get(element);
    }

    public Node getNode(SecurityToken securityToken) {
        return (Node)this.nodeMap.get(securityToken);
    }

    public void addSTR(SecurityTokenReference securityTokenReference, SecurityToken securityToken) {
        this.strMap.put(securityToken, securityTokenReference);
        this.addSecurityToken(securityToken);
    }

    public void addKeyInfo(String string, SecurityToken securityToken) {
        this.strMap.put(securityToken, string);
    }

    public void addSTR(String string, SecurityTokenReference securityTokenReference) {
        this.strIdMap.put(string, securityTokenReference);
    }

    public SecurityTokenReference getSTR(String string) {
        return (SecurityTokenReference)this.strIdMap.get(string);
    }

    public Object getSTR(SecurityToken securityToken) {
        return this.strMap.get(securityToken);
    }

    public void setTimestamp(Timestamp timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public Timestamp getTimestamp() {
        return this.timestamp;
    }

    public void addSignature(XMLSignature xMLSignature) {
        this.signatures.add(xMLSignature);
    }

    @Override
    public List getSignatures() {
        return this.signatures;
    }

    public void addEncryption(Encryption encryption) {
        this.encryptions.add(encryption);
    }

    @Override
    public List getEncryptions() {
        return this.encryptions;
    }

    public void addKeyProvider(KeyProvider keyProvider) {
        this.keyProviders.add(0, keyProvider);
        if (this.keySelector != null) {
            this.keySelector.addKeyProvider(keyProvider);
        }
    }

    private KeyProvider[] getKeyProviders() {
        KeyProvider[] keyProviderArray = new KeyProvider[this.keyProviders.size()];
        this.keyProviders.toArray(keyProviderArray);
        return keyProviderArray;
    }

    @Override
    public String getBaseURI() {
        return null;
    }

    @Override
    public KeySelector getKeySelector() {
        if (this.keySelector == null) {
            this.keySelector = new KeyResolver(this.getKeyProviders());
        }
        return this.keySelector;
    }

    public void setTokenHandler(SecurityTokenHandler securityTokenHandler) {
        if (null == securityTokenHandler) {
            WSSecurityContext.log("Skip a null security token handeler");
            return;
        }
        this.fillMap(this.tokenHandlers, securityTokenHandler.getValueTypes(), securityTokenHandler);
        this.fillMap(this.tokenHandlers, securityTokenHandler.getQNames(), securityTokenHandler);
        SecurityTokenReferenceImpl.register(securityTokenHandler);
    }

    public SecurityTokenHandler getRequiredTokenHandler(Object object) throws WSSecurityException {
        SecurityTokenHandler securityTokenHandler = (SecurityTokenHandler)this.tokenHandlers.get(object);
        if (securityTokenHandler != null) {
            return securityTokenHandler;
        }
        throw new WSSecurityException("No token handler found for " + object, WSSConstants.UNSUPPORTED_TOKEN);
    }

    public SecurityTokenHandler getTokenHandler(Object object) throws WSSecurityException {
        return (SecurityTokenHandler)this.tokenHandlers.get(object);
    }

    public Iterator getTokenHandlers() {
        return this.tokenHandlers.values().iterator();
    }

    public CredentialProvider getCredentialProvider(Object object) {
        return (CredentialProvider)this.credentialProviders.get(object);
    }

    public CredentialProvider getRequiredCredentialProvider(Object object) throws WSSecurityException {
        CredentialProvider credentialProvider = (CredentialProvider)this.credentialProviders.get(object);
        if (credentialProvider != null) {
            return credentialProvider;
        }
        throw new WSSecurityException("No credential provider found for " + object);
    }

    public void setCredentialProvider(CredentialProvider credentialProvider) {
        this.fillMap(this.credentialProviders, credentialProvider.getValueTypes(), credentialProvider);
    }

    public Map getCredentialProviders() {
        return this.credentialProviders;
    }

    public void setBSTType(BinarySecurityTokenType binarySecurityTokenType) {
        this.BSTTypes.put(binarySecurityTokenType.getValueType(), binarySecurityTokenType);
    }

    public BinarySecurityTokenType getBSTType(String string) {
        return (BinarySecurityTokenType)this.BSTTypes.get(string);
    }

    public XMLEncryptionFactory getEncryptionFactory() {
        return this.encryptionFactory;
    }

    public void setEncryptionFactory(XMLEncryptionFactory xMLEncryptionFactory) {
        this.encryptionFactory = xMLEncryptionFactory;
    }

    public XMLSignatureFactory getSignatureFactory() {
        return this.signatureFactory;
    }

    public void setSignatureFactory(XMLSignatureFactory xMLSignatureFactory) {
        this.signatureFactory = xMLSignatureFactory;
    }

    public void setSecurityFactory(WSSecurityFactory wSSecurityFactory) {
        this.securityFactory = wSSecurityFactory;
    }

    public WSSecurityFactory getSecurityFactory() {
        return this.securityFactory;
    }

    private void fillMap(Map map, Object[] objectArray, Object object) {
        for (int i = 0; i < objectArray.length; ++i) {
            map.put(objectArray[i], object);
        }
    }

    public MessageContext getMessageContext() {
        return (MessageContext)this.properties.get(MESSAGE_CONTEXT);
    }

    public static WSSecurityContext getSecurityContext(MessageContext messageContext) {
        if (null == messageContext) {
            return null;
        }
        return (WSSecurityContext)messageContext.getProperty(WS_SECURITY_CONTEXT);
    }

    public static Map getCredentialProviders(MessageContext messageContext) {
        Map map = null;
        WSSecurityContext wSSecurityContext = WSSecurityContext.getSecurityContext(messageContext);
        if (wSSecurityContext != null) {
            map = wSSecurityContext.getCredentialProviders();
        }
        return map;
    }

    public void init(SOAPMessageContext sOAPMessageContext) throws SOAPException {
        Object object = sOAPMessageContext.getMessage().getSOAPHeader();
        if (object == null) {
            object = WSSecurityContext.createSOAPHeader(sOAPMessageContext);
        }
        this.init((Node)object, null, null, null);
        this.setProperty(MESSAGE_CONTEXT, sOAPMessageContext);
        sOAPMessageContext.setProperty(WS_SECURITY_CONTEXT, (Object)this);
    }

    public void init(Node node, Node node2, Set set, Map map) {
        if (node == null) {
            throw new NullPointerException("Parent node of Security element must not be null.");
        }
        this.parent = node;
        this.nextSibling = node2;
        this.namespaces = map != null ? map : DOMUtils.getNSMap(node);
        this.addWSSNamespaces(this.namespaces);
        if (set != null) {
            this.idQNames.addAll(set);
        }
        Document document = node.getOwnerDocument();
        this.uriDereferencer = new NodeURIDereferencer(document, DOMUtils.getNSMap(node));
        this.idMap = new DOMIdMapImpl(document, this.idQNames, this.namespaces);
    }

    private void addWSSNamespaces(Map map) {
        WSSecurityContext.addNamespace(map, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu");
        WSSecurityContext.addNamespace(map, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu");
    }

    private static void addNamespace(Map map, String string, String string2) {
        if (map.get(string) == null) {
            map.put(string, string2);
        }
    }

    private static Node createSOAPHeader(SOAPMessageContext sOAPMessageContext) throws SOAPException {
        return sOAPMessageContext.getMessage().getSOAPPart().getEnvelope().addHeader();
    }

    public List<BinarySecurityToken> getBinarySecurityTokens() {
        if (null == this.tokenMap || this.tokenMap.isEmpty()) {
            return null;
        }
        Collection collection = this.tokenMap.values();
        ArrayList<BinarySecurityToken> arrayList = new ArrayList<BinarySecurityToken>();
        for (Object v : collection) {
            if (!(v instanceof BinarySecurityToken)) continue;
            arrayList.add((BinarySecurityToken)v);
        }
        if (arrayList.isEmpty()) {
            WSSecurityContext.log("No BST tokens");
            return null;
        }
        WSSecurityContext.log("Found BinarySecurityToken, return with size =" + arrayList.size());
        return arrayList;
    }

    public List getIdTokens() {
        return this.idTokens;
    }

    public void addIdToken(SecurityToken securityToken) {
        if (!this.idTokens.contains(securityToken)) {
            this.idTokens.add(securityToken);
        }
    }

    public AuthenticatedSubject getSubject() throws WSSecurityException {
        AuthenticatedSubject authenticatedSubject = null;
        SOAPMessageContext sOAPMessageContext = (SOAPMessageContext)this.getProperty(MESSAGE_CONTEXT);
        List list = this.getIdTokens();
        WSSecurityContext.log("Number of identity tokens on context: " + list.size());
        if (list.size() > 0) {
            for (SecurityToken securityToken : this.getIdTokens()) {
                WSSecurityContext.log("Trying to get subject from identity token, type: " + securityToken.getValueType());
                authenticatedSubject = this.getSubject(securityToken, sOAPMessageContext);
                if (authenticatedSubject == null) continue;
                WSSecurityContext.log("Got subject from identity token, type: " + securityToken.getValueType());
                return authenticatedSubject;
            }
            throw new WSSecurityException("Failed to get subject from identity token.", WSSConstants.FAILURE_AUTH);
        }
        for (int i = 0; i < SAML_TOKEN_TYPE_URIS.length; ++i) {
            String string = SAML_TOKEN_TYPE_URIS[i];
            Object object = this.getSecurityTokens(string);
            WSSecurityContext.log("Number of SAML tokens (" + (String)string + ") on context: " + object.size());
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                SecurityToken securityToken = (SecurityToken)iterator.next();
                authenticatedSubject = this.getSubject(securityToken, sOAPMessageContext);
                if (authenticatedSubject == null) continue;
                WSSecurityContext.log("Got subject from non-identity token, type: " + securityToken.getValueType());
                return authenticatedSubject;
            }
        }
        List list2 = this.getSecurityTokens("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3");
        list2.addAll(this.getSecurityTokens("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v1"));
        for (Object object : list2) {
            authenticatedSubject = this.getSubject((SecurityToken)object, sOAPMessageContext);
            if (authenticatedSubject == null) continue;
            WSSecurityContext.log("Got subject from non-identity token, type: " + object.getValueType());
            return authenticatedSubject;
        }
        return authenticatedSubject;
    }

    private List getTokenOrder() {
        if (this.tokenOrderList == null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (SecurityTokenHandler securityTokenHandler : this.tokenHandlers.values()) {
                String[] stringArray = securityTokenHandler.getValueTypes();
                for (int i = 0; i < stringArray.length; ++i) {
                    arrayList.add(stringArray[i]);
                }
            }
            this.tokenOrderList = arrayList;
        }
        return this.tokenOrderList;
    }

    private AuthenticatedSubject getSubject(SecurityToken securityToken, SOAPMessageContext sOAPMessageContext) throws WSSecurityException {
        AuthenticatedSubject authenticatedSubject = null;
        SecurityTokenHandler securityTokenHandler = this.getRequiredTokenHandler(securityToken.getValueType());
        Subject subject = securityTokenHandler.getSubject(securityToken, (MessageContext)sOAPMessageContext);
        if (subject != null) {
            authenticatedSubject = AuthenticatedSubject.getFromSubject((Subject)subject);
        }
        return authenticatedSubject;
    }

    @Override
    public List getSignatures(SecurityToken securityToken) {
        ArrayList<XMLSignatureImpl> arrayList = new ArrayList<XMLSignatureImpl>();
        for (XMLSignatureImpl xMLSignatureImpl : this.signatures) {
            SecurityToken securityToken2 = ((KeySelectorResultImpl)xMLSignatureImpl.getSignatureValidateResult().getKeySelectorResult()).getSecurityToken();
            if (!securityToken.equals(securityToken2)) continue;
            arrayList.add(xMLSignatureImpl);
        }
        return arrayList;
    }

    @Override
    public List getEncryptions(SecurityToken securityToken) {
        ArrayList<Encryption> arrayList = new ArrayList<Encryption>();
        for (int i = 0; i < this.getEncryptions().size(); ++i) {
            Encryption encryption = (Encryption)this.getEncryptions().get(i);
            SecurityToken securityToken2 = ((KeySelectorResultImpl)encryption.getKeySelectorResult()).getSecurityToken();
            if (!securityToken.equals(securityToken2)) continue;
            arrayList.add(encryption);
        }
        return arrayList;
    }

    public XMLSignature getSignature(SecurityToken securityToken, MessageContext messageContext) throws WSSecurityException {
        for (XMLSignature xMLSignature : this.signatures) {
            List list = xMLSignature.getSignedInfo().getReferences();
            for (Reference reference : list) {
                String string = reference.getURI();
                if (string.length() < 2) continue;
                String string2 = string.substring(1);
                if (string2.equals(securityToken.getId())) {
                    return xMLSignature;
                }
                Element element = this.getElementById(string2);
                if (element == null) continue;
                SecurityTokenReference securityTokenReference = null;
                try {
                    securityTokenReference = SecurityTokenReferenceImpl.createAndUnmarshal(element);
                }
                catch (MarshalException marshalException) {
                    continue;
                }
                SecurityTokenHandler securityTokenHandler = this.getRequiredTokenHandler(securityTokenReference.getValueType());
                if (!securityToken.equals(securityTokenHandler.getSecurityToken(securityTokenReference, messageContext))) continue;
                return xMLSignature;
            }
        }
        return null;
    }

    public void reset() {
        if (this.idTokens != null) {
            this.idTokens.clear();
        }
        if (this.tokenMap != null) {
            this.tokenMap.clear();
        }
        if (this.nodeMap != null) {
            this.nodeMap.clear();
        }
        if (this.strMap != null) {
            this.strMap.clear();
        }
        if (this.strIdMap != null) {
            this.strIdMap.clear();
        }
        if (this.securityTokens != null && this.cachedTokens != null) {
            this.cachedTokens.addAll(this.securityTokens);
            this.securityTokens.clear();
        }
        if (this.signatures != null) {
            this.signatures.clear();
        }
    }

    public void setCredentialProviders(List list) {
        this.credentialProviders.clear();
        this.addCredentialProviders(list);
    }

    public void addCredentialProviders(List list) {
        for (CredentialProvider credentialProvider : list) {
            this.addCredentialProvider(credentialProvider);
        }
    }

    public void addCredentialProvider(CredentialProvider credentialProvider) {
        String[] stringArray = credentialProvider.getValueTypes();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (!this.credentialProviders.containsKey(string)) {
                this.credentialProviders.put(string, credentialProvider);
                continue;
            }
            this.credentialProviders.put(string, this.merge((CredentialProvider)this.credentialProviders.get(string), credentialProvider, string));
        }
    }

    private CredentialProvider merge(CredentialProvider credentialProvider, CredentialProvider credentialProvider2, String string) {
        return new WrapperCredentialProvider(credentialProvider, credentialProvider2, string);
    }

    public TimestampHandler getTimestampHandler() {
        return this.timestampHandler;
    }

    public void setTimestampHandler(TimestampHandler timestampHandler) {
        this.timestampHandler = timestampHandler;
    }

    private static void log(String string) {
        LogUtils.logWss(string);
    }

    public static void pushContext(WSSecurityContext wSSecurityContext) {
        ((List)context.get()).add(wSSecurityContext);
    }

    public static void popContext() {
        List list = (List)context.get();
        if (!list.isEmpty()) {
            list.remove(list.size() - 1);
        }
    }

    public static WSSecurityContext getCurrentContext() {
        List list = (List)context.get();
        return list.isEmpty() ? null : list.get(list.size() - 1);
    }
}

