/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.wss;

import java.security.cert.X509Certificate;
import weblogic.security.service.ContextHandler;
import weblogic.wsee.security.bst.ClientBSTCredentialProvider;
import weblogic.wsee.security.bst.StubPropertyBSTCredProv;
import weblogic.wsee.security.serviceref.ServiceRefBSTCredProv;
import weblogic.xml.crypto.utils.LogUtils;
import weblogic.xml.crypto.wss.provider.CredentialProvider;
import weblogic.xml.crypto.wss.provider.Purpose;

public class WrapperCredentialProvider
implements CredentialProvider {
    private CredentialProvider[] delegates = new CredentialProvider[2];
    private String type = null;
    private String[] types = new String[1];

    public WrapperCredentialProvider(CredentialProvider credentialProvider, CredentialProvider credentialProvider2, String string) throws IllegalArgumentException {
        if (credentialProvider == null || credentialProvider2 == null) {
            throw new IllegalArgumentException("Credenetial providers must not be null.");
        }
        if (!WrapperCredentialProvider.supports(credentialProvider, string) || !WrapperCredentialProvider.supports(credentialProvider2, string)) {
            throw new IllegalArgumentException("Credenetial providers must support type.");
        }
        this.delegates[0] = credentialProvider;
        this.delegates[1] = credentialProvider2;
        this.type = string;
        this.types[0] = string;
    }

    public String[] getValueTypes() {
        return this.types;
    }

    public Object getCredential(String string, String string2, ContextHandler contextHandler, Purpose purpose) {
        if (!this.type.equals(string)) {
            LogUtils.logWss("Token type " + string + " not supported.");
            return null;
        }
        for (int i = 0; i < this.delegates.length; ++i) {
            CredentialProvider credentialProvider = this.delegates[i];
            LogUtils.logWss("Trying to get credential for " + string + " and purpose " + purpose + " from delegate " + credentialProvider);
            Object object = credentialProvider.getCredential(string, string2, contextHandler, purpose);
            if (object == null) continue;
            LogUtils.logWss("Got credential for " + string + " and purpose " + purpose + " from delegate " + credentialProvider);
            return object;
        }
        LogUtils.logWss("No credential found for " + string + " and purpose " + purpose);
        return null;
    }

    public Object getCredentialByKeyIdentifier(String string, String string2, ContextHandler contextHandler, Purpose purpose) {
        if (!this.type.equals(string)) {
            LogUtils.logWss("Token type " + string + " not supported for KeyIdentifier.");
            return null;
        }
        for (int i = 0; i < this.delegates.length; ++i) {
            CredentialProvider credentialProvider = this.delegates[i];
            Object object = null;
            if (credentialProvider instanceof WrapperCredentialProvider) {
                LogUtils.logWss("Call getCredentialByKeyIdentifier() to get thumbprint/KeyIdentifier credential for " + string + " and purpose " + purpose + " from delegate " + credentialProvider);
                object = ((WrapperCredentialProvider)credentialProvider).getCredentialByKeyIdentifier(string, string2, contextHandler, purpose);
                if (null != object) {
                    LogUtils.logWss("Thumbs up!");
                }
            } else if (credentialProvider instanceof ServiceRefBSTCredProv) {
                LogUtils.logWss("Thumbs down!");
            } else {
                LogUtils.logWss("Trying to get thumbprint/KeyIdentifier credential for " + string + " and purpose " + purpose + " from delegate " + credentialProvider);
                object = credentialProvider.getCredential(string, string2, contextHandler, purpose);
            }
            if (object == null) continue;
            LogUtils.logWss("Got thumbprint/KeyIdentifier credential for " + string + " and purpose " + purpose + " from delegate " + credentialProvider);
            return object;
        }
        LogUtils.logWss("No thumbprint/KeyIdentifier credential found for " + string + " and purpose " + purpose);
        return null;
    }

    public boolean hasClientBSTCredentialProvider() {
        for (int i = 0; i < this.delegates.length; ++i) {
            WrapperCredentialProvider wrapperCredentialProvider;
            if (this.delegates[i] instanceof ClientBSTCredentialProvider) {
                return true;
            }
            if (!(this.delegates[i] instanceof WrapperCredentialProvider) || !(wrapperCredentialProvider = (WrapperCredentialProvider)this.delegates[i]).hasClientBSTCredentialProvider()) continue;
            return true;
        }
        return false;
    }

    public boolean hasStubPropertyBSTCredProv() {
        for (int i = 0; i < this.delegates.length; ++i) {
            WrapperCredentialProvider wrapperCredentialProvider;
            if (this.delegates[i] instanceof StubPropertyBSTCredProv) {
                return true;
            }
            if (!(this.delegates[i] instanceof WrapperCredentialProvider) || !(wrapperCredentialProvider = (WrapperCredentialProvider)this.delegates[i]).hasStubPropertyBSTCredProv()) continue;
            return true;
        }
        return false;
    }

    public WrapperCredentialProvider replaceServerCertOnClientBSTCredentialProvider(X509Certificate x509Certificate) {
        CredentialProvider[] credentialProviderArray = new CredentialProvider[2];
        for (int i = 0; i < this.delegates.length; ++i) {
            CredentialProvider credentialProvider;
            if (this.delegates[i] instanceof ClientBSTCredentialProvider) {
                credentialProvider = (ClientBSTCredentialProvider)this.delegates[i];
                credentialProviderArray[i] = ((ClientBSTCredentialProvider)credentialProvider).cloneAndReplaceServerCert(x509Certificate);
                continue;
            }
            if (this.delegates[i] instanceof StubPropertyBSTCredProv) {
                credentialProvider = (StubPropertyBSTCredProv)this.delegates[i];
                credentialProviderArray[i] = ((StubPropertyBSTCredProv)credentialProvider).cloneAndReplaceServerCert(x509Certificate);
                continue;
            }
            if (this.delegates[i] instanceof WrapperCredentialProvider) {
                credentialProvider = (WrapperCredentialProvider)this.delegates[i];
                if (((WrapperCredentialProvider)credentialProvider).hasClientBSTCredentialProvider() || ((WrapperCredentialProvider)credentialProvider).hasStubPropertyBSTCredProv()) {
                    credentialProviderArray[i] = ((WrapperCredentialProvider)credentialProvider).replaceServerCertOnClientBSTCredentialProvider(x509Certificate);
                    continue;
                }
                credentialProviderArray[i] = this.delegates[i];
                continue;
            }
            credentialProviderArray[i] = this.delegates[i];
        }
        return new WrapperCredentialProvider(credentialProviderArray[0], credentialProviderArray[1], this.type);
    }

    public static boolean supports(CredentialProvider credentialProvider, String string) {
        String[] stringArray = credentialProvider.getValueTypes();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return true;
        }
        return false;
    }
}

