/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.wss;

import java.io.InputStream;
import java.io.Serializable;
import java.security.cert.CertPath;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import javax.xml.rpc.handler.MessageContext;
import weblogic.utils.io.UnsyncByteArrayInputStream;
import weblogic.xml.crypto.utils.CertUtils;
import weblogic.xml.crypto.wss.BSTEncodingException;
import weblogic.xml.crypto.wss.X509Credential;
import weblogic.xml.crypto.wss.X509V3BSTType;
import weblogic.xml.crypto.wss.api.BinarySecurityToken;
import weblogic.xml.security.utils.Utils;

public class X509CertPath
extends X509V3BSTType
implements Serializable {
    private static final long serialVersionUID = 2196170009038509190L;
    public static final String PKI_PATH = "PkiPath";
    public static final String PKCS7_PATH = "PKCS7";
    private static final X509CertPath pkiPath = new X509CertPath("PkiPath", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509PKIPathv1");
    private static final X509CertPath pkcs7 = new X509CertPath("PKCS7", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#PKCS7");
    private String encoding;
    private String uri;

    private X509CertPath(String string, String string2) {
        this.encoding = string;
        this.uri = string2;
    }

    public static X509CertPath getPKIPath() {
        return pkiPath;
    }

    public static X509CertPath getPKCS7() {
        return pkcs7;
    }

    public String getValueType() {
        return this.uri;
    }

    public byte[] getUnencodedValue(Object object) throws BSTEncodingException {
        CertPath certPath = this.getCertPath(object);
        try {
            return certPath.getEncoded(this.encoding);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new BSTEncodingException("Failed to get bytes from certificate path.", certificateEncodingException);
        }
    }

    public Object getCredentials(byte[] byArray) {
        CertPath certPath = this.getCertPath(byArray);
        return new X509Credential(certPath);
    }

    private CertPath getCertPath(Object object) {
        return ((X509Credential)object).getCertPath();
    }

    private CertPath getCertPath(byte[] byArray) {
        CertPath certPath = null;
        UnsyncByteArrayInputStream unsyncByteArrayInputStream = new UnsyncByteArrayInputStream(byArray);
        try {
            certPath = Utils.getCertFactory().generateCertPath((InputStream)unsyncByteArrayInputStream, this.encoding);
        }
        catch (CertificateException certificateException) {
            throw new AssertionError((Object)("Unable to decode certificate path: " + certificateException));
        }
        return certPath;
    }

    public boolean validate(BinarySecurityToken binarySecurityToken, MessageContext messageContext) {
        return CertUtils.validateCertPath(((X509Credential)binarySecurityToken.getCredential()).getCertPath());
    }
}

