/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.wss;

import java.io.Serializable;
import java.security.PrivateKey;
import java.security.cert.CertPath;
import java.security.cert.X509Certificate;
import weblogic.xml.security.utils.Utils;

public class X509Credential
implements Serializable {
    private static final long serialVersionUID = 5618358587801780416L;
    private X509Certificate cert = null;
    private transient PrivateKey key = null;
    private byte[] keyIdentifier = null;
    private CertPath certPath = null;

    public X509Credential(X509Certificate x509Certificate) {
        this(x509Certificate, null);
    }

    public X509Credential(X509Certificate x509Certificate, PrivateKey privateKey) {
        this.cert = x509Certificate;
        this.key = privateKey;
    }

    public X509Credential(CertPath certPath) {
        this.certPath = certPath;
        this.cert = (X509Certificate)certPath.getCertificates().get(0);
    }

    public X509Credential(CertPath certPath, PrivateKey privateKey) {
        this(certPath);
        this.key = privateKey;
    }

    public X509Credential(byte[] byArray) {
        this.keyIdentifier = byArray;
    }

    public X509Certificate getCertificate() {
        return this.cert;
    }

    public PrivateKey getPrivateKey() {
        return this.key;
    }

    public byte[] getKeyIdentifier() {
        if (this.keyIdentifier != null) {
            return this.keyIdentifier;
        }
        if (this.cert != null) {
            this.keyIdentifier = Utils.getSubjectKeyIdentifier(this.cert);
        }
        return this.keyIdentifier;
    }

    public CertPath getCertPath() {
        if (this.certPath != null) {
            return this.certPath;
        }
        if (this.cert != null) {
            X509Certificate[] x509CertificateArray = new X509Certificate[]{this.cert};
            this.certPath = Utils.generateCertPath(x509CertificateArray);
        }
        return this.certPath;
    }

    public static boolean matches(X509Credential x509Credential, X509Credential x509Credential2) {
        CertPath certPath = x509Credential.getCertPath();
        if (certPath != null) {
            return certPath.equals(x509Credential2.getCertPath());
        }
        X509Certificate x509Certificate = x509Credential.getCertificate();
        return x509Certificate.equals(x509Credential2.getCertificate());
    }
}

