/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.wss;

import java.io.InputStream;
import java.io.Serializable;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import javax.xml.rpc.handler.MessageContext;
import weblogic.utils.io.UnsyncByteArrayInputStream;
import weblogic.xml.crypto.utils.CertUtils;
import weblogic.xml.crypto.wss.BSTEncodingException;
import weblogic.xml.crypto.wss.X509Credential;
import weblogic.xml.crypto.wss.api.BinarySecurityToken;
import weblogic.xml.crypto.wss.api.BinarySecurityTokenType;
import weblogic.xml.security.utils.Utils;

public class X509V1BSTType
implements BinarySecurityTokenType,
Serializable {
    private static final long serialVersionUID = -2072889451698561357L;

    public static void init() {
    }

    public String getValueType() {
        return "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v1";
    }

    public String getKeyIdentifierValueType() {
        throw new UnsupportedOperationException("not support for X509 V1");
    }

    public byte[] getUnencodedValue(Object object) throws BSTEncodingException {
        X509Certificate x509Certificate = this.getCertificate(object);
        try {
            return x509Certificate.getEncoded();
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new BSTEncodingException("Failed to get bytes from certificate.", certificateEncodingException);
        }
    }

    public byte[] getKeyIdRefValue(Object object) throws BSTEncodingException {
        throw new UnsupportedOperationException("not support for X509 V1");
    }

    public PublicKey getPublicKey(Object object) {
        return this.getCertificate(object).getPublicKey();
    }

    public PrivateKey getPrivateKey(Object object) {
        return ((X509Credential)object).getPrivateKey();
    }

    public SecretKey getSecretKey(Object object) {
        return null;
    }

    public X509Certificate getCertificate(Object object) {
        return ((X509Credential)object).getCertificate();
    }

    public Object getCredentials(byte[] byArray) {
        X509Certificate x509Certificate = this.getCertificate(byArray);
        return new X509Credential(x509Certificate, null);
    }

    public boolean validate(BinarySecurityToken binarySecurityToken, MessageContext messageContext) {
        return CertUtils.validateCertificate(binarySecurityToken.getCertificate());
    }

    public PublicKey getPublicKey(byte[] byArray) {
        X509Certificate x509Certificate = this.getCertificate(byArray);
        PublicKey publicKey = x509Certificate == null ? null : x509Certificate.getPublicKey();
        return publicKey;
    }

    public PrivateKey getPrivateKey(byte[] byArray) {
        return null;
    }

    public SecretKey getSecretKey(byte[] byArray) {
        return null;
    }

    public X509Certificate getCertificate(byte[] byArray) {
        X509Certificate x509Certificate = null;
        UnsyncByteArrayInputStream unsyncByteArrayInputStream = new UnsyncByteArrayInputStream(byArray);
        try {
            x509Certificate = (X509Certificate)Utils.getCertFactory().generateCertificate((InputStream)unsyncByteArrayInputStream);
        }
        catch (CertificateException certificateException) {
            throw new AssertionError((Object)("Unable to decode certificate: " + certificateException));
        }
        return x509Certificate;
    }
}

