/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.wss.nonce;

import weblogic.xml.crypto.utils.LogUtils;
import weblogic.xml.crypto.wss.TimestampHandler;
import weblogic.xml.crypto.wss.api.NonceValidator;
import weblogic.xml.crypto.wss.nonce.DisableNonceValidatorImpl;
import weblogic.xml.crypto.wss.nonce.NonceValidatorImpl;

public class NonceValidatorFactory {
    private static final boolean debug = false;
    private static NonceValidator singletonValidator = null;

    private NonceValidatorFactory() {
    }

    public static NonceValidator getInstance(String string, TimestampHandler timestampHandler) {
        if (singletonValidator == null) {
            if (null != string && string.length() > 0) {
                if ("none".equalsIgnoreCase(string)) {
                    singletonValidator = new DisableNonceValidatorImpl();
                    return singletonValidator;
                }
                String string2 = string;
                int n = string.indexOf(";");
                if (n != -1) {
                    string2 = string.substring(0, n);
                    string = string.substring(n + 1);
                }
                try {
                    Class<?> clazz = Class.forName(string2.trim());
                    NonceValidator nonceValidator = (NonceValidator)clazz.newInstance();
                    nonceValidator.init(string, timestampHandler);
                    singletonValidator = nonceValidator;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    LogUtils.logWss("Unable to find class name =[" + string2 + "]");
                }
                catch (Exception exception) {
                    LogUtils.logWss("Nonce Validator init error, config String =[" + string + " path name =[" + string2 + "]");
                }
            }
            if (null == singletonValidator) {
                singletonValidator = new NonceValidatorImpl();
                singletonValidator.init(string, timestampHandler);
            }
        } else {
            singletonValidator.setExpirationTime(timestampHandler.getMessageAge());
        }
        return singletonValidator;
    }

    public static NonceValidator getInstance() {
        if (singletonValidator != null) {
            return singletonValidator;
        }
        return NonceValidatorFactory.getInstance(60);
    }

    public static NonceValidator getInstance(int n) {
        if (singletonValidator == null) {
            singletonValidator = new NonceValidatorImpl(n);
        } else {
            singletonValidator.setExpirationTime(n);
        }
        return singletonValidator;
    }
}

