/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.wss.nonce;

import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import javax.xml.rpc.soap.SOAPFaultException;
import weblogic.wsee.util.Verbose;
import weblogic.xml.crypto.utils.LogUtils;
import weblogic.xml.crypto.wss.TimestampHandler;
import weblogic.xml.crypto.wss.api.NonceValidator;
import weblogic.xml.crypto.wss.api.Timestamp;

public class NonceValidatorImpl
implements NonceValidator {
    private static final boolean verbose = Verbose.isVerbose(NonceValidatorImpl.class);
    static final boolean DEBUG = false;
    protected static long expirationTime = 0L;
    protected TimestampHandler timeoutHandler = null;
    protected static Set nonceSet;
    private static NonceEntry head;
    private static NonceEntry tail;

    public NonceValidatorImpl() {
    }

    public NonceValidatorImpl(int n) {
        this.timeoutHandler = new SimpleTimeoutHandler(n);
        this.init(n);
    }

    public void init(String string, TimestampHandler timestampHandler) {
        this.timeoutHandler = null == timestampHandler ? new SimpleTimeoutHandler() : timestampHandler;
        this.init(this.timeoutHandler.getMessageAge());
    }

    private void init(int n) {
        expirationTime = (long)n * 1000L;
        if (nonceSet == null) {
            nonceSet = new HashSet(1000);
            head = null;
            tail = null;
        }
    }

    public void setExpirationTime(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("expirationSeconds must be greater than 0");
        }
        expirationTime = n * 1000;
        this.timeoutHandler.setMessageAge(n);
        LogUtils.logWss("Set expriration value =" + expirationTime);
    }

    public void checkNonceAndTime(String string, Calendar calendar) throws SOAPFaultException {
        this.timeoutHandler.validate(calendar);
        this.checkDuplicate(string, System.currentTimeMillis());
    }

    public void checkDuplicateNonce(String string) throws SOAPFaultException {
        if (null == string) {
            throw new IllegalArgumentException("Null nonce ");
        }
        this.checkDuplicate(string, System.currentTimeMillis());
    }

    protected void checkDuplicate(String string, long l) throws SOAPFaultException {
        NonceValidatorImpl.updateNonceEntry(string, true, l);
    }

    protected static boolean expired(long l, long l2) {
        return l + expirationTime < l2;
    }

    protected static synchronized void updateNonceEntry(String string, boolean bl, long l) throws SOAPFaultException {
        while (head != null && NonceValidatorImpl.head.isExpired(l)) {
            nonceSet.remove(head.nonce);
            head = head.next;
        }
        NonceEntry nonceEntry = new NonceEntry(string, l);
        if (head == null) {
            nonceSet.add(string);
            head = nonceEntry;
            tail = nonceEntry;
            return;
        }
        if (bl && nonceSet.contains(string)) {
            throw new SOAPFaultException(NONCE_FAULTCODE, "A duplicated nonce is found! " + string, null, null);
        }
        tail.next = nonceEntry;
        tail = nonceEntry;
        nonceSet.add(string);
    }

    protected static class SimpleTimeoutHandler
    implements TimestampHandler {
        private int defaultMessageAge = 60;

        private SimpleTimeoutHandler() {
        }

        private SimpleTimeoutHandler(int n) {
            this.defaultMessageAge = n;
        }

        public void validate(Timestamp timestamp, short s) {
            throw new UnsupportedOperationException("Timestamp is not supported");
        }

        public void validate(Calendar calendar) throws SOAPFaultException {
            long l;
            if (null == calendar) {
                throw new IllegalArgumentException("Null created time parameter");
            }
            long l2 = calendar.getTimeInMillis();
            if (l2 > (long)(this.defaultMessageAge * 1000) + (l = System.currentTimeMillis())) {
                throw new SOAPFaultException(EXPIRED_FAULTCODE, "Got wrong created time = " + calendar.toString() + "(" + l2 + ") current time = " + l, null, null);
            }
            if (NonceValidatorImpl.expired(l2, l)) {
                throw new SOAPFaultException(EXPIRED_FAULTCODE, "The transaction has timed-out, created time = " + calendar.toString() + "(" + l2 + ") current time = " + l, null, null);
            }
        }

        public int getMessageAge() {
            return this.defaultMessageAge;
        }

        public void setMessageAge(int n) {
            this.defaultMessageAge = n;
        }
    }

    protected static class NonceEntry {
        private NonceEntry next = null;
        private String nonce;
        private long insertTime;

        NonceEntry(String string, long l) {
            this.nonce = string;
            this.insertTime = l;
        }

        private boolean isExpired(long l) {
            return NonceValidatorImpl.expired(this.insertTime, l);
        }
    }
}

