/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.wss11.internal;

import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import weblogic.security.service.ContextHandler;
import weblogic.xml.crypto.api.KeySelector;
import weblogic.xml.crypto.api.MarshalException;
import weblogic.xml.crypto.api.XMLStructure;
import weblogic.xml.crypto.common.keyinfo.EncryptedKeyProvider;
import weblogic.xml.crypto.common.keyinfo.KeyProvider;
import weblogic.xml.crypto.dsig.ReferenceImpl;
import weblogic.xml.crypto.dsig.api.CanonicalizationMethod;
import weblogic.xml.crypto.dsig.api.DigestMethod;
import weblogic.xml.crypto.dsig.api.Reference;
import weblogic.xml.crypto.dsig.api.SignedInfo;
import weblogic.xml.crypto.dsig.api.keyinfo.KeyInfo;
import weblogic.xml.crypto.encrypt.api.EncryptionMethod;
import weblogic.xml.crypto.encrypt.api.TBEKey;
import weblogic.xml.crypto.encrypt.api.XMLEncryptionException;
import weblogic.xml.crypto.encrypt.api.dom.DOMEncryptContext;
import weblogic.xml.crypto.encrypt.api.dom.DOMTBEXML;
import weblogic.xml.crypto.encrypt.api.keyinfo.EncryptedKey;
import weblogic.xml.crypto.utils.DOMUtils;
import weblogic.xml.crypto.utils.LogUtils;
import weblogic.xml.crypto.wss.SecurityTokenContextHandler;
import weblogic.xml.crypto.wss.WSSConstants;
import weblogic.xml.crypto.wss.WSSecurityContext;
import weblogic.xml.crypto.wss.WSSecurityException;
import weblogic.xml.crypto.wss.provider.CredentialProvider;
import weblogic.xml.crypto.wss.provider.SecurityToken;
import weblogic.xml.crypto.wss.provider.SecurityTokenHandler;
import weblogic.xml.crypto.wss.provider.SecurityTokenReference;
import weblogic.xml.crypto.wss11.internal.STRType;
import weblogic.xml.crypto.wss11.internal.SecurityBuilder;
import weblogic.xml.crypto.wss11.internal.SecurityImpl;
import weblogic.xml.crypto.wss11.internal.SignatureConfirmation;
import weblogic.xml.crypto.wss11.internal.WSS11Constants;
import weblogic.xml.crypto.wss11.internal.WSS11Factory;
import weblogic.xml.crypto.wss11.internal.enckey.EncryptedKeySTR;
import weblogic.xml.crypto.wss11.internal.enckey.EncryptedKeyToken;
import weblogic.xml.saaj.SOAPConstants;

public class SecurityBuilderImpl
extends weblogic.xml.crypto.wss.SecurityBuilderImpl
implements SecurityBuilder {
    private final boolean DEBUG = false;
    private String layout = "Strict";
    private String version = "http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd";
    private boolean processingStarted = false;
    private static final List EMPTY_LIST = new ArrayList();
    private static final List supportedLayouts = new ArrayList();

    public SecurityBuilderImpl(WSSecurityContext wSSecurityContext, Element element) {
        super(wSSecurityContext, element);
    }

    public SecurityBuilderImpl(WSSecurityContext wSSecurityContext) {
        super(wSSecurityContext);
    }

    public void setLayout(String string) {
        if (this.processingStarted && !this.layout.equals(string)) {
            throw new IllegalStateException("Layout can not be changed after SecurityBuilder processing started.");
        }
        this.checkLayout(string);
        this.layout = string;
    }

    public static void setEncryptBeforeSign(ContextHandler contextHandler, boolean bl) {
        ((SecurityTokenContextHandler)contextHandler).addContextElement("weblogic.wsee.security.encrypt_sign", new Boolean(bl));
    }

    public void setWSSVersion(String string) {
        if (this.processingStarted && !this.version.equals(string)) {
            throw new IllegalStateException("WSS version can not be changed after SecurityBuilder processing started.");
        }
        if (!"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd".equals(string) && !"http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd".equals(string)) {
            throw new IllegalArgumentException("Unsupported WSS version: " + string);
        }
        this.version = string;
    }

    public SignatureConfirmation[] addSignatureConfirmation(String[] stringArray, ContextHandler contextHandler) throws MarshalException, WSSecurityException {
        SignatureConfirmation[] signatureConfirmationArray;
        this.ensureWSS11();
        this.setLayout(contextHandler);
        this.start();
        if (stringArray.length == 0) {
            signatureConfirmationArray = new SignatureConfirmation[]{this.addSigConf(null, contextHandler)};
        } else {
            signatureConfirmationArray = new SignatureConfirmation[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                if (string == null) {
                    throw new NullPointerException();
                }
                signatureConfirmationArray[i] = this.addSigConf(string, contextHandler);
            }
        }
        return signatureConfirmationArray;
    }

    public void addSignatureAndEncryption(SignedInfo signedInfo, List list, EncryptionMethod encryptionMethod, EncryptionMethod encryptionMethod2, String string, String string2, boolean bl, ContextHandler contextHandler) throws WSSecurityException, MarshalException, XMLEncryptionException {
        this.addSignAndEncInternal(signedInfo, list, encryptionMethod, encryptionMethod2, string, null, string2, bl, contextHandler);
    }

    protected EncryptedKeyToken addEncryptedKeyToken(Key key, String string) {
        EncryptedKeyToken encryptedKeyToken = new EncryptedKeyToken(key, string);
        this.securityCtx.addSecurityToken(encryptedKeyToken);
        return encryptedKeyToken;
    }

    public void addSignatureAndEncryption(SignedInfo signedInfo, List list, EncryptionMethod encryptionMethod, ContextHandler contextHandler) throws WSSecurityException, MarshalException, XMLEncryptionException {
        this.ensureWSS11();
        this.setLayout(contextHandler);
        this.start();
        boolean bl = SecurityImpl.isEncryptBeforeSign(contextHandler);
        EncryptedKeyToken encryptedKeyToken = (EncryptedKeyToken)this.getToken("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey", null, contextHandler);
        if (bl) {
            EncryptedKeySTR encryptedKeySTR = new EncryptedKeySTR(WSSConstants.KEY_IDENTIFIER_QNAME, encryptedKeyToken);
            KeyInfo keyInfo = this.getKeyInfo(encryptedKeySTR);
            DOMEncryptContext dOMEncryptContext = new DOMEncryptContext(null);
            dOMEncryptContext.setKeySelector(this.securityCtx.getKeySelector());
            List list2 = this.encryptData(list, dOMEncryptContext, encryptionMethod, keyInfo, true, contextHandler);
            this.addReferenceList(list2, encryptedKeyToken, contextHandler);
            this.addSignatureWithToken(signedInfo, encryptedKeySTR, null, contextHandler);
            this.moveTimestampToTop();
        } else {
            EncryptedKeySTR encryptedKeySTR = new EncryptedKeySTR(WSSConstants.KEY_IDENTIFIER_QNAME, encryptedKeyToken);
            this.addSignatureWithToken(signedInfo, encryptedKeySTR, null, contextHandler);
            KeyInfo keyInfo = this.getKeyInfo(encryptedKeySTR);
            DOMEncryptContext dOMEncryptContext = new DOMEncryptContext(null);
            dOMEncryptContext.setKeySelector(this.securityCtx.getKeySelector());
            List list3 = this.encryptData(list, dOMEncryptContext, encryptionMethod, keyInfo, true, contextHandler);
            if (!"LaxTimestampFirst".equals(this.layout)) {
                ((SecurityTokenContextHandler)contextHandler).addContextElement("weblogic.wsee.security.move_node_to_top", "true");
            }
            this.addReferenceList(list3, encryptedKeyToken, contextHandler);
        }
    }

    public void addSignatureAndEncryptionAndEndorsing(SignedInfo signedInfo, List list, EncryptionMethod encryptionMethod, int n, SignedInfo signedInfo2, String string, List list2, String string2, boolean bl, ContextHandler contextHandler) throws WSSecurityException, MarshalException, XMLEncryptionException {
        Object object;
        Object object2;
        XMLStructure xMLStructure;
        this.ensureWSS11();
        this.setLayout(contextHandler);
        this.start();
        if ((n & 0x1000) == 4096) {
            throw new WSSecurityException("Wrong Policy on Encrypt before Sign and Encrypt Signature");
        }
        boolean bl2 = (n & 0x2000) == 8192;
        EncryptedKeyToken encryptedKeyToken = (EncryptedKeyToken)this.getToken("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey", null, contextHandler);
        EncryptedKeySTR encryptedKeySTR = new EncryptedKeySTR(WSSConstants.KEY_IDENTIFIER_QNAME, encryptedKeyToken);
        Node node = this.addSignatureWithToken(signedInfo, encryptedKeySTR, null, contextHandler);
        Node node2 = null;
        if (signedInfo2 != null) {
            this.setSignatureReference(signedInfo2, (Element)node);
            node2 = this.addSignatureInternal(signedInfo2, string, list2, string2, bl, contextHandler);
        }
        if (bl2) {
            xMLStructure = signedInfo.getCanonicalizationMethod();
            object2 = new DOMTBEXML((Element)node, (CanonicalizationMethod)xMLStructure);
            list.add(object2);
            if (node2 != null) {
                xMLStructure = signedInfo2.getCanonicalizationMethod();
                object = new DOMTBEXML((Element)node2, (CanonicalizationMethod)xMLStructure);
                list.add(object);
            }
        }
        xMLStructure = this.getKeyInfo(encryptedKeySTR);
        object2 = new DOMEncryptContext(null);
        ((DOMEncryptContext)object2).setKeySelector(this.securityCtx.getKeySelector());
        object = this.encryptData(list, (DOMEncryptContext)object2, encryptionMethod, (KeyInfo)xMLStructure, true, contextHandler);
        if (!"LaxTimestampFirst".equals(this.layout)) {
            ((SecurityTokenContextHandler)contextHandler).addContextElement("weblogic.wsee.security.move_node_to_top", "true");
        }
        this.addReferenceList((List)object, encryptedKeyToken, contextHandler);
        if (bl2) {
            this.moveTimestampToTop();
        }
    }

    public void addSignature(SignedInfo signedInfo, EncryptionMethod encryptionMethod, String string, String string2, boolean bl, ContextHandler contextHandler) throws WSSecurityException, MarshalException, XMLEncryptionException {
        this.addSignatureInternal(signedInfo, encryptionMethod, string, null, string2, bl, contextHandler);
    }

    public void addSignature(SignedInfo signedInfo, ContextHandler contextHandler) throws MarshalException, WSSecurityException {
        this.ensureWSS11();
        this.start();
        this.setLayout(contextHandler);
        EncryptedKeyToken encryptedKeyToken = (EncryptedKeyToken)this.getToken("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey", null, contextHandler);
        EncryptedKeySTR encryptedKeySTR = new EncryptedKeySTR(WSSConstants.KEY_IDENTIFIER_QNAME, encryptedKeyToken);
        this.addSignatureWithToken(signedInfo, encryptedKeySTR, null, contextHandler);
    }

    private void setLayout(ContextHandler contextHandler) {
        if (this.layout.equals("Strict")) {
            ((SecurityTokenContextHandler)contextHandler).addContextElement("weblogic.wsee.security.strict_layout", Boolean.TRUE);
        }
    }

    public void addEncryption(List list, EncryptionMethod encryptionMethod, ContextHandler contextHandler) throws MarshalException, WSSecurityException {
        this.ensureWSS11();
        this.start();
        EncryptedKeyToken encryptedKeyToken = (EncryptedKeyToken)this.getToken("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey", null, contextHandler);
        EncryptedKeySTR encryptedKeySTR = new EncryptedKeySTR(WSSConstants.KEY_IDENTIFIER_QNAME, encryptedKeyToken);
        KeyInfo keyInfo = this.getKeyInfo(encryptedKeySTR);
        DOMEncryptContext dOMEncryptContext = new DOMEncryptContext(null);
        dOMEncryptContext.setKeySelector(this.securityCtx.getKeySelector());
        List list2 = this.encryptData(list, dOMEncryptContext, encryptionMethod, keyInfo, true, contextHandler);
        this.addReferenceList(list2, encryptedKeyToken, contextHandler);
    }

    public Reference createReference(String string, List list, String string2, DigestMethod digestMethod, List list2, boolean bl, ContextHandler contextHandler) throws WSSecurityException {
        this.setLayout(contextHandler);
        this.start();
        return this.createReferenceInternal(string, list, string2, digestMethod, list2, bl, contextHandler);
    }

    public Node addSignature(SignedInfo signedInfo, Reference reference, List list, ContextHandler contextHandler) throws WSSecurityException, MarshalException {
        this.start();
        this.setLayout(contextHandler);
        return this.addSignatureInternal(signedInfo, reference, list, contextHandler);
    }

    public Node addSignature(SignedInfo signedInfo, String string, List list, String string2, boolean bl, ContextHandler contextHandler) throws WSSecurityException, MarshalException {
        this.start();
        this.setLayout(contextHandler);
        boolean bl2 = SecurityBuilderImpl.isMoveTimestampNeeded(contextHandler);
        Node node = this.addSignatureInternal(signedInfo, string, list, string2, bl, contextHandler);
        if (null != node && bl2) {
            this.moveTimestampToTop();
        }
        return node;
    }

    public boolean addEncryption(List list, EncryptionMethod encryptionMethod, EncryptionMethod encryptionMethod2, String string, List list2, String string2, boolean bl, ContextHandler contextHandler) throws WSSecurityException, MarshalException, XMLEncryptionException {
        this.start();
        return this.addEncryptionInternal(list, encryptionMethod, encryptionMethod2, string, list2, string2, bl, contextHandler);
    }

    public void addSignatureAndEncryption(SignedInfo signedInfo, List list, EncryptionMethod encryptionMethod, EncryptionMethod encryptionMethod2, String string, List list2, String string2, boolean bl, ContextHandler contextHandler) throws WSSecurityException, MarshalException, XMLEncryptionException {
        this.addSignAndEncInternal(signedInfo, list, encryptionMethod, encryptionMethod2, string, list2, string2, bl, contextHandler);
    }

    private void setSignatureReference(SignedInfo signedInfo, Element element) throws WSSecurityException {
        for (ReferenceImpl referenceImpl : signedInfo.getReferences()) {
            if (!"#weblogic.wsee.security.signature_node".equals(referenceImpl.getURI())) continue;
            String string = DOMUtils.getExistingId(element, this.idQNames);
            if (null == string) {
                throw new WSSecurityException("Missing Signature Id");
            }
            referenceImpl.setUri("#" + string);
            break;
        }
    }

    public void addSignatureAndEncryptionAndEndorsing(SignedInfo signedInfo, List list, EncryptionMethod encryptionMethod, EncryptionMethod encryptionMethod2, String string, List list2, String string2, boolean bl, int n, SignedInfo signedInfo2, String string3, List list3, String string4, boolean bl2, ContextHandler contextHandler) throws WSSecurityException, MarshalException, XMLEncryptionException {
        Object object;
        Object object2;
        XMLStructure xMLStructure;
        boolean bl3 = false;
        this.ensureWSS11();
        this.start();
        this.setLayout(contextHandler);
        if ((n & 0x1000) == 4096) {
            throw new WSSecurityException("Wrong Policy on Encrypt before Sign and Encrypt Signature");
        }
        if (null == encryptionMethod) {
            throw new WSSecurityException("Wrong state on Encrypted Key and DK");
        }
        boolean bl4 = (n & 0x400) == 1024;
        boolean bl5 = (n & 0x2000) == 8192;
        SecurityToken securityToken = this.getToken(string, string2, contextHandler);
        this.addToken(bl, securityToken, contextHandler);
        SecurityTokenReference securityTokenReference = this.getSTR(string, list2, securityToken, bl);
        Key key = this.generateKey(encryptionMethod2);
        String string5 = DOMUtils.generateId("encKey");
        EncryptedKeyToken encryptedKeyToken = this.addEncryptedKeyToken(key, string5);
        EncryptedKeySTR encryptedKeySTR = new EncryptedKeySTR(WSSConstants.REFERENCE_QNAME, encryptedKeyToken);
        Node node = this.addSignatureWithToken(signedInfo, encryptedKeySTR, null, contextHandler);
        Node node2 = null;
        if (bl4) {
            this.setSignatureReference(signedInfo2, (Element)node);
            node2 = this.addSignatureInternal(signedInfo2, string3, list3, string4, bl2, contextHandler);
        }
        if (bl5) {
            xMLStructure = signedInfo.getCanonicalizationMethod();
            object2 = new DOMTBEXML((Element)node, (CanonicalizationMethod)xMLStructure);
            list.add(object2);
            if (node2 != null) {
                xMLStructure = signedInfo2.getCanonicalizationMethod();
                object = new DOMTBEXML((Element)node2, (CanonicalizationMethod)xMLStructure);
                list.add(object);
            }
            bl3 = true;
        }
        xMLStructure = this.getKeyInfo(securityTokenReference);
        object2 = new DOMEncryptContext(key);
        object = this.encryptData(list, (DOMEncryptContext)object2, encryptionMethod2, (KeyInfo)xMLStructure, false, contextHandler);
        KeyProvider keyProvider = this.getKeyProvider(string, securityToken);
        KeySelector keySelector = this.securityCtx.getKeySelector();
        if (null != encryptionMethod) {
            Key key2 = this.getKey(keySelector, keyProvider, encryptionMethod);
            EncryptedKey encryptedKey = this.addEncryptedKey(key, key2, encryptionMethod, (KeyInfo)xMLStructure, (List)object, string5, bl, securityToken, contextHandler);
            encryptedKeyToken.setEncryptedKey(encryptedKey);
        } else {
            this.addReferenceList((List)object, securityToken, contextHandler);
        }
        if (bl3) {
            this.moveTimestampToTop();
        }
    }

    public void addSignature(SignedInfo signedInfo, EncryptionMethod encryptionMethod, String string, List list, String string2, boolean bl, ContextHandler contextHandler) throws WSSecurityException, MarshalException, XMLEncryptionException {
        this.addSignatureInternal(signedInfo, encryptionMethod, string, list, string2, bl, contextHandler);
    }

    private void addSignAndEncInternal(SignedInfo signedInfo, List list, EncryptionMethod encryptionMethod, EncryptionMethod encryptionMethod2, String string, List list2, String string2, boolean bl, ContextHandler contextHandler) throws WSSecurityException, MarshalException, XMLEncryptionException {
        this.ensureWSS11();
        this.start();
        this.setLayout(contextHandler);
        boolean bl2 = SecurityImpl.isEncryptBeforeSign(contextHandler);
        SecurityToken securityToken = this.getToken(string, string2, contextHandler);
        this.addToken(bl, securityToken, contextHandler);
        SecurityTokenReference securityTokenReference = this.getSTR(string, list2, securityToken, bl);
        Key key = this.generateKey(encryptionMethod2);
        String string3 = DOMUtils.generateId("encKey");
        EncryptedKeyToken encryptedKeyToken = this.addEncryptedKeyToken(key, string3);
        if (bl2) {
            KeyInfo keyInfo = this.getKeyInfo(securityTokenReference);
            DOMEncryptContext dOMEncryptContext = new DOMEncryptContext(key);
            STRType sTRType = new STRType(WSSConstants.REFERENCE_QNAME, "http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKeySHA1", "http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
            ArrayList<STRType> arrayList = new ArrayList<STRType>();
            arrayList.add(sTRType);
            SecurityTokenReference securityTokenReference2 = this.getSTR("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey", arrayList, encryptedKeyToken, false);
            KeyInfo keyInfo2 = this.getKeyInfo(securityTokenReference2);
            List list3 = this.encryptData(list, dOMEncryptContext, encryptionMethod2, keyInfo2, true, contextHandler);
            KeyProvider keyProvider = this.getKeyProvider(string, securityToken);
            KeySelector keySelector = this.securityCtx.getKeySelector();
            Key key2 = this.getKey(keySelector, keyProvider, encryptionMethod);
            EncryptedKey encryptedKey = this.addEncryptedKey(key, key2, encryptionMethod, keyInfo, new ArrayList(), string3, bl, securityToken, contextHandler);
            this.addReferenceList(list3, encryptedKeyToken, contextHandler);
            encryptedKeyToken.setEncryptedKey(encryptedKey);
            Map map = (Map)contextHandler.getValue("weblogic.wsee.security.encrypted_element.map");
            if (null != map) {
                for (ReferenceImpl referenceImpl : signedInfo.getReferences()) {
                    if (!map.containsKey(referenceImpl.getURI())) continue;
                    referenceImpl.setUri("#" + (String)map.get(referenceImpl.getURI()));
                }
            }
            EncryptedKeySTR encryptedKeySTR = new EncryptedKeySTR(WSSConstants.REFERENCE_QNAME, encryptedKeyToken);
            this.addSignatureWithToken(signedInfo, encryptedKeySTR, null, contextHandler);
            this.moveTimestampToTop();
        } else {
            EncryptedKeySTR encryptedKeySTR = new EncryptedKeySTR(WSSConstants.REFERENCE_QNAME, encryptedKeyToken);
            this.addSignatureWithToken(signedInfo, encryptedKeySTR, null, contextHandler);
            KeyInfo keyInfo = this.getKeyInfo(securityTokenReference);
            DOMEncryptContext dOMEncryptContext = new DOMEncryptContext(key);
            List list4 = this.encryptData(list, dOMEncryptContext, encryptionMethod2, keyInfo, false, contextHandler);
            KeyProvider keyProvider = this.getKeyProvider(string, securityToken);
            KeySelector keySelector = this.securityCtx.getKeySelector();
            Key key3 = this.getKey(keySelector, keyProvider, encryptionMethod);
            EncryptedKey encryptedKey = this.addEncryptedKey(key, key3, encryptionMethod, keyInfo, list4, string3, bl, securityToken, contextHandler);
            encryptedKeyToken.setEncryptedKey(encryptedKey);
        }
    }

    private void moveTimestampToTop() {
        Element element;
        Element element2;
        if (!"LaxTimestampLast".equals(this.layout) && "Timestamp".equals((element2 = DOMUtils.getLastElement(element = this.securityCtx.getSecurityElement())).getLocalName())) {
            this.moveToTop(element2);
        }
    }

    private void addSignatureInternal(SignedInfo signedInfo, EncryptionMethod encryptionMethod, String string, List list, String string2, boolean bl, ContextHandler contextHandler) throws WSSecurityException, MarshalException, XMLEncryptionException {
        this.ensureWSS11();
        this.setLayout(contextHandler);
        this.start();
        SecurityToken securityToken = this.getToken(string, string2, contextHandler);
        this.addToken(bl, securityToken, contextHandler);
        SecurityTokenReference securityTokenReference = this.getSTR(string, list, securityToken, bl);
        EncryptionMethod encryptionMethod2 = null;
        try {
            encryptionMethod2 = this.securityCtx.getEncryptionFactory().newEncryptionMethod("http://www.w3.org/2001/04/xmlenc#aes256-cbc", null, null);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new WSSecurityException(invalidAlgorithmParameterException);
        }
        Key key = this.generateKey(encryptionMethod2);
        String string3 = DOMUtils.generateId("encKey");
        EncryptedKeyToken encryptedKeyToken = this.addEncryptedKeyToken(key, string3);
        EncryptedKeySTR encryptedKeySTR = new EncryptedKeySTR(WSSConstants.REFERENCE_QNAME, encryptedKeyToken);
        this.addSignatureWithToken(signedInfo, encryptedKeySTR, null, contextHandler);
        KeyInfo keyInfo = this.getKeyInfo(securityTokenReference);
        KeyProvider keyProvider = this.getKeyProvider(string, securityToken);
        KeySelector keySelector = this.securityCtx.getKeySelector();
        Key key2 = this.getKey(keySelector, keyProvider, encryptionMethod);
        EncryptedKey encryptedKey = this.addEncryptedKey(key, key2, encryptionMethod, keyInfo, EMPTY_LIST, string3, bl, securityToken, contextHandler);
        encryptedKeyToken.setEncryptedKey(encryptedKey);
    }

    private SignatureConfirmation addSigConf(String string, ContextHandler contextHandler) throws WSSecurityException, MarshalException {
        if (this.security == null) {
            this.createSecurity(this.securityCtx);
        }
        SignatureConfirmation signatureConfirmation = WSS11Factory.newSignatureConfirmation(string);
        this.security.add(signatureConfirmation, null, contextHandler);
        return signatureConfirmation;
    }

    private void start() {
        this.processingStarted = true;
    }

    private boolean isWSS10() {
        return this.version.equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
    }

    private void checkLayout(String string) {
        if (!supportedLayouts.contains(string)) {
            throw new IllegalArgumentException("Unsupported layout: " + string);
        }
    }

    private void ensureWSS11() {
        if (this.isWSS10()) {
            throw new UnsupportedOperationException("Operation not supported with WSS version " + this.version);
        }
    }

    public Node addSignature(SignedInfo signedInfo, String string, String string2, boolean bl, ContextHandler contextHandler) throws WSSecurityException, MarshalException {
        this.setLayout(contextHandler);
        return super.addSignature(signedInfo, string, string2, bl, contextHandler);
    }

    public Node addSignature(SignedInfo signedInfo, Reference reference, ContextHandler contextHandler) throws WSSecurityException, MarshalException {
        this.setLayout(contextHandler);
        return super.addSignature(signedInfo, reference, contextHandler);
    }

    protected SecurityTokenReference getSTR(String string, List list, SecurityToken securityToken, boolean bl) throws WSSecurityException {
        Object object;
        if (list == null || list.size() == 0) {
            return super.getSTR(string, list, securityToken, bl);
        }
        SecurityTokenHandler securityTokenHandler = null;
        for (int i = 0; i < list.size(); ++i) {
            object = ((STRType)list.get(i)).getValueType();
            if (object == null) continue;
            securityTokenHandler = this.securityCtx.getTokenHandler(object);
            if (null != securityTokenHandler || list.size() != 1) break;
            throw new WSSecurityException("Unable to get handler for str value type =" + (String)object);
        }
        if (securityTokenHandler == null) {
            securityTokenHandler = this.securityCtx.getRequiredTokenHandler(string);
        }
        SecurityTokenReference securityTokenReference = null;
        object = null;
        QName qName = null;
        for (int i = 0; securityTokenReference == null && list.size() > i; ++i) {
            STRType sTRType = (STRType)list.get(i);
            qName = sTRType.getTopLevelElement();
            if (qName.equals(WSSConstants.REFERENCE_QNAME)) {
                return this.createDirectSTR(string, securityToken);
            }
            String string2 = sTRType.getValueType();
            if ("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#ThumbprintSHA1".equals(string2)) {
                this.ensureWSS11();
                securityTokenReference = securityTokenHandler.getSTR(qName, sTRType.getValueType(), securityToken);
                continue;
            }
            securityTokenReference = securityTokenHandler.getSTR(qName, string2 != null ? sTRType.getTokenType() : string, securityToken);
            if (!WSSConstants.KEY_IDENTIFIER_QNAME.equals(qName) || WSSConstants.KEY_IDENTIFIER_QNAME.equals(securityTokenReference.getSTRType())) continue;
            if (list.size() > i) {
                object = securityTokenReference.getSTRType();
                securityTokenReference = null;
                continue;
            }
            throw new WSSecurityException("Failed to create KeyIdentifier STR");
        }
        if (securityTokenReference == null) {
            throw new WSSecurityException("Failed to create STR for QName =" + qName + " error STR QName =" + object);
        }
        if (securityTokenReference.getId() == null) {
            securityTokenReference.setId(SecurityBuilderImpl.getId("str"));
        }
        return securityTokenReference;
    }

    protected SecurityTokenReference createKeyIdSTRInternal(String string, List list, SecurityToken securityToken, boolean bl) throws WSSecurityException {
        return this.getSTR(string, list, securityToken, bl);
    }

    protected void createSecurity(WSSecurityContext wSSecurityContext) throws MarshalException {
        WSS11Factory.getInstance();
        this.security = WSS11Factory.newSecurity(wSSecurityContext);
    }

    protected void processEncryptedHeader(Node node, Node node2) {
        Node node3;
        Node node4;
        if (this.isWSS10()) {
            super.processEncryptedHeader(node, node2);
            return;
        }
        boolean bl = this.namespaces.get("http://schemas.xmlsoap.org/soap/envelope/") == null;
        String string = (String)this.namespaces.get("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd");
        if (string == null) {
            string = "wsse11";
        }
        Element element = DOMUtils.createAndAddElement((Element)node2.getParentNode(), WSS11Constants.ENC_HEADER_QNAME, string);
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (null != this.securityCtx.getSecurityElement()) {
            namedNodeMap = this.securityCtx.getSecurityElement().getAttributes();
        }
        if ((node4 = namedNodeMap.getNamedItemNS("http://schemas.xmlsoap.org/soap/envelope/", "actor")) == null) {
            node4 = namedNodeMap.getNamedItemNS("http://www.w3.org/2003/05/soap-envelope", SOAPConstants.HEADER12_ROLE.getLocalPart());
        }
        if (node4 != null) {
            element.setAttributeNodeNS((Attr)node4.cloneNode(true));
        }
        if ((node3 = namedNodeMap.getNamedItemNS("http://www.w3.org/2003/05/soap-envelope", SOAPConstants.HEADER12_RELAY.getLocalPart())) != null) {
            element.setAttributeNodeNS((Attr)node3.cloneNode(true));
        }
        SecurityImpl.setMustUnderstand(element, this.namespaces, bl);
        Node node5 = node2.getParentNode();
        node5.removeChild(node2);
        element.appendChild(node2);
    }

    protected EncryptedKey addEncryptedKey(Key key, Key key2, EncryptionMethod encryptionMethod, KeyInfo keyInfo, List list, String string, boolean bl, SecurityToken securityToken, ContextHandler contextHandler) throws WSSecurityException, MarshalException {
        TBEKey tBEKey = new TBEKey(key);
        boolean bl2 = false;
        EncryptedKey encryptedKey = bl2 ? this.getEncryptionFactory().newEncryptedKey(tBEKey, encryptionMethod, keyInfo, null, null, string, null, null, null) : this.getEncryptionFactory().newEncryptedKey(tBEKey, encryptionMethod, keyInfo, null, list, string, null, null, null);
        DOMEncryptContext dOMEncryptContext = new DOMEncryptContext(key2);
        this.addEncryptedKey(encryptedKey, dOMEncryptContext, contextHandler);
        EncryptedKeyToken encryptedKeyToken = this.addEncryptedKeyToken(key, string);
        try {
            encryptedKeyToken.setEncryptedKey(encryptedKey);
        }
        catch (XMLEncryptionException xMLEncryptionException) {
            throw new WSSecurityException(xMLEncryptionException);
        }
        this.addToken(bl, securityToken, contextHandler);
        return encryptedKey;
    }

    protected void updateContext(Node node, Node node2, ContextHandler contextHandler) {
        super.updateContext(node, node2, contextHandler);
        if (SecurityImpl.isEncryptBeforeSign(contextHandler)) {
            SecurityTokenContextHandler securityTokenContextHandler = (SecurityTokenContextHandler)contextHandler;
            HashMap<QName, Node> hashMap = (HashMap<QName, Node>)securityTokenContextHandler.getValue("weblogic.wsee.security.encrypted_element.map");
            if (null == hashMap) {
                hashMap = new HashMap<QName, Node>();
                securityTokenContextHandler.addContextElement("weblogic.wsee.security.encrypted_element.map", hashMap);
            }
            hashMap.put(new QName(node.getNamespaceURI(), node.getLocalName()), node2);
            String string = this.getExisitingUri((Element)node);
            String string2 = this.getExisitingUri((Element)node2);
            if (null != string && null != string2) {
                hashMap.put((QName)((Object)this.getUri(string)), (Node)((Object)string2));
            }
        }
    }

    protected void moveToTop(SecurityToken securityToken) {
        Node node = this.securityCtx.getNode(securityToken);
        this.moveToTop(node);
    }

    protected void moveToTop(Node node) {
        Element element = this.securityCtx.getSecurityElement();
        element.removeChild(node);
        Node node2 = element.getFirstChild();
        if ("LaxTimestampFirst".equals(this.layout) && null != node2 && WSSConstants.TIMESTAMP_QNAME.getLocalPart().equals(node2.getLocalName())) {
            node2 = node2.getNextSibling();
        }
        element.insertBefore(node, node2);
    }

    public boolean isCredentialAvailable(String string) {
        CredentialProvider credentialProvider = this.getCredentialProvider(string);
        return null != credentialProvider;
    }

    public static boolean isMoveTimestampNeeded(ContextHandler contextHandler) {
        Boolean bl = (Boolean)contextHandler.getValue("weblogic.wsee.security.need_to_move_timestamp");
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public Key getEncryptedKeyToken(EncryptionMethod encryptionMethod, EncryptionMethod encryptionMethod2, String string, List list, String string2, boolean bl, ContextHandler contextHandler) throws WSSecurityException, MarshalException, XMLEncryptionException {
        this.start();
        return this.getEncryptedKeyTokenInternal(encryptionMethod, encryptionMethod2, string, list, string2, bl, contextHandler);
    }

    protected Key getEncryptedKeyTokenInternal(EncryptionMethod encryptionMethod, EncryptionMethod encryptionMethod2, String string, List list, String string2, boolean bl, ContextHandler contextHandler) throws WSSecurityException, MarshalException {
        SecurityToken securityToken = this.getToken(string, string2, contextHandler);
        SecurityTokenReference securityTokenReference = this.createKeyIdSTRInternal(string, list, securityToken, bl);
        if (securityTokenReference == null) {
            throw new WSSecurityException("Failed to create reference for token: " + securityToken);
        }
        KeyInfo keyInfo = this.getKeyInfo(securityTokenReference);
        KeyProvider keyProvider = this.getKeyProvider(string, securityToken);
        KeySelector keySelector = this.securityCtx.getKeySelector();
        Key key = this.generateKey(encryptionMethod2);
        String string3 = DOMUtils.generateId("encKey");
        Key key2 = this.getKey(keySelector, keyProvider, encryptionMethod);
        EncryptedKey encryptedKey = this.addEncryptedKey(key, key2, encryptionMethod, keyInfo, EMPTY_LIST, string3, bl, securityToken, contextHandler);
        if (null == encryptedKey) {
            LogUtils.logWss("Unable to add Encrypted Key");
            return null;
        }
        EncryptedKeyToken encryptedKeyToken = new EncryptedKeyToken(key, string3);
        EncryptedKeyProvider encryptedKeyProvider = null;
        try {
            encryptedKeyProvider = new EncryptedKeyProvider(encryptedKey, key, encryptedKeyToken);
            encryptedKeyToken.setKeyProvider(encryptedKeyProvider);
        }
        catch (XMLEncryptionException xMLEncryptionException) {
            throw new WSSecurityException(xMLEncryptionException, WSSConstants.FAILURE_INVALID);
        }
        this.securityCtx.addKeyProvider(encryptedKeyProvider);
        this.securityCtx.addSecurityToken(encryptedKeyToken);
        this.securityCtx.addToken(encryptedKeyToken, this.securityCtx.getElementById(encryptedKey.getId()));
        return key;
    }

    static {
        supportedLayouts.add("Strict");
        supportedLayouts.add("Lax");
        supportedLayouts.add("LaxTimestampFirst");
        supportedLayouts.add("LaxTimestampLast");
    }
}

