/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.wss11.internal;

import java.util.List;
import javax.xml.namespace.QName;
import org.w3c.dom.Node;
import weblogic.security.service.ContextHandler;
import weblogic.xml.crypto.api.KeySelector;
import weblogic.xml.crypto.api.KeySelectorResult;
import weblogic.xml.crypto.api.XMLCryptoContext;
import weblogic.xml.crypto.api.XMLStructure;
import weblogic.xml.crypto.common.keyinfo.EncryptedKeyProvider;
import weblogic.xml.crypto.encrypt.api.XMLEncryptionException;
import weblogic.xml.crypto.encrypt.api.dom.DOMDecryptContext;
import weblogic.xml.crypto.encrypt.api.keyinfo.EncryptedKey;
import weblogic.xml.crypto.utils.DOMUtils;
import weblogic.xml.crypto.utils.LogUtils;
import weblogic.xml.crypto.wss.SecurityImpl;
import weblogic.xml.crypto.wss.WSSConstants;
import weblogic.xml.crypto.wss.WSSecurityContext;
import weblogic.xml.crypto.wss.WSSecurityException;
import weblogic.xml.crypto.wss11.internal.Security;
import weblogic.xml.crypto.wss11.internal.SignatureConfirmation;
import weblogic.xml.crypto.wss11.internal.WSS11Constants;
import weblogic.xml.crypto.wss11.internal.WSS11Context;
import weblogic.xml.crypto.wss11.internal.WSS11Factory;
import weblogic.xml.crypto.wss11.internal.enckey.EncryptedKeyToken;
import weblogic.xml.dom.marshal.MarshalException;

public class SecurityImpl
extends weblogic.xml.crypto.wss.SecurityImpl
implements Security {
    private static SignatureConfirmationHandler sch = new SignatureConfirmationHandler();

    public SecurityImpl() {
        this.init();
    }

    public SecurityImpl(WSSecurityContext wSSecurityContext) {
        super(wSSecurityContext);
        this.init();
    }

    protected void processAndMarshal(XMLStructure xMLStructure, XMLCryptoContext xMLCryptoContext, ContextHandler contextHandler) throws WSSecurityException, weblogic.xml.crypto.api.MarshalException {
        if (xMLStructure instanceof SignatureConfirmation) {
            this.marshalSigConf((SignatureConfirmation)xMLStructure, contextHandler);
        } else {
            super.processAndMarshal(xMLStructure, xMLCryptoContext, contextHandler);
        }
    }

    private void marshalSigConf(SignatureConfirmation signatureConfirmation, ContextHandler contextHandler) throws weblogic.xml.crypto.api.MarshalException {
        Node node = this.findInsertBeforeNode(this.security, contextHandler, false);
        try {
            signatureConfirmation.marshal(this.security, node, this.namespaces);
        }
        catch (MarshalException marshalException) {
            throw new weblogic.xml.crypto.api.MarshalException(marshalException);
        }
    }

    protected EncryptedKeyProvider handleEncryptedKey(EncryptedKey encryptedKey, DOMDecryptContext dOMDecryptContext, WSSecurityContext wSSecurityContext) throws WSSecurityException {
        EncryptedKeyToken encryptedKeyToken = new EncryptedKeyToken((EncryptedKeyProvider)null, encryptedKey.getId());
        EncryptedKeyProvider encryptedKeyProvider = null;
        try {
            encryptedKeyProvider = new EncryptedKeyProvider(encryptedKey, encryptedKeyToken, dOMDecryptContext);
            encryptedKeyToken.setKeyProvider(encryptedKeyProvider);
        }
        catch (XMLEncryptionException xMLEncryptionException) {
            throw new WSSecurityException(xMLEncryptionException, WSSConstants.FAILURE_INVALID);
        }
        wSSecurityContext.addKeyProvider(encryptedKeyProvider);
        wSSecurityContext.addSecurityToken(encryptedKeyToken);
        wSSecurityContext.addToken(encryptedKeyToken, wSSecurityContext.getElementById(encryptedKey.getId()));
        List list = encryptedKey.getReferenceList();
        if ((list == null || list.size() == 0) && encryptedKeyToken != null) {
            KeySelectorResult keySelectorResult = encryptedKeyProvider.getKey("http://www.w3.org/2001/04/xmlenc#aes256-cbc", KeySelector.Purpose.DECRYPT);
            if (keySelectorResult != null) {
                encryptedKeyToken.setSecretKey(keySelectorResult.getKey());
            } else {
                keySelectorResult = encryptedKeyProvider.getKey("http://www.w3.org/2001/04/xmlenc#tripledes-cbc", KeySelector.Purpose.DECRYPT);
                if (keySelectorResult != null) {
                    encryptedKeyToken.setSecretKey(keySelectorResult.getKey());
                }
            }
        }
        return encryptedKeyProvider;
    }

    protected boolean isHeader(Node node) {
        return DOMUtils.is(node.getParentNode(), "http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", "EncryptedHeader");
    }

    protected void handleEncryptedHeader(Node node) {
        Node node2 = node.getParentNode();
        Node node3 = node2.getNextSibling();
        Node node4 = node2.getParentNode();
        node4.removeChild(node2);
        node4.insertBefore(node, node3);
    }

    private void init() {
        this.register(sch);
    }

    static class SignatureConfirmationHandler
    implements SecurityImpl.SecurityHeaderElementHandler {
        private static final String EMPTY_STRING = "";

        SignatureConfirmationHandler() {
        }

        public QName getQName() {
            return WSS11Constants.SIG_CONF_QNAME;
        }

        public void process(Node node, WSSecurityContext wSSecurityContext) throws weblogic.xml.crypto.api.MarshalException {
            SignatureConfirmation signatureConfirmation = WSS11Factory.newSignatureConfirmation();
            try {
                signatureConfirmation.unmarshal(node);
                ((WSS11Context)wSSecurityContext).addSignatureConfirmation(signatureConfirmation);
            }
            catch (MarshalException marshalException) {
                throw new weblogic.xml.crypto.api.MarshalException(marshalException);
            }
        }

        public void validate(WSSecurityContext wSSecurityContext) throws WSSecurityException {
            WSS11Context wSS11Context = (WSS11Context)wSSecurityContext;
            if (null == wSS11Context) {
                this.handleError("Invalid context");
            }
        }

        private void handleError(String string) throws WSSecurityException {
            LogUtils.logWss("Failed to validate SignatureConfirmation. " + string);
            throw new WSSecurityException("Failed to validate SignatureConfirmation." + string, WSSConstants.FAILURE_INVALID);
        }
    }
}

