/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.wss11.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import weblogic.security.service.ContextHandler;
import weblogic.xml.crypto.common.keyinfo.KeySelectorResultImpl;
import weblogic.xml.crypto.dsig.DsigConstants;
import weblogic.xml.crypto.dsig.ReferenceImpl;
import weblogic.xml.crypto.dsig.XMLSignatureImpl;
import weblogic.xml.crypto.dsig.api.Reference;
import weblogic.xml.crypto.dsig.api.SignedInfo;
import weblogic.xml.crypto.dsig.api.XMLSignature;
import weblogic.xml.crypto.dsig.api.keyinfo.KeyInfo;
import weblogic.xml.crypto.encrypt.api.EncryptedData;
import weblogic.xml.crypto.encrypt.api.EncryptionMethod;
import weblogic.xml.crypto.encrypt.api.TBE;
import weblogic.xml.crypto.encrypt.api.XMLEncryptionException;
import weblogic.xml.crypto.encrypt.api.keyinfo.EncryptedKey;
import weblogic.xml.crypto.utils.LogUtils;
import weblogic.xml.crypto.wss.Encryption;
import weblogic.xml.crypto.wss.SecurityTokenContextHandler;
import weblogic.xml.crypto.wss.WSSConstants;
import weblogic.xml.crypto.wss.WSSecurityContext;
import weblogic.xml.crypto.wss.WSSecurityException;
import weblogic.xml.crypto.wss.provider.Purpose;
import weblogic.xml.crypto.wss.provider.SecurityToken;
import weblogic.xml.crypto.wss.provider.SecurityTokenReference;
import weblogic.xml.crypto.wss11.internal.STRType;
import weblogic.xml.crypto.wss11.internal.SecurityValidator;
import weblogic.xml.crypto.wss11.internal.SignatureConfirmation;
import weblogic.xml.crypto.wss11.internal.WSS11Context;

public class SecurityValidatorImpl
extends weblogic.xml.crypto.wss.SecurityValidatorImpl
implements SecurityValidator {
    public static final String VERBOSE_PROPERTY = "weblogic.xml.crypto.wss11.verbose";
    public static final boolean VERBOSE = Boolean.getBoolean("weblogic.xml.crypto.wss11.verbose");
    private static final boolean DEBUG = true;
    private static final boolean WS_POLICY_INTEROP = false;
    private static final STRType enckeyDirectSTR = new STRType(WSSConstants.REFERENCE_QNAME, "http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
    private static final List enckeyDirectSTRList = new ArrayList();
    public static final String DK_VALUE_TYPE_V2005 = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk";
    public static final String DK_VALUE_TYPE_V13 = "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/dk";

    public SecurityValidatorImpl(WSSecurityContext wSSecurityContext) {
        super(wSSecurityContext);
    }

    public boolean validateSignature(SignedInfo signedInfo, String string, List list, String string2, Node node) throws WSSecurityException {
        List list2 = this.securityCtx.getSignatures();
        for (XMLSignature xMLSignature : list2) {
            XMLSignatureImpl xMLSignatureImpl = (XMLSignatureImpl)xMLSignature;
            KeySelectorResultImpl keySelectorResultImpl = (KeySelectorResultImpl)xMLSignatureImpl.getSignatureValidateResult().getKeySelectorResult();
            SecurityToken securityToken = keySelectorResultImpl.getSecurityToken();
            if (SecurityValidatorImpl.match(xMLSignature.getSignedInfo(), signedInfo) && this.match(list, xMLSignature.getKeyInfo()) && this.validateSecurityToken(securityToken, string, string2, node, Purpose.SIGN) && this.validateIncludedInMessage(securityToken)) {
                return true;
            }
            if (!SecurityValidatorImpl.match(xMLSignature.getSignedInfo(), signedInfo)) {
                System.err.println("SignInfo mismatch " + this.getMismatchInfo(xMLSignature.getSignedInfo(), signedInfo));
                LogUtils.logWss("SignInfo mismatch " + this.getMismatchInfo(xMLSignature.getSignedInfo(), signedInfo));
            }
            if (!this.match(list, xMLSignature.getKeyInfo())) {
                System.err.println("STR type mismatch " + this.getMismatchInfo(list, xMLSignature.getKeyInfo()));
                LogUtils.logWss("STR type mismatch " + this.getMismatchInfo(list, xMLSignature.getKeyInfo()));
            }
            if (!this.validateSecurityToken(securityToken, string, string2, node, Purpose.SIGN)) {
                System.err.println("Security Token mismatch, token type =" + string + " and actual is" + securityToken.getValueType());
                LogUtils.logWss("Security Token mismatch, token type =" + string + " and actual is" + securityToken.getValueType());
            }
            if (this.validateIncludedInMessage(securityToken)) continue;
            System.err.println("Security Token doesn't match Token Inclusion assertion in policy, included in message = " + this.securityCtx.getProperty("weblogic.xml.crypto.wss.SecurityValidator.securityTokenIncludedInMessage") + ", token id = " + securityToken.getId() + ", token type = " + securityToken.getValueType());
            LogUtils.logWss("Security Token doesn't match [Security Token Inclusion] assertion in policy, token id = " + securityToken.getId() + ", token type = " + securityToken.getValueType());
        }
        return false;
    }

    private String getMismatchInfo(List list, List list2) throws WSSecurityException {
        Reference reference;
        int n;
        StringBuffer stringBuffer = new StringBuffer(" Refs:");
        stringBuffer.append(" Msg size =" + list.size());
        for (n = 0; n < list.size(); ++n) {
            reference = (Reference)list.get(n);
            stringBuffer.append(reference.getURI() + ",");
        }
        stringBuffer.append(" Policy size =" + list2.size());
        for (n = 0; n < list2.size(); ++n) {
            reference = (Reference)list2.get(n);
            stringBuffer.append(" " + reference.getURI() + ",");
        }
        return stringBuffer.toString();
    }

    private String getMismatchInfo(SignedInfo signedInfo, SignedInfo signedInfo2) throws WSSecurityException {
        StringBuffer stringBuffer = new StringBuffer();
        if (!signedInfo.getCanonicalizationMethod().getAlgorithm().equals(signedInfo2.getCanonicalizationMethod().getAlgorithm())) {
            stringBuffer.append("C14N mismatch " + signedInfo.getCanonicalizationMethod().getAlgorithm() + " VS. " + signedInfo2.getCanonicalizationMethod().getAlgorithm());
        }
        if (!signedInfo.getSignatureMethod().getAlgorithm().equals(signedInfo2.getSignatureMethod().getAlgorithm())) {
            stringBuffer.append(" Algo mismatch " + signedInfo.getSignatureMethod().getAlgorithm() + " VS. " + signedInfo2.getSignatureMethod().getAlgorithm());
        }
        stringBuffer.append(this.getMismatchInfo(signedInfo.getReferences(), signedInfo2.getReferences()));
        return stringBuffer.toString();
    }

    private String getMismatchInfo(List list, KeyInfo keyInfo) {
        StringBuffer stringBuffer = new StringBuffer("Actual KeyInfo:");
        List list2 = keyInfo.getContent();
        for (Object object : list2) {
            if (!(object instanceof SecurityTokenReference)) continue;
            SecurityTokenReference securityTokenReference = (SecurityTokenReference)object;
            QName qName = securityTokenReference.getSTRType();
            stringBuffer.append(qName);
            stringBuffer.append("|" + securityTokenReference.getValueType() + ", ");
        }
        stringBuffer.append(" StrTypes size=" + list.size() + " :");
        for (Object object : list) {
            stringBuffer.append(((STRType)object).getTopLevelElement().toString() + "|");
            stringBuffer.append("|" + ((STRType)object).getValueType() + ", ");
        }
        return stringBuffer.toString();
    }

    private boolean match(List list, KeyInfo keyInfo) {
        if (null == list || list.size() == 0) {
            return true;
        }
        List list2 = keyInfo.getContent();
        for (Object e : list2) {
            if (!(e instanceof SecurityTokenReference)) continue;
            SecurityTokenReference securityTokenReference = (SecurityTokenReference)e;
            QName qName = securityTokenReference.getSTRType();
            String string = securityTokenReference.getValueType();
            for (STRType sTRType : list) {
                if (sTRType.getTopLevelElement().equals(qName) && (sTRType.getValueType() == null || sTRType.getValueType().equals(string) || null == string)) {
                    return true;
                }
                if (!sTRType.getTopLevelElement().equals(DsigConstants.X509ISSUER_SERIAL_QNAME) || securityTokenReference.getIssuerSerial() == null) continue;
                return true;
            }
        }
        return false;
    }

    public boolean validateEncryption(List list, EncryptionMethod encryptionMethod, EncryptionMethod encryptionMethod2, String string, List list2, String string2, Node node) throws WSSecurityException, XMLEncryptionException {
        return this.validateEncryption(list, encryptionMethod, encryptionMethod2, string, list2, string2, node, null);
    }

    public boolean validateEncryptionforEncryptFirst(List list, EncryptionMethod encryptionMethod, EncryptionMethod encryptionMethod2, String string, List list2, String string2, Node node, Map hashMap) throws WSSecurityException, XMLEncryptionException {
        if (null == hashMap) {
            hashMap = new HashMap();
        }
        return this.validateEncryption(list, encryptionMethod, encryptionMethod2, string, list2, string2, node, hashMap);
    }

    private boolean validateEncryption(List list, EncryptionMethod encryptionMethod, EncryptionMethod encryptionMethod2, String string, List list2, String string2, Node node, Map map) throws WSSecurityException, XMLEncryptionException {
        EncryptedKey encryptedKey = null;
        boolean bl = this.hasDkStrType(list2);
        List list3 = this.securityCtx.getEncryptions();
        for (TBE tBE : list) {
            boolean bl2 = false;
            for (Encryption encryption : list3) {
                EncryptedData encryptedData = encryption.getEncryptedData();
                EncryptedKey encryptedKey2 = encryption.getEncryptedKey();
                List list4 = encryption.getNodes();
                if (encryptedKey != null && encryptedKey == encryptedKey2) {
                    if (!encryptedData.getEncryptionMethod().getAlgorithm().equals(encryptionMethod2.getAlgorithm()) || !this.matchNodes(list4, tBE)) continue;
                    bl2 = true;
                    this.addReferenceIntoEncryptedDataMap(map, list4, encryptedData);
                    break;
                }
                KeySelectorResultImpl keySelectorResultImpl = (KeySelectorResultImpl)encryption.getKeySelectorResult();
                if (!((encryption.getEncryptedKey() != null && this.match(list2, encryption.getEncryptedKey().getKeyInfo()) || encryption.getEncryptedKey() == null) && this.validateSecurityToken(keySelectorResultImpl.getSecurityToken(), string, string2, node, Purpose.DECRYPT) && this.validateIncludedInMessage(keySelectorResultImpl.getSecurityToken()))) {
                    return false;
                }
                encryptedKey = encryptedKey2;
                if (!encryptedData.getEncryptionMethod().getAlgorithm().equals(encryptionMethod2.getAlgorithm()) || !this.matchNodes(list4, tBE)) continue;
                bl2 = true;
                this.addReferenceIntoEncryptedDataMap(map, list4, encryptedData);
                break;
            }
            if (bl2) continue;
            return false;
        }
        return true;
    }

    private void addReferenceIntoEncryptedDataMap(Map map, List list, EncryptedData encryptedData) {
        if (null != map) {
            for (int i = 0; i < list.size(); ++i) {
                Node node = (Node)list.get(i);
                if (null == node.getLocalName()) continue;
                map.put(new QName(node.getNamespaceURI(), node.getLocalName()), encryptedData.getId());
                try {
                    String string = this.getUri((Element)node);
                    map.put(string, encryptedData.getId());
                    continue;
                }
                catch (WSSecurityException wSSecurityException) {
                    LogUtils.logEncrypt("NO URI for " + node.getLocalName() + " ERROR " + wSSecurityException.toString());
                }
            }
        }
    }

    private boolean hasDkStrType(List list) {
        if (null == list || list.size() == 0) {
            return false;
        }
        for (STRType sTRType : list) {
            if (!DK_VALUE_TYPE_V2005.equals(sTRType.getValueType()) && !DK_VALUE_TYPE_V13.equals(sTRType.getValueType())) continue;
            return true;
        }
        return false;
    }

    public boolean validateSignatureAndEncryptionRequest(SignedInfo signedInfo, List list, EncryptionMethod encryptionMethod, EncryptionMethod encryptionMethod2, String string, List list2, String string2, boolean bl, ContextHandler contextHandler) throws WSSecurityException, XMLEncryptionException {
        boolean bl2;
        if (list != null && list.size() != 0 && !(bl2 = this.validateEncryption(list, encryptionMethod, encryptionMethod2, string, list2, string2, null))) {
            return false;
        }
        if (signedInfo != null) {
            this.securityCtx.setProperty("weblogic.xml.crypto.wss.SecurityValidator.securityTokenIncludedInMessage", null);
            return this.validateSignature(signedInfo, "http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey", enckeyDirectSTRList, string2, null);
        }
        return true;
    }

    public boolean validateEncryptionAndSignatureRequest(SignedInfo signedInfo, List list, EncryptionMethod encryptionMethod, EncryptionMethod encryptionMethod2, String string, List list2, String string2, boolean bl, ContextHandler contextHandler) throws WSSecurityException, XMLEncryptionException {
        Map map;
        boolean bl2 = true;
        if (list != null && list.size() != 0) {
            map = new HashMap();
            bl2 = this.validateEncryption(list, encryptionMethod, encryptionMethod2, string, list2, string2, null, map);
            if (!bl2) {
                this.securityCtx.setProperty("weblogic.xml.crypto.wss.SecurityValidator.securityTokenIncludedInMessage", null);
                bl2 = this.validateEncryption(list, encryptionMethod, encryptionMethod2, "http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey", list2, string2, null, map);
            }
            if (!bl2) {
                return bl2;
            }
            if (!map.isEmpty()) {
                ((SecurityTokenContextHandler)contextHandler).addContextElement("weblogic.wsee.security.encrypted_element.map", map);
            }
        }
        if (signedInfo != null) {
            map = (Map)contextHandler.getValue("weblogic.wsee.security.encrypted_element.map");
            if (null != map) {
                for (ReferenceImpl referenceImpl : signedInfo.getReferences()) {
                    if (!map.containsKey(referenceImpl.getURI())) continue;
                    referenceImpl.setUri("#" + (String)map.get(referenceImpl.getURI()));
                }
            }
            this.securityCtx.setProperty("weblogic.xml.crypto.wss.SecurityValidator.securityTokenIncludedInMessage", null);
            bl2 = this.validateSignature(signedInfo, "http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey", enckeyDirectSTRList, string2, null);
        }
        return bl2;
    }

    public boolean validateSignatureAndEncryptionResponse(SignedInfo signedInfo, List list, EncryptionMethod encryptionMethod, ContextHandler contextHandler) throws WSSecurityException, XMLEncryptionException {
        boolean bl;
        this.securityCtx.setProperty("weblogic.xml.crypto.wss.SecurityValidator.securityTokenIncludedInMessage", null);
        if (list != null && list.size() != 0 && !(bl = this.validateEncryption(list, null, encryptionMethod, "http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey", null, null))) {
            return false;
        }
        if (signedInfo != null) {
            return this.validateSignature(signedInfo, "http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey", null, null);
        }
        return true;
    }

    public boolean validateSignatureConfirmation() {
        WSS11Context wSS11Context = (WSS11Context)this.securityCtx;
        List list = wSS11Context.getSignatureConfirmations();
        if (list == null || list.size() == 0) {
            LogUtils.logWss("No SignatureConfirmation element.");
            return false;
        }
        List<String[]> list2 = wSS11Context.getPreviousMessageSignatureValues();
        boolean bl = false;
        for (String[] stringArray : list2) {
            if (!this.validateSignatureConfirmationForRequest(list, stringArray)) continue;
            bl = true;
            break;
        }
        if (bl) {
            return true;
        }
        return true;
    }

    private boolean validateSignatureConfirmationForRequest(List list, String[] stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            if (stringArray.length != list.size()) {
                LogUtils.logWss("Number of SignatureConfirmation elements does not match number of Signatures from request.");
                return false;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                boolean bl = false;
                for (SignatureConfirmation signatureConfirmation : list) {
                    if (null == signatureConfirmation.getSignatureValue() || !signatureConfirmation.getSignatureValue().equals(string)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                LogUtils.logWss("Failed to validate SignatureConfirmation/@Value: " + string);
                return false;
            }
        } else {
            if (list.size() > 1) {
                LogUtils.logWss("No Signature in request, but more than one SignatureConfirmation in response.");
                return false;
            }
            SignatureConfirmation signatureConfirmation = (SignatureConfirmation)list.get(0);
            String string = signatureConfirmation.getSignatureValue();
            if (string != null && !string.trim().equals("")) {
                LogUtils.logWss("No Signature in request, but SignatureConfirmation/@Value is not empty.");
                return false;
            }
        }
        return true;
    }

    static {
        enckeyDirectSTRList.add(enckeyDirectSTR);
    }
}

