/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.wss11.internal;

import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import weblogic.xml.crypto.utils.DOMUtils;
import weblogic.xml.crypto.wss.WSSConstants;
import weblogic.xml.crypto.wss11.internal.SignatureConfirmation;
import weblogic.xml.crypto.wss11.internal.WSS11Constants;
import weblogic.xml.dom.marshal.MarshalException;

public class SignatureConfirmationImpl
implements SignatureConfirmation {
    private static final String ID_PREFIX = "sigconf";
    private String id = DOMUtils.generateId("sigconf");
    private String signatureValue = null;
    private Node signatureConfirmationNode;

    public SignatureConfirmationImpl() {
    }

    public SignatureConfirmationImpl(String string) {
        this.signatureValue = string;
    }

    public String getId() {
        return this.id;
    }

    public String getSignatureValue() {
        return this.signatureValue;
    }

    public Node getSignatureConfirmationNode() {
        return this.signatureConfirmationNode;
    }

    public boolean isFeatureSupported(String string) {
        return false;
    }

    public void marshal(Element element, Node node, Map map) throws MarshalException {
        String string = (String)map.get("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd");
        if (null == string) {
            string = "wsse11";
        }
        String string2 = (String)map.get("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        Element element2 = DOMUtils.createElement(element, WSS11Constants.SIG_CONF_QNAME, string);
        DOMUtils.addPrefixedAttribute(element2, WSSConstants.WSU_ID_QNAME, string2, this.id);
        if (this.signatureValue != null) {
            DOMUtils.addAttribute(element2, WSS11Constants.VALUE_QNAME, this.signatureValue);
        }
        if (node != null) {
            element.insertBefore(element2, node);
        } else {
            element.appendChild(element2);
        }
        this.signatureConfirmationNode = element2;
    }

    public void unmarshal(Node node) throws MarshalException {
        Element element = (Element)node;
        this.id = DOMUtils.getAttributeValue(element, WSSConstants.WSU_ID_QNAME);
        this.signatureValue = DOMUtils.getAttributeValue(element, WSS11Constants.VALUE_QNAME);
        this.signatureConfirmationNode = node;
    }
}

