/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.wss11.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Node;
import weblogic.xml.crypto.dsig.api.XMLSignature;
import weblogic.xml.crypto.encrypt.Utils;
import weblogic.xml.crypto.wss.WSSecurityContext;
import weblogic.xml.crypto.wss11.internal.SignatureConfirmation;
import weblogic.xml.crypto.wss11.internal.bst.BSTHandler;
import weblogic.xml.crypto.wss11.internal.enckey.EncryptedKeyToken;
import weblogic.xml.crypto.wss11.internal.enckey.EncryptedKeyTokenHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSS11Context
extends WSSecurityContext {
    private static final long serialVersionUID = -8569410379759001216L;
    private static final String WSS11_PREVIOUS_MESSAGE_SIGNATURE_VALUES = "weblogic.xml.crypto.wss11.previousMessageSignatureValues";
    private transient boolean useSignatureConfirmation = false;
    private transient List sigConfs = new ArrayList();
    private transient Object policyOutline = null;
    private transient int requestPolicyIdx = 0;

    public WSS11Context(Node node) {
        super(node);
    }

    public WSS11Context(Node node, Node node2, Set set, Map map) {
        super(node, node2, set, map);
    }

    @Override
    protected void init() {
        super.init();
        this.setTokenHandler(new EncryptedKeyTokenHandler());
        this.setTokenHandler(new BSTHandler());
    }

    public void addSignatureConfirmation(SignatureConfirmation signatureConfirmation) {
        this.sigConfs.add(signatureConfirmation);
    }

    public List getSignatureConfirmations() {
        return this.sigConfs;
    }

    public void addPreviousMessageSignatureValues(String[] stringArray) {
        List<String[]> list = this.internalGetPreviousMessageSignatureValues();
        list.add(stringArray);
        this.setProperty(WSS11_PREVIOUS_MESSAGE_SIGNATURE_VALUES, list);
    }

    private List<String[]> internalGetPreviousMessageSignatureValues() {
        ArrayList<Object> arrayList;
        ArrayList<Object> arrayList2 = this.getProperty(WSS11_PREVIOUS_MESSAGE_SIGNATURE_VALUES);
        if (arrayList2 instanceof String[]) {
            arrayList = new ArrayList<String[]>();
            arrayList.add((String[])arrayList2);
            arrayList2 = arrayList;
        }
        if ((arrayList = (ArrayList<String[]>)arrayList2) == null) {
            arrayList = new ArrayList();
        }
        return arrayList;
    }

    public List<String[]> getPreviousMessageSignatureValues() {
        List<String[]> list = this.internalGetPreviousMessageSignatureValues();
        if (list.size() == 0) {
            list = new ArrayList<String[]>();
            list.add(null);
        }
        return list;
    }

    public String[] getSignatureValues() {
        String[] stringArray = new String[this.getSignatures().size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = Utils.base64(((XMLSignature)this.getSignatures().get(i)).getSignatureValue());
        }
        return stringArray;
    }

    public boolean isUseSignatureConfirmation() {
        return this.useSignatureConfirmation;
    }

    public void setUseSignatureConfirmation(boolean bl) {
        this.useSignatureConfirmation = bl;
    }

    public Object getPolicyOutline() {
        return this.policyOutline;
    }

    public void setPolicyOutline(Object object) {
        this.policyOutline = object;
    }

    public int getRequestPolicyIdx() {
        return this.requestPolicyIdx;
    }

    public void setRequestPolicyIdx(int n) {
        this.requestPolicyIdx = n;
    }

    public boolean hasDerivedKey() {
        List list = this.getSecurityTokens();
        if (null == list || list.size() == 0) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            EncryptedKeyToken encryptedKeyToken;
            Object e = list.get(i);
            if (!(e instanceof EncryptedKeyToken) || (encryptedKeyToken = (EncryptedKeyToken)e).getSecretKey() == null) continue;
            return true;
        }
        return false;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.useSignatureConfirmation = false;
        this.sigConfs = new ArrayList();
        this.policyOutline = null;
        this.requestPolicyIdx = 0;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }
}

