/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.wss11.internal.bst;

import java.security.cert.X509Certificate;
import java.util.List;
import javax.xml.namespace.QName;
import weblogic.xml.crypto.encrypt.Utils;
import weblogic.xml.crypto.utils.CertUtils;
import weblogic.xml.crypto.wss.BSTUtils;
import weblogic.xml.crypto.wss.BinarySecurityTokenHandler;
import weblogic.xml.crypto.wss.WSSConstants;
import weblogic.xml.crypto.wss.WSSecurityContext;
import weblogic.xml.crypto.wss.WSSecurityException;
import weblogic.xml.crypto.wss.X509Credential;
import weblogic.xml.crypto.wss.api.BinarySecurityToken;
import weblogic.xml.crypto.wss.api.KeyIdentifier;
import weblogic.xml.crypto.wss.provider.Purpose;
import weblogic.xml.crypto.wss.provider.SecurityToken;
import weblogic.xml.crypto.wss.provider.SecurityTokenReference;
import weblogic.xml.crypto.wss11.internal.bst.BSTR;

public class BSTHandler
extends BinarySecurityTokenHandler {
    private static final String[] VALUE_TYPES = new String[]{"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v1", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509PKIPathv1", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#PKCS7", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509SubjectKeyIdentifier", "http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#ThumbprintSHA1"};

    protected SecurityToken getTokenByKeyId(KeyIdentifier keyIdentifier, String string, String string2, List list, Purpose purpose, WSSecurityContext wSSecurityContext) throws WSSecurityException {
        Object object2;
        for (Object object2 : list) {
            if (!(object2 instanceof BinarySecurityToken) || !BSTHandler.matches(keyIdentifier, string2, (X509Credential)object2.getCredential())) continue;
            return this.amend((BinarySecurityToken)object2, purpose, wSSecurityContext);
        }
        Object object3 = this.getCredential("com.bea.contextelement.xml.KeyIdentifier", keyIdentifier, string, purpose, wSSecurityContext);
        if (object3 != null) {
            return this.getToken(object3, string, wSSecurityContext);
        }
        object2 = BSTHandler.lookupCertificate(keyIdentifier.getIdentifier(), string2);
        if (object2 != null) {
            return this.getToken((X509Certificate)object2, string, wSSecurityContext);
        }
        throw new WSSecurityException("Failed to resolve security token from key identifier " + keyIdentifier, WSSConstants.FAILURE_TOKEN_UNAVAILABLE);
    }

    public SecurityTokenReference getSTR(QName qName, String string, SecurityToken securityToken) throws WSSecurityException {
        if (securityToken == null) {
            return null;
        }
        return new BSTR(qName, string, securityToken);
    }

    private static X509Certificate lookupCertificate(byte[] byArray, String string) {
        if ("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#ThumbprintSHA1".equals(string)) {
            return CertUtils.lookupCertificate(Utils.toBase64(byArray));
        }
        return CertUtils.lookupCertificate(byArray);
    }

    public static boolean matches(KeyIdentifier keyIdentifier, String string, X509Credential x509Credential) {
        if ("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#ThumbprintSHA1".equals(string)) {
            return BSTUtils.matchesThumbprint(keyIdentifier, x509Credential);
        }
        return BSTUtils.matches(keyIdentifier, x509Credential);
    }

    public String[] getValueTypes() {
        return VALUE_TYPES;
    }
}

