/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.wss11.internal.bst;

import java.security.cert.X509Certificate;
import javax.xml.namespace.QName;
import weblogic.xml.crypto.utils.CertUtils;
import weblogic.xml.crypto.wss.BinarySecurityTokenReference;
import weblogic.xml.crypto.wss.KeyIdentifierImpl;
import weblogic.xml.crypto.wss.WSSConstants;
import weblogic.xml.crypto.wss.WSSecurityException;
import weblogic.xml.crypto.wss.api.BinarySecurityToken;
import weblogic.xml.crypto.wss.provider.SecurityToken;

public class BSTR
extends BinarySecurityTokenReference {
    public BSTR(QName qName, String string, SecurityToken securityToken) throws WSSecurityException {
        super(qName, string, securityToken);
    }

    protected void init(QName qName, String string, SecurityToken securityToken) throws WSSecurityException {
        if (WSSConstants.KEY_IDENTIFIER_QNAME.equals(qName) && "http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#ThumbprintSHA1".equals(string)) {
            this.initThumbprint(securityToken);
        } else {
            super.init(qName, string, securityToken);
        }
    }

    private void initThumbprint(SecurityToken securityToken) throws WSSecurityException {
        this.setValueType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#ThumbprintSHA1");
        X509Certificate x509Certificate = ((BinarySecurityToken)securityToken).getCertificate();
        this.setKeyIdentifier(new KeyIdentifierImpl(CertUtils.getThumbprint(x509Certificate)));
    }
}

