/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.wss11.internal.enckey;

import java.util.Map;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import weblogic.xml.crypto.common.keyinfo.EncryptedKeyProvider;
import weblogic.xml.crypto.utils.DOMUtils;
import weblogic.xml.crypto.wss.KeyIdentifierImpl;
import weblogic.xml.crypto.wss.SecurityTokenReferenceImpl;
import weblogic.xml.crypto.wss.WSSConstants;
import weblogic.xml.crypto.wss11.internal.WSS11Constants;
import weblogic.xml.crypto.wss11.internal.enckey.EncryptedKeyToken;
import weblogic.xml.crypto.wss11.internal.enckey.EncryptedKeyTokenHandler;

public class EncryptedKeySTR
extends SecurityTokenReferenceImpl {
    public EncryptedKeySTR() {
    }

    public static void init() {
        EncryptedKeySTR.register(new EncryptedKeyTokenHandler());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EncryptedKeySTR(QName qName, EncryptedKeyToken encryptedKeyToken) {
        super(qName, null, encryptedKeyToken);
        if (WSSConstants.KEY_IDENTIFIER_QNAME.equals(qName)) {
            EncryptedKeyProvider encryptedKeyProvider = (EncryptedKeyProvider)encryptedKeyToken.getCredential();
            if (encryptedKeyProvider == null) throw new IllegalArgumentException("EncryptedKeySRT of type " + qName + " requires CipherValue in token.");
            this.setValueType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKeySHA1");
            this.setKeyIdentifier(new KeyIdentifierImpl(encryptedKeyProvider.getIdentifier()));
            return;
        } else {
            if (!WSSConstants.REFERENCE_QNAME.equals(qName)) throw new IllegalArgumentException("Unsupported SecurityTokenReference type for EncryptedKey: " + qName);
            this.setValueType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
            this.setReferenceURI("#" + encryptedKeyToken.getId());
        }
    }

    protected void marshalAttributes(Element element, Map map) {
        String string = EncryptedKeySTR.getPrefix(map, "http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", "wsse11");
        DOMUtils.addPrefixedAttribute(element, WSS11Constants.TOKEN_TYPE_QNAME, string, "http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
        DOMUtils.declareNamespace(element, "http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", string);
    }
}

