/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.wss11.internal.enckey;

import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import weblogic.xml.crypto.common.keyinfo.EncryptedKeyProvider;
import weblogic.xml.crypto.common.keyinfo.KeyProvider;
import weblogic.xml.crypto.encrypt.api.XMLEncryptionException;
import weblogic.xml.crypto.encrypt.api.dom.DOMEncryptContext;
import weblogic.xml.crypto.encrypt.api.keyinfo.EncryptedKey;
import weblogic.xml.crypto.wss.provider.SecurityToken;
import weblogic.xml.dom.marshal.MarshalException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncryptedKeyToken
implements SecurityToken {
    private transient Key key = null;
    private String id = null;
    private EncryptedKeyProvider keyProvider = null;
    private EncryptedKey encryptedKey = null;
    private DOMEncryptContext encCtx = null;
    private String valueType = "http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey";

    public EncryptedKeyToken() {
    }

    public EncryptedKeyToken(EncryptedKeyProvider encryptedKeyProvider, String string) {
        this.keyProvider = encryptedKeyProvider;
        this.id = string;
    }

    public EncryptedKeyToken(Key key, String string) {
        this.key = key;
        this.id = string;
    }

    @Override
    public boolean isFeatureSupported(String string) {
        return false;
    }

    @Override
    public String getValueType() {
        return this.valueType;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String string) {
    }

    @Override
    public PrivateKey getPrivateKey() {
        return null;
    }

    @Override
    public PublicKey getPublicKey() {
        return null;
    }

    @Override
    public Key getSecretKey() {
        return this.key;
    }

    public void setSecretKey(Key key) {
        this.key = key;
    }

    @Override
    public Object getCredential() {
        return this.keyProvider;
    }

    public KeyProvider getKeyProvider() {
        return this.keyProvider;
    }

    public void setEncryptedKey(EncryptedKey encryptedKey) throws XMLEncryptionException {
        this.encryptedKey = encryptedKey;
        this.id = encryptedKey.getId();
        this.keyProvider = new EncryptedKeyProvider(encryptedKey, this.key, this);
    }

    public EncryptedKey getEncryptedKey() {
        return this.encryptedKey;
    }

    public void setKeyProvider(EncryptedKeyProvider encryptedKeyProvider) {
        this.keyProvider = encryptedKeyProvider;
    }

    public void setDOMEncryptContext(DOMEncryptContext dOMEncryptContext) {
        this.encCtx = dOMEncryptContext;
    }

    public DOMEncryptContext getDOMEncryptContext() {
        return this.encCtx;
    }

    @Override
    public void marshal(Element element, Node node, Map map) throws MarshalException {
    }

    @Override
    public void unmarshal(Node node) throws MarshalException {
    }

    public byte[] getKeyIdentifier() throws XMLEncryptionException {
        return EncryptedKeyProvider.getKeyIdentifier(this.encryptedKey);
    }

    public List<byte[]> getKeyIdentifiers() throws XMLEncryptionException {
        return EncryptedKeyProvider.getKeyIdentifiers(this.encryptedKey);
    }
}

