/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.wss11.internal.enckey;

import java.security.Key;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.MessageContext;
import org.w3c.dom.Node;
import weblogic.security.service.ContextHandler;
import weblogic.xml.crypto.api.KeySelector;
import weblogic.xml.crypto.common.keyinfo.EncryptedKeyProvider;
import weblogic.xml.crypto.common.keyinfo.KeyProvider;
import weblogic.xml.crypto.common.keyinfo.SecretKeyProvider;
import weblogic.xml.crypto.dsig.api.keyinfo.KeyInfo;
import weblogic.xml.crypto.encrypt.api.EncryptionMethod;
import weblogic.xml.crypto.encrypt.api.TBEKey;
import weblogic.xml.crypto.encrypt.api.XMLEncryptionException;
import weblogic.xml.crypto.encrypt.api.dom.DOMEncryptContext;
import weblogic.xml.crypto.encrypt.api.keyinfo.EncryptedKey;
import weblogic.xml.crypto.utils.DOMUtils;
import weblogic.xml.crypto.utils.EncryptedKeyUtils;
import weblogic.xml.crypto.wss.SecurityTokenValidateResult;
import weblogic.xml.crypto.wss.WSSConstants;
import weblogic.xml.crypto.wss.WSSecurityContext;
import weblogic.xml.crypto.wss.WSSecurityException;
import weblogic.xml.crypto.wss.WSSecurityInfo;
import weblogic.xml.crypto.wss.provider.Purpose;
import weblogic.xml.crypto.wss.provider.SecurityToken;
import weblogic.xml.crypto.wss.provider.SecurityTokenHandler;
import weblogic.xml.crypto.wss.provider.SecurityTokenReference;
import weblogic.xml.crypto.wss11.internal.STRType;
import weblogic.xml.crypto.wss11.internal.WSS11Constants;
import weblogic.xml.crypto.wss11.internal.enckey.EncryptedKeySTR;
import weblogic.xml.crypto.wss11.internal.enckey.EncryptedKeyToken;
import weblogic.xml.dom.marshal.MarshalException;

public class EncryptedKeyTokenHandler
implements SecurityTokenHandler {
    private static final SecurityTokenValidateResult TRUE = new SecurityTokenValidateResult(true);

    public SecurityToken getSecurityToken(String string, Object object, ContextHandler contextHandler) throws WSSecurityException {
        if (object instanceof EncryptedKeyProvider) {
            EncryptedKeyProvider encryptedKeyProvider = (EncryptedKeyProvider)object;
            return new EncryptedKeyToken(encryptedKeyProvider, "");
        }
        try {
            Object object2;
            Object object3 = null;
            String string2 = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3";
            Key key = (Key)object;
            WSSecurityContext wSSecurityContext = (WSSecurityContext)contextHandler.getValue("com.bea.contextelement.xml.SecurityInfo");
            Object object4 = wSSecurityContext.getCredentialProvider(string2);
            if (object4 != null) {
                object3 = object4.getCredential(string2, null, contextHandler, Purpose.ENCRYPT);
            }
            if (object3 == null) {
                string2 = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v1";
                object2 = object4;
                object4 = wSSecurityContext.getCredentialProvider(string2);
                if (object4 != null) {
                    object3 = object4.getCredential(string2, null, contextHandler, Purpose.ENCRYPT);
                } else {
                    object4 = object2;
                }
            }
            if (object4 == null) {
                throw new WSSecurityException("EncryptedKeyTokenHandler does not know how to handle: " + object + " when the x509 CredProvider not found");
            }
            if (object3 != null) {
                Object object5;
                object2 = wSSecurityContext.getTokenHandler(string2);
                SecurityToken securityToken = object2.getSecurityToken(string2, object3, contextHandler);
                SecurityTokenReference securityTokenReference = null;
                if (contextHandler.getValue("weblogic.wsee.dk.base_token_referece_type") != null) {
                    object5 = (STRType)contextHandler.getValue("weblogic.wsee.dk.base_token_referece_type");
                    securityTokenReference = object2.getSTR(WSSConstants.KEY_IDENTIFIER_QNAME, ((STRType)object5).getValueType(), securityToken);
                } else {
                    securityTokenReference = object2.getSTR(WSSConstants.KEY_IDENTIFIER_QNAME, string2, securityToken);
                }
                object5 = DOMUtils.generateId("encKey");
                EncryptedKeyToken encryptedKeyToken = new EncryptedKeyToken(key, (String)object5);
                wSSecurityContext.addSecurityToken(encryptedKeyToken);
                KeyProvider keyProvider = object2.getKeyProvider(securityToken, wSSecurityContext.getMessageContext());
                if (keyProvider != null) {
                    wSSecurityContext.addKeyProvider(keyProvider);
                }
                KeySelector keySelector = wSSecurityContext.getKeySelector();
                EncryptionMethod encryptionMethod = (EncryptionMethod)contextHandler.getValue("weblogic.wsee.ek.keywrap_method");
                Key key2 = EncryptedKeyUtils.getKey(keySelector, keyProvider, encryptionMethod);
                KeyInfo keyInfo = EncryptedKeyUtils.getKeyInfo(wSSecurityContext, securityTokenReference);
                TBEKey tBEKey = new TBEKey(key);
                EncryptedKey encryptedKey = wSSecurityContext.getEncryptionFactory().newEncryptedKey(tBEKey, encryptionMethod, keyInfo, null, new ArrayList(), (String)object5, null, null, null);
                DOMEncryptContext dOMEncryptContext = new DOMEncryptContext(key2);
                encryptedKeyToken.setDOMEncryptContext(dOMEncryptContext);
                try {
                    encryptedKeyToken.setEncryptedKey(encryptedKey);
                }
                catch (XMLEncryptionException xMLEncryptionException) {
                    // empty catch block
                }
                return encryptedKeyToken;
            }
            return this.getSecurityToken(string, null, Purpose.ENCRYPT, contextHandler);
        }
        catch (ClassCastException classCastException) {
            throw new WSSecurityException("EncryptedKeyTokenHandler does not know how to handle the class of: " + object);
        }
    }

    public SecurityToken getSecurityToken(String string, String string2, Purpose purpose, ContextHandler contextHandler) throws WSSecurityException {
        if ("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKeySHA1".equals(string) || "http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey".equals(string)) {
            WSSecurityInfo wSSecurityInfo = (WSSecurityInfo)contextHandler.getValue("com.bea.contextelement.xml.SecurityInfo");
            List list = wSSecurityInfo.getSecurityTokens("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
            if (list.size() == 1) {
                return (SecurityToken)list.get(0);
            }
            if (list.size() > 1) {
                throw new WSSecurityException("Failed to get EncryptedKey token, more than one in context.");
            }
        }
        return null;
    }

    public SecurityTokenReference getSTR(QName qName, String string, SecurityToken securityToken) throws WSSecurityException {
        return new EncryptedKeySTR(qName, (EncryptedKeyToken)securityToken);
    }

    public QName[] getQNames() {
        return new QName[0];
    }

    public String[] getValueTypes() {
        return WSS11Constants.ENCRYPTED_KEY_VALUE_TYPES;
    }

    public SecurityToken newSecurityToken(Node node) throws weblogic.xml.crypto.api.MarshalException {
        return null;
    }

    public SecurityTokenReference newSecurityTokenReference(Node node) throws MarshalException {
        EncryptedKeySTR encryptedKeySTR = new EncryptedKeySTR();
        encryptedKeySTR.unmarshal(node);
        return encryptedKeySTR;
    }

    public KeyProvider getKeyProvider(SecurityToken securityToken, MessageContext messageContext) {
        KeyProvider keyProvider = null;
        if (securityToken instanceof EncryptedKeyToken) {
            keyProvider = ((EncryptedKeyToken)securityToken).getKeyProvider();
        }
        if (keyProvider == null && securityToken.getSecretKey() != null) {
            keyProvider = new SecretKeyProvider(securityToken.getSecretKey(), null, null, "#" + securityToken.getId(), securityToken);
        }
        return keyProvider;
    }

    public SecurityToken getSecurityToken(SecurityTokenReference securityTokenReference, MessageContext messageContext) throws WSSecurityException {
        WSSecurityContext wSSecurityContext = WSSecurityContext.getSecurityContext(messageContext);
        List list = wSSecurityContext.getSecurityTokens();
        String string = securityTokenReference.getReferenceURI();
        if (string != null) {
            return this.getTokenByURI(string, list);
        }
        byte[] byArray = securityTokenReference.getKeyIdentifier().getIdentifier();
        if (byArray != null) {
            return this.getTokenByKeyId(byArray, list);
        }
        throw new WSSecurityException("Failed to resolve EncryptedKey STR.", WSSConstants.FAILURE_TOKEN_UNAVAILABLE);
    }

    private SecurityToken getTokenByKeyId(byte[] byArray, List list) throws WSSecurityException {
        for (SecurityToken securityToken : list) {
            try {
                if (!(securityToken instanceof EncryptedKeyToken)) continue;
                for (byte[] byArray2 : ((EncryptedKeyToken)securityToken).getKeyIdentifiers()) {
                    if (!Arrays.equals(byArray, byArray2)) continue;
                    return securityToken;
                }
            }
            catch (XMLEncryptionException xMLEncryptionException) {
                throw new WSSecurityException("Failed to retrieve token for key identifier " + byArray, WSSConstants.FAILURE_TOKEN_UNAVAILABLE);
            }
        }
        throw new WSSecurityException("Failed to retrieve token for key identifier " + byArray, WSSConstants.FAILURE_TOKEN_UNAVAILABLE);
    }

    public SecurityTokenValidateResult validateUnmarshalled(SecurityToken securityToken, MessageContext messageContext) throws WSSecurityException {
        return TRUE;
    }

    public SecurityTokenValidateResult validateProcessed(SecurityToken securityToken, MessageContext messageContext) {
        return TRUE;
    }

    public boolean matches(SecurityToken securityToken, String string, String string2, ContextHandler contextHandler, Purpose purpose) {
        return string.equals(securityToken.getValueType());
    }

    public Subject getSubject(SecurityToken securityToken, MessageContext messageContext) throws WSSecurityException {
        return null;
    }

    private SecurityToken getTokenByURI(String string, List list) throws WSSecurityException {
        String string2 = string.substring(1);
        for (SecurityToken securityToken : list) {
            if (!(securityToken instanceof EncryptedKeyToken) || !string2.equals(securityToken.getId())) continue;
            return securityToken;
        }
        throw new WSSecurityException("Failed to retrieve token for reference URI " + string, WSSConstants.FAILURE_TOKEN_UNAVAILABLE);
    }
}

