/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.dom;

import java.util.Iterator;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import weblogic.utils.collections.Iterators;
import weblogic.xml.dom.AttributeReference;
import weblogic.xml.dom.ElementNode;

public final class AttributeMap
implements NamedNodeMap {
    private Element owner;
    private int length;
    private String[] data;
    private Attr[] attData;
    private static final int WIDTH = 4;
    private static final int LOCAL_NAME = 0;
    private static final int PREFIX = 1;
    private static final int NAMESPACE_URI = 2;
    private static final int VALUE = 3;
    private int[] attributes = new int[1];
    private int[] namespaces = new int[1];
    private int numAttr = 0;
    private int numNS = 0;
    private boolean dirty = true;

    public AttributeMap() {
        this.length = 0;
        this.data = new String[0];
        this.attData = new Attr[0];
    }

    public AttributeMap(int n) {
        this.length = n;
        this.data = new String[this.length * 4];
        this.attData = new Attr[this.length];
    }

    public Element getOwner() {
        return this.owner;
    }

    public void setOwner(Element element) {
        this.owner = element;
    }

    public int length() {
        return this.length;
    }

    public String getValue(String string) {
        if (string == null) {
            throw new IllegalArgumentException("localName may not be null");
        }
        for (int i = 0; i < this.length; ++i) {
            if (!string.equals(this.getLocalName(i))) continue;
            return this.getValue(i);
        }
        return null;
    }

    public String getValue(String string, String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("localName may not be null");
        }
        if (string == null) {
            return this.getValue(string2);
        }
        for (int i = 0; i < this.length; ++i) {
            if (!string2.equals(this.getLocalName(i)) || !string.equals(this.getNamespaceURI(i))) continue;
            return this.getValue(i);
        }
        return null;
    }

    public void setLocalName(int n, String string) {
        this.dirty = true;
        this.data[n * 4 + 0] = string;
    }

    public String getLocalName(int n) {
        return this.data[n * 4 + 0];
    }

    public void setPrefix(int n, String string) {
        this.dirty = true;
        this.data[n * 4 + 1] = string;
    }

    public String getPrefix(int n) {
        return this.data[n * 4 + 1];
    }

    public void setNamespaceURI(int n, String string) {
        this.dirty = true;
        this.data[n * 4 + 2] = string;
    }

    public String getNamespaceURI(int n) {
        return this.data[n * 4 + 2];
    }

    public void setValue(int n, String string) {
        this.data[n * 4 + 3] = string;
    }

    public String getValue(int n) {
        return this.data[n * 4 + 3];
    }

    public int addAttribute(String string, String string2, String string3, String string4) {
        this.ensureCapacity(this.length + 1);
        this.setAttribute(this.length, string, string2, string3, string4);
        ++this.length;
        return this.length - 1;
    }

    public void setAttribute(int n, String string, String string2, String string3, String string4) {
        this.setNamespaceURI(n, string);
        this.setLocalName(n, string2);
        this.setPrefix(n, string3);
        this.setValue(n, string4);
        this.dirty = true;
    }

    public int getAttributeIndex(String string) {
        for (int i = 0; i < this.length; ++i) {
            if (!string.equals(this.getLocalName(i))) continue;
            return i;
        }
        return -1;
    }

    public int getNamespaceIndex(String string) {
        if (string == null) {
            return -1;
        }
        return this.getAttributeIndex(ElementNode.XMLNS_URI, string);
    }

    public int getAttributeIndexByPrefix(String string, String string2) {
        if (string == null) {
            return this.getAttributeIndex(string2);
        }
        for (int i = 0; i < this.length; ++i) {
            if (!string2.equals(this.getLocalName(i)) || !string.equals(this.getPrefix(i))) continue;
            return i;
        }
        return -1;
    }

    public int getAttributeIndex(String string, String string2) {
        if (string == null) {
            return this.getAttributeIndex(string2);
        }
        for (int i = 0; i < this.length; ++i) {
            if (!string2.equals(this.getLocalName(i)) || !string.equals(this.getNamespaceURI(i))) continue;
            return i;
        }
        return -1;
    }

    public Attr getAttribute(int n) {
        if (this.attData[n] == null) {
            this.attData[n] = new AttributeReference(this, n);
        }
        return this.attData[n];
    }

    public void removeAttribute(int n) {
        if (n < this.length - 1) {
            System.arraycopy(this.data, (n + 1) * 4, this.data, n * 4, (this.length - n - 1) * 4);
            System.arraycopy(this.attData, n + 1, this.attData, n, this.length - n - 1);
        }
        this.attData[this.length - 1] = null;
        n = (this.length - 1) * 4;
        this.data[n++] = null;
        this.data[n++] = null;
        this.data[n++] = null;
        this.data[n] = null;
        --this.length;
    }

    public void clear() {
        if (this.data != null) {
            for (int i = 0; i < this.length * 4; ++i) {
                this.data[i] = null;
                this.attData[i] = null;
            }
        }
        this.length = 0;
    }

    private void ensureCapacity(int n) {
        if (this.attData.length >= n) {
            return;
        }
        int n2 = this.attData.length;
        while (n2 < n) {
            n2 = n2 * 2 + 1;
        }
        String[] stringArray = new String[n2 * 4];
        Attr[] attrArray = new Attr[n2];
        if (this.length > 0) {
            System.arraycopy(this.data, 0, stringArray, 0, this.length * 4);
            System.arraycopy(this.attData, 0, attrArray, 0, this.length);
        }
        this.data = stringArray;
        this.attData = attrArray;
    }

    public int getLength() {
        return this.length;
    }

    public Node getNamedItem(String string) {
        int n = this.getAttributeIndex(string);
        if (n == -1) {
            return null;
        }
        return this.getAttribute(n);
    }

    public Node getNamedItemNS(String string, String string2) {
        int n = this.getAttributeIndex(string, string2);
        if (n == -1) {
            return null;
        }
        return this.getAttribute(n);
    }

    public Node item(int n) {
        return this.getAttribute(n);
    }

    public Node removeNamedItem(String string) {
        int n = this.getAttributeIndex(string);
        if (n == -1) {
            return null;
        }
        Attr attr = (Attr)this.getAttribute(n).cloneNode(false);
        this.removeAttribute(n);
        return attr;
    }

    public Node removeNamedItemNS(String string, String string2) {
        int n = this.getAttributeIndex(string, string2);
        if (n == -1) {
            return null;
        }
        Attr attr = (Attr)this.getAttribute(n).cloneNode(false);
        this.removeAttribute(n);
        return attr;
    }

    public Node setNamedItem(Node node) {
        AttributeReference attributeReference = (AttributeReference)this.getNamedItemNS(node.getNamespaceURI(), node.getLocalName());
        Attr attr = (Attr)node;
        if (attributeReference == null) {
            int n = this.addAttribute(attr.getNamespaceURI(), attr.getLocalName(), attr.getPrefix(), attr.getValue());
            return this.getAttribute(n);
        }
        this.setAttribute(attributeReference.getIndex(), attr.getNamespaceURI(), attr.getLocalName(), attr.getPrefix(), attr.getValue());
        return attributeReference;
    }

    public Node setNamedItemNS(Node node) {
        return this.setNamedItem(node);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.length > 0) {
            stringBuffer.append(" ");
        }
        for (int i = 0; i < this.length; ++i) {
            String string = this.getNamespaceURI(i);
            String string2 = this.getPrefix(i);
            if (string != null) {
                stringBuffer.append("['" + this.getNamespaceURI(i) + "']:");
            }
            if (string2 != null) {
                stringBuffer.append(this.getPrefix(i) + ":");
            }
            stringBuffer.append(this.getLocalName(i) + "='" + this.getValue(i) + "' ");
        }
        return stringBuffer.toString();
    }

    private void setAttributeCapacity(int n) {
        this.numAttr = 0;
        if (n < this.attributes.length) {
            return;
        }
        this.attributes = new int[n];
    }

    private void setNamespaceCapacity(int n) {
        this.numNS = 0;
        if (n < this.namespaces.length) {
            return;
        }
        this.namespaces = new int[n];
    }

    protected void initializeAttributesAndNamespaces() {
        this.setAttributeCapacity(this.getLength());
        this.setNamespaceCapacity(this.getLength());
        for (int i = 0; i < this.getLength(); ++i) {
            if ("xmlns".equals(this.getPrefix(i))) {
                this.addNamespace(i);
                continue;
            }
            if ("xmlns".equals(this.getLocalName(i))) {
                this.addNamespace(i);
                continue;
            }
            this.addAttribute(i);
        }
        this.dirty = false;
    }

    private void addNamespace(int n) {
        this.namespaces[this.numNS] = n;
        ++this.numNS;
    }

    private void addAttribute(int n) {
        this.attributes[this.numAttr] = n;
        ++this.numAttr;
    }

    public Iterator getNamespacePrefixes() {
        if (this.dirty) {
            this.initializeAttributesAndNamespaces();
        }
        if (this.numNS == 0) {
            return Iterators.EMPTY_ITERATOR;
        }
        return new PrefixIterator(this, this.namespaces, this.numNS);
    }

    public Iterator getAttributeNames() {
        if (this.dirty) {
            this.initializeAttributesAndNamespaces();
        }
        if (this.numAttr == 0) {
            return Iterators.EMPTY_ITERATOR;
        }
        return new NameIterator(this, this.attributes, this.numAttr);
    }

    public static void main(String[] stringArray) throws Exception {
        AttributeMap attributeMap = new AttributeMap(5);
        attributeMap.setAttribute(0, "a_uri", "a", "pa", "apple");
        attributeMap.setAttribute(1, "b_uri", "b", "pb", "banana");
        attributeMap.setAttribute(2, "c_uri", "c", "pc", "orange");
        attributeMap.setAttribute(3, "d_uri", "d", "pd", "dunce");
        attributeMap.setAttribute(4, "e_uri", "e", "pd", "eat");
        System.out.println(attributeMap);
        int n = attributeMap.length();
        for (int i = 0; i < n; ++i) {
            attributeMap.removeAttribute(0);
            System.out.println("--------------" + attributeMap.length() + "-----------");
            System.out.println(attributeMap);
        }
        attributeMap.addAttribute("a_uri", "a", "pa", "apple");
        attributeMap.addAttribute("b_uri", "b", "pb", "banana");
        attributeMap.addAttribute("c_uri", "c", "pc", "orange");
        attributeMap.addAttribute("d_uri", "d", "pd", "dunce");
        attributeMap.addAttribute("e_uri", "e", "pd", "eat");
        System.out.println(attributeMap);
    }

    public class PrefixIterator
    implements Iterator {
        private AttributeMap map;
        private int[] data;
        private int size;
        private int current;

        public PrefixIterator(AttributeMap attributeMap2, int[] nArray, int n) {
            this.map = attributeMap2;
            this.data = nArray;
            this.size = n;
            this.current = 0;
        }

        public Object next() {
            String string = this.map.getPrefix(this.data[this.current]);
            ++this.current;
            return string;
        }

        public void remove() {
            throw new UnsupportedOperationException("remove() not supported");
        }

        public boolean hasNext() {
            return this.current < this.size;
        }
    }

    public class NameIterator
    implements Iterator {
        private AttributeMap map;
        private int[] data;
        private int size;
        private int current;

        public NameIterator(AttributeMap attributeMap2, int[] nArray, int n) {
            this.map = attributeMap2;
            this.data = nArray;
            this.size = n;
            this.current = 0;
        }

        public Object next() {
            Node node = this.map.item(this.data[this.current]);
            ++this.current;
            return node;
        }

        public void remove() {
            throw new UnsupportedOperationException("remove() not supported");
        }

        public boolean hasNext() {
            return this.current < this.size;
        }
    }
}

