/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.dom;

import javax.xml.soap.Name;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;
import org.w3c.dom.UserDataHandler;
import weblogic.xml.dom.AttributeImpl;
import weblogic.xml.dom.AttributeMap;
import weblogic.xml.dom.Util;

public final class AttributeReference
implements Name,
Attr,
Cloneable {
    private AttributeMap atts;
    private int index;

    public AttributeReference(AttributeMap attributeMap, int n) {
        this.atts = attributeMap;
        this.index = n;
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.getNodeName();
    }

    public Element getOwnerElement() {
        return this.atts.getOwner();
    }

    public boolean getSpecified() {
        return true;
    }

    public String getValue() {
        return this.getNodeValue();
    }

    public void setValue(String string) {
        this.setNodeValue(string);
    }

    public String getURI() {
        return this.getNamespaceURI();
    }

    public String getQualifiedName() {
        return this.getPrefix() == null ? this.getLocalName() : this.getPrefix() + ":" + this.getLocalName();
    }

    public String getNodeName() {
        String string = this.atts.getPrefix(this.index);
        String string2 = this.atts.getLocalName(this.index);
        if (string == null || "".equals(string)) {
            return string2;
        }
        return string + ":" + string2;
    }

    public String getNodeValue() throws DOMException {
        return this.atts.getValue(this.index);
    }

    public void setNodeValue(String string) throws DOMException {
        this.atts.setValue(this.index, string);
    }

    public short getNodeType() {
        return 2;
    }

    public Node getParentNode() {
        return null;
    }

    public NodeList getChildNodes() {
        return Util.EMPTY_NODELIST;
    }

    public Node getFirstChild() {
        return null;
    }

    public Node getLastChild() {
        return null;
    }

    public Node getPreviousSibling() {
        return null;
    }

    public Node getNextSibling() {
        return null;
    }

    public NamedNodeMap getAttributes() {
        return null;
    }

    public Document getOwnerDocument() {
        return null;
    }

    public Node insertBefore(Node node, Node node2) throws DOMException {
        return null;
    }

    public Node replaceChild(Node node, Node node2) throws DOMException {
        return null;
    }

    public Node removeChild(Node node) throws DOMException {
        return null;
    }

    public Node appendChild(Node node) throws DOMException {
        return null;
    }

    public boolean hasChildNodes() {
        return false;
    }

    public void removeChildren() {
    }

    public Node cloneNode(boolean bl) {
        return new AttributeImpl(this.getOwnerElement(), this.getNamespaceURI(), this.getPrefix(), this.getLocalName(), this.getValue());
    }

    public void normalize() {
    }

    public boolean isSupported(String string, String string2) {
        return false;
    }

    public String getNamespaceURI() {
        return this.atts.getNamespaceURI(this.index);
    }

    public String getPrefix() {
        return this.atts.getPrefix(this.index);
    }

    public void setPrefix(String string) throws DOMException {
        this.atts.setPrefix(this.index, string);
    }

    public String getLocalName() {
        return this.atts.getLocalName(this.index);
    }

    public boolean hasAttributes() {
        return false;
    }

    public String toString() {
        String string = this.getPrefix();
        String string2 = this.getLocalName();
        String string3 = this.getNamespaceURI();
        String string4 = this.getValue();
        if (string4 == null) {
            string4 = "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (string3 != null) {
            stringBuffer.append("['" + string3 + "']");
        }
        if (string != null) {
            stringBuffer.append(string + ":");
        }
        stringBuffer.append(string2 + "='" + string4 + "' ");
        return stringBuffer.toString();
    }

    public boolean isId() throws DOMException {
        throw new UnsupportedOperationException("This class does not support JDK1.5");
    }

    public TypeInfo getSchemaTypeInfo() throws DOMException {
        throw new UnsupportedOperationException("This class does not support JDK1.5");
    }

    public Object getUserData(String string) throws DOMException {
        throw new UnsupportedOperationException("This class does not support JDK1.5");
    }

    public Object setUserData(String string, Object object, UserDataHandler userDataHandler) throws DOMException {
        throw new UnsupportedOperationException("This class does not support JDK1.5");
    }

    public Object getFeature(String string, String string2) throws DOMException {
        throw new UnsupportedOperationException("This class does not support JDK1.5");
    }

    public boolean isEqualNode(Node node) throws DOMException {
        throw new UnsupportedOperationException("This class does not support JDK1.5");
    }

    public String lookupNamespaceURI(String string) throws DOMException {
        throw new UnsupportedOperationException("This class does not support JDK1.5");
    }

    public boolean isDefaultNamespace(String string) throws DOMException {
        throw new UnsupportedOperationException("This class does not support JDK1.5");
    }

    public String lookupPrefix(String string) throws DOMException {
        throw new UnsupportedOperationException("This class does not support JDK1.5");
    }

    public boolean isSameNode(Node node) throws DOMException {
        throw new UnsupportedOperationException("This class does not support JDK1.5");
    }

    public void setTextContent(String string) throws DOMException {
        throw new UnsupportedOperationException("This class does not support JDK1.5");
    }

    public String getTextContent() throws DOMException {
        throw new UnsupportedOperationException("This class does not support JDK1.5");
    }

    public short compareDocumentPosition(Node node) throws DOMException {
        throw new UnsupportedOperationException("This class does not support JDK1.5");
    }

    public String getBaseURI() throws DOMException {
        throw new UnsupportedOperationException("This class does not support JDK1.5");
    }
}

