/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.dom;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import weblogic.xml.dom.AttributeMap;
import weblogic.xml.dom.ElementNode;
import weblogic.xml.dom.NodeImpl;
import weblogic.xml.dom.NodeIterator;
import weblogic.xml.dom.PINode;
import weblogic.xml.dom.TextNode;
import weblogic.xml.dom.XMLStreamIterator;

public class Builder {
    public static void nextTag(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        while (xMLStreamReader.hasNext()) {
            if (xMLStreamReader.isStartElement() || xMLStreamReader.isEndElement()) {
                return;
            }
            xMLStreamReader.next();
        }
    }

    public NodeImpl create(File file) throws XMLStreamException, DOMException, IOException {
        XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
        XMLStreamReader xMLStreamReader = xMLInputFactory.createXMLStreamReader(new FileInputStream(file));
        Builder.nextTag(xMLStreamReader);
        return Builder.read(new ElementNode(), xMLStreamReader);
    }

    public void readText(ElementNode elementNode, XMLStreamReader xMLStreamReader) throws XMLStreamException, DOMException {
        while (xMLStreamReader.getEventType() == 4 || xMLStreamReader.getEventType() == 5) {
            switch (xMLStreamReader.getEventType()) {
                case 4: {
                    elementNode.appendChild(new TextNode(xMLStreamReader.getText()));
                    break;
                }
                case 5: {
                    elementNode.appendChild(new TextNode(xMLStreamReader.getText()).asComment());
                }
            }
            xMLStreamReader.next();
        }
    }

    public static ElementNode read(ElementNode elementNode, XMLStreamReader xMLStreamReader) throws XMLStreamException, DOMException {
        if (xMLStreamReader.getEventType() != 1) {
            throw new XMLStreamException("Expected a Start Element!");
        }
        Builder.nextTag(xMLStreamReader);
        elementNode.setPrefix(xMLStreamReader.getPrefix());
        elementNode.setNamespaceURI(xMLStreamReader.getNamespaceURI());
        elementNode.setLocalName(xMLStreamReader.getLocalName());
        int n = xMLStreamReader.getAttributeCount();
        int n2 = xMLStreamReader.getNamespaceCount();
        int n3 = n + n2;
        if (n3 > 0) {
            int n4;
            AttributeMap attributeMap = new AttributeMap(n3);
            attributeMap.setOwner(elementNode);
            elementNode.setAttributes(attributeMap);
            if (n2 > 0) {
                for (n4 = 0; n4 < n2; ++n4) {
                    String string = xMLStreamReader.getNamespacePrefix(n4);
                    if (string == null) {
                        attributeMap.setAttribute(n4, ElementNode.XMLNS_URI, ElementNode.XMLNS, null, xMLStreamReader.getNamespaceURI(n4));
                        continue;
                    }
                    attributeMap.setAttribute(n4, ElementNode.XMLNS_URI, string, ElementNode.XMLNS, xMLStreamReader.getNamespaceURI(n4));
                }
            }
            if (n > 0) {
                for (n4 = 0; n4 < n; ++n4) {
                    attributeMap.setAttribute(n4 + n2, xMLStreamReader.getAttributeNamespace(n4), xMLStreamReader.getAttributeLocalName(n4), xMLStreamReader.getAttributePrefix(n4), xMLStreamReader.getAttributeValue(n4));
                }
            }
        }
        xMLStreamReader.next();
        while (xMLStreamReader.getEventType() == 1 || xMLStreamReader.getEventType() == 4 || xMLStreamReader.getEventType() == 5 || xMLStreamReader.getEventType() == 3) {
            switch (xMLStreamReader.getEventType()) {
                case 1: {
                    elementNode.appendChild(Builder.read(new ElementNode(), xMLStreamReader));
                    break;
                }
                case 4: {
                    elementNode.appendChild(new TextNode(xMLStreamReader.getText()));
                    xMLStreamReader.next();
                    break;
                }
                case 5: {
                    elementNode.appendChild(new TextNode(xMLStreamReader.getText()).asComment());
                    xMLStreamReader.next();
                    break;
                }
                case 3: {
                    elementNode.appendChild(new PINode(xMLStreamReader.getPITarget(), xMLStreamReader.getPIData()));
                    xMLStreamReader.next();
                }
            }
        }
        if (xMLStreamReader.getEventType() != 2) {
            throw new XMLStreamException("Expected an End Element!");
        }
        xMLStreamReader.next();
        return elementNode;
    }

    public static void main(String[] stringArray) throws Exception {
        Object object;
        Builder builder = new Builder();
        NodeImpl nodeImpl = builder.create(new File(stringArray[0]));
        System.out.println(nodeImpl);
        NodeIterator nodeIterator = nodeImpl.iterator();
        while (nodeIterator.hasNext()) {
            object = nodeIterator.nextNode();
            if (object.getNodeType() == 3 || object.getNodeType() == 8 || object.getNodeType() == 4) {
                System.out.println("[" + object + "]");
                continue;
            }
            System.out.println("[" + object.getLocalName() + "]");
        }
        object = new XMLStreamIterator(nodeImpl);
        while (((XMLStreamIterator)object).hasNext()) {
            Node node = ((XMLStreamIterator)object).nextNode();
            if (node.getNodeType() == 3 || node.getNodeType() == 8 || node.getNodeType() == 4) {
                System.out.println(node);
                continue;
            }
            if (((XMLStreamIterator)object).isOpen()) {
                System.out.println("<" + node.getLocalName() + ">");
                continue;
            }
            System.out.println("</" + node.getLocalName() + ">");
        }
    }
}

