/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.dom;

import java.io.PrintWriter;
import weblogic.xml.dom.DOMProcessingException;

public class ChildCountException
extends DOMProcessingException {
    public static final int MISSING_CHILD = 1;
    public static final int EXTRA_CHILD = 2;
    private static final String[] errorMsgs = new String[]{"missing child", "extra child"};
    private int errorCode;
    private String parentTagName;
    private String childTagName;
    private int childCount;

    public ChildCountException(int n, String string, String string2, int n2) {
        this.errorCode = n;
        this.parentTagName = string;
        this.childTagName = string2;
        this.childCount = n2;
    }

    public void writeErrorCondition(PrintWriter printWriter) {
        printWriter.println("[Begin ChildCountException:");
        printWriter.println("\terrorCode: " + this.errorCode);
        printWriter.println("\tparentTagName: " + this.parentTagName);
        printWriter.println("\tchildTagName: " + this.childTagName);
        printWriter.println("\tchildCount: " + this.childCount);
        printWriter.println("End ChildCountException]");
    }

    public String toString() {
        return super.toString() + ": " + errorMsgs[this.errorCode - 1] + " " + this.childTagName + " in " + this.parentTagName;
    }
}

