/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.dom;

import java.io.File;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import weblogic.xml.babel.reader.XmlChars;
import weblogic.xml.dom.Builder;
import weblogic.xml.dom.ElementNode;
import weblogic.xml.dom.NamespaceContextNode;
import weblogic.xml.dom.NodeImpl;
import weblogic.xml.dom.XMLStreamIterator;
import weblogic.xml.stax.XMLStreamReaderBase;

public class DOMStreamReader
extends XMLStreamReaderBase
implements XMLStreamReader {
    private int[] attributes = new int[1];
    private int[] namespaces = new int[1];
    private int numAttr;
    private int numNS;
    private NamedNodeMap attributeNodes;
    private final XMLStreamIterator nodeIterator;
    private Node current = null;

    public DOMStreamReader(Node node) throws XMLStreamException {
        this.nodeIterator = new XMLStreamIterator(node);
        this.advance();
    }

    public Node current() {
        return this.current;
    }

    protected boolean atEnd() {
        return this.current() == null;
    }

    protected void advance() throws XMLStreamException {
        if (!this.nodeIterator.hasNext()) {
            this.eventType = 8;
            this.current = null;
        } else {
            this.current = (Node)this.nodeIterator.next();
            this.setTextCache(null);
            this.setArrayCache(null);
            this.eventType = this.convert(this.current().getNodeType());
            if (this.eventType == -1) {
                throw new XMLStreamException("Unable to advance the cursor unknown node type" + this.current());
            }
            if (this.isStartElement()) {
                this.initializeAttributesAndNamespaces();
            }
            if (this.isEndElement()) {
                this.initializeAttributesAndNamespaces();
            }
        }
    }

    protected int convert(int n) {
        switch (n) {
            case 1: {
                if (this.nodeIterator.isOpen()) {
                    return 1;
                }
                return 2;
            }
            case 7: {
                return 3;
            }
            case 4: {
                return 12;
            }
            case 8: {
                return 5;
            }
            case 3: {
                return 4;
            }
            case 9: {
                if (this.nodeIterator.isOpen()) {
                    return 7;
                }
                return 8;
            }
        }
        return -1;
    }

    public String getPrefix() {
        return this.current().getPrefix();
    }

    public String getNamespaceURI() {
        return DOMStreamReader.checkNull((String)this.current().getNamespaceURI());
    }

    public String getLocalName() {
        return this.current().getLocalName();
    }

    private void addNamespace(int n) {
        this.namespaces[this.numNS] = n;
        ++this.numNS;
    }

    private void addAttribute(int n) {
        this.attributes[this.numAttr] = n;
        ++this.numAttr;
    }

    private void setAttributeCapacity(int n) {
        this.numAttr = 0;
        if (n < this.attributes.length) {
            return;
        }
        this.attributes = new int[n];
    }

    private void setNamespaceCapacity(int n) {
        this.numNS = 0;
        if (n < this.namespaces.length) {
            return;
        }
        this.namespaces = new int[n];
    }

    protected void initializeAttributesAndNamespaces() {
        int n = this.updateAttributeNodes();
        this.setAttributeCapacity(n);
        this.setNamespaceCapacity(n);
        for (int i = 0; i < n; ++i) {
            Attr attr = (Attr)this.attributeNodes.item(i);
            if ("xmlns".equals(attr.getPrefix())) {
                this.addNamespace(i);
                continue;
            }
            if ("xmlns".equals(attr.getLocalName())) {
                this.addNamespace(i);
                continue;
            }
            this.addAttribute(i);
        }
    }

    private int updateAttributeNodes() {
        int n;
        if (this.current().hasAttributes()) {
            this.attributeNodes = this.current().getAttributes();
            n = this.attributeNodes.getLength();
        } else {
            this.attributeNodes = null;
            n = 0;
        }
        return n;
    }

    protected void initializeOutOfScopeNamespaces() {
        int n = this.updateAttributeNodes();
        this.setNamespaceCapacity(n);
        for (int i = 0; i < n; ++i) {
            Attr attr = (Attr)this.attributeNodes.item(i);
            if ("xmlns".equals(attr.getPrefix())) {
                this.addNamespace(i);
                continue;
            }
            if (!"xmlns".equals(attr.getLocalName())) continue;
            this.addNamespace(i);
        }
    }

    public int getAttributeCount() {
        if (this.isStartElement()) {
            return this.numAttr;
        }
        throw new IllegalStateException("Unable to access attributes on a non START_ELEMENT");
    }

    public String getAttributeValue(String string, String string2) {
        for (int i = 0; i < this.getAttributeCount(); ++i) {
            Attr attr = this.getAttrInternal(i);
            if (!string2.equals(attr.getLocalName())) continue;
            if (string == null) {
                return attr.getValue();
            }
            if (!string.equals(attr.getNamespaceURI())) continue;
            return attr.getValue();
        }
        return null;
    }

    private Attr getAttrInternal(int n) {
        if (this.attributeNodes == null) {
            return null;
        }
        return (Attr)this.attributeNodes.item(this.attributes[n]);
    }

    private Attr getNSInternal(int n) {
        if (this.attributeNodes == null) {
            return null;
        }
        return (Attr)this.attributeNodes.item(this.namespaces[n]);
    }

    public String getAttributeNamespace(int n) {
        this.checkStartElement();
        Attr attr = this.getAttrInternal(n);
        if (attr == null) {
            return null;
        }
        return attr.getNamespaceURI();
    }

    public String getAttributeLocalName(int n) {
        this.checkStartElement();
        Attr attr = this.getAttrInternal(n);
        if (attr == null) {
            return null;
        }
        return attr.getLocalName();
    }

    public String getAttributePrefix(int n) {
        this.checkStartElement();
        Attr attr = this.getAttrInternal(n);
        if (attr == null) {
            return null;
        }
        return attr.getPrefix();
    }

    public String getAttributeValue(int n) {
        this.checkStartElement();
        Attr attr = this.getAttrInternal(n);
        if (attr == null) {
            return null;
        }
        return attr.getValue();
    }

    private Element findElement() {
        if (this.current().getNodeType() == 1) {
            return (Element)this.current();
        }
        for (Node node = this.current().getParentNode(); node != null; node = node.getParentNode()) {
            if (node.getNodeType() != 1) continue;
            return (Element)node;
        }
        return null;
    }

    public NamespaceContext getNamespaceContext() {
        return new NamespaceContextNode(this.findElement());
    }

    public int getNamespaceCount() {
        this.checkStartOrEnd();
        return this.numNS;
    }

    public String getNamespaceURI(String string) {
        this.checkStartOrEnd();
        Element element = (Element)this.current();
        String string2 = null;
        while (string2 == null && element != null && element.getNodeType() == 1) {
            string2 = element.getAttributeNS(ElementNode.XMLNS_URI, string);
            if (string2 != null) {
                return string2;
            }
            Node node = element.getParentNode();
            if (node.getNodeType() != 1) {
                return null;
            }
            element = (Element)node;
        }
        return string2;
    }

    public String getNamespacePrefix(int n) {
        this.checkStartOrEnd();
        Attr attr = this.getNSInternal(n);
        if (attr == null) {
            return null;
        }
        return attr.getLocalName();
    }

    public String getNamespaceURI(int n) {
        this.checkStartOrEnd();
        Attr attr = this.getNSInternal(n);
        if (attr == null) {
            return null;
        }
        return DOMStreamReader.checkNull((String)attr.getValue());
    }

    public String getText() {
        if (this.getTextCache() == null) {
            if (this.eventType != 12 && this.eventType != 5 && this.eventType != 4) {
                throw new IllegalStateException("Attempt to access text from an illegal state");
            }
            this.setTextCache(this.current().getNodeValue());
        }
        return this.getTextCache();
    }

    public boolean isWhiteSpace() {
        char[] cArray = this.getTextCharacters();
        for (int i = 0; i < cArray.length; ++i) {
            if (XmlChars.isSpace((char)cArray[i])) continue;
            return false;
        }
        return true;
    }

    public char[] getTextCharacters() {
        if (this.getArrayCache() == null) {
            if (this.eventType != 12 && this.eventType != 5 && this.eventType != 4) {
                throw new IllegalStateException("Attempt to access text from an illegal state");
            }
            this.setArrayCache(this.current().getNodeValue().toCharArray());
        }
        return this.getArrayCache();
    }

    public int getLineNumber() {
        return -1;
    }

    public int getColumnNumber() {
        return -1;
    }

    public static void main(String[] stringArray) throws Exception {
        Builder builder = new Builder();
        NodeImpl nodeImpl = builder.create(new File(stringArray[0]));
        DOMStreamReader dOMStreamReader = new DOMStreamReader(nodeImpl);
        while (dOMStreamReader.hasNext()) {
            System.out.println(dOMStreamReader.toString());
            dOMStreamReader.next();
        }
    }
}

