/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.dom;

import com.bea.xbean.common.InvalidLexicalValueException;
import com.bea.xbean.common.XmlWhitespace;
import com.bea.xbean.richParser.XMLStreamReaderExt;
import com.bea.xbean.util.Base64;
import com.bea.xbean.util.HexBin;
import com.bea.xbean.util.XsTypeConverter;
import com.bea.xml.GDate;
import com.bea.xml.GDateBuilder;
import com.bea.xml.GDuration;
import com.bea.xml.XmlCalendar;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.w3c.dom.Node;
import weblogic.xml.dom.DOMStreamReader;
import weblogic.xml.util.WhitespaceUtils;

public class DOMStreamReaderExt
extends DOMStreamReader
implements XMLStreamReaderExt {
    private final List contents = new ArrayList();
    private String _defaultValue;

    public DOMStreamReaderExt(Node node) throws XMLStreamException {
        super(node);
    }

    public String getStringValue() throws XMLStreamException {
        return ((Object)this.getCurrentPreserveCharSeq()).toString();
    }

    public String getStringValue(int n) throws XMLStreamException {
        return XmlWhitespace.collapse((String)((Object)this.getCurrentPreserveCharSeq()).toString(), (int)n);
    }

    public boolean getBooleanValue() throws XMLStreamException, InvalidLexicalValueException {
        return XsTypeConverter.lexBoolean((CharSequence)this.getCurrentTrimCharSeq());
    }

    public byte getByteValue() throws XMLStreamException, InvalidLexicalValueException {
        return XsTypeConverter.lexByte((CharSequence)this.getCurrentTrimCharSeq());
    }

    public short getShortValue() throws XMLStreamException, InvalidLexicalValueException {
        return XsTypeConverter.lexShort((CharSequence)this.getCurrentTrimCharSeq());
    }

    public int getIntValue() throws XMLStreamException, InvalidLexicalValueException {
        return XsTypeConverter.lexInt((CharSequence)this.getCurrentTrimCharSeq());
    }

    public long getLongValue() throws XMLStreamException {
        return XsTypeConverter.lexLong((CharSequence)this.getCurrentTrimCharSeq());
    }

    public BigInteger getBigIntegerValue() throws XMLStreamException {
        CharSequence charSequence = this.getCurrentTrimCharSeq();
        if ("".equals(((Object)charSequence).toString())) {
            return null;
        }
        return XsTypeConverter.lexInteger((CharSequence)charSequence);
    }

    public BigDecimal getBigDecimalValue() throws XMLStreamException {
        CharSequence charSequence = this.getCurrentTrimCharSeq();
        if ("".equals(((Object)charSequence).toString())) {
            return null;
        }
        return XsTypeConverter.lexDecimal((CharSequence)charSequence);
    }

    public float getFloatValue() throws XMLStreamException {
        return XsTypeConverter.lexFloat((CharSequence)this.getCurrentTrimCharSeq());
    }

    public double getDoubleValue() throws XMLStreamException {
        return XsTypeConverter.lexDouble((CharSequence)this.getCurrentTrimCharSeq());
    }

    public InputStream getHexBinaryValue() throws XMLStreamException, InvalidLexicalValueException {
        String string = ((Object)this.getCurrentTrimCharSeq()).toString();
        byte[] byArray = HexBin.decode((byte[])string.getBytes());
        if (byArray != null) {
            return new ByteArrayInputStream(byArray);
        }
        throw new InvalidLexicalValueException("invalid hexBinary value");
    }

    public InputStream getBase64Value() throws XMLStreamException, InvalidLexicalValueException {
        String string = ((Object)this.getCurrentTrimCharSeq()).toString();
        byte[] byArray = Base64.decode((byte[])string.getBytes());
        if (byArray != null) {
            return new ByteArrayInputStream(byArray);
        }
        throw new InvalidLexicalValueException("invalid base64Binary value");
    }

    public XmlCalendar getCalendarValue() throws XMLStreamException, InvalidLexicalValueException {
        try {
            CharSequence charSequence = this.getCurrentTrimCharSeq();
            if (charSequence.length() == 0) {
                return null;
            }
            return new GDateBuilder(charSequence).getCalendar();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidLexicalValueException((Throwable)illegalArgumentException);
        }
    }

    public Date getDateValue() throws XMLStreamException, InvalidLexicalValueException {
        try {
            return new GDateBuilder(this.getCurrentTrimCharSeq()).getDate();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidLexicalValueException((Throwable)illegalArgumentException);
        }
    }

    public GDate getGDateValue() throws XMLStreamException, InvalidLexicalValueException {
        try {
            return XsTypeConverter.lexGDate((CharSequence)this.getCurrentTrimCharSeq());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidLexicalValueException((Throwable)illegalArgumentException);
        }
    }

    public GDuration getGDurationValue() throws XMLStreamException, InvalidLexicalValueException {
        try {
            return new GDuration(this.getCurrentTrimCharSeq());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidLexicalValueException((Throwable)illegalArgumentException);
        }
    }

    public QName getQNameValue() throws XMLStreamException, InvalidLexicalValueException {
        try {
            return XsTypeConverter.lexQName((CharSequence)this.getCurrentTrimCharSeq(), (NamespaceContext)this.getNamespaceContext());
        }
        catch (InvalidLexicalValueException invalidLexicalValueException) {
            throw new InvalidLexicalValueException((Throwable)invalidLexicalValueException);
        }
    }

    public String getAttributeStringValue(int n) throws XMLStreamException {
        return this.getAttributeValue(n);
    }

    public String getAttributeStringValue(int n, int n2) throws XMLStreamException {
        return XmlWhitespace.collapse((String)this.getAttributeValue(n), (int)n2);
    }

    public boolean getAttributeBooleanValue(int n) throws XMLStreamException {
        try {
            return XsTypeConverter.lexBoolean((CharSequence)this.getCurrentAttributeTrimCharSeq(n));
        }
        catch (InvalidLexicalValueException invalidLexicalValueException) {
            throw new InvalidLexicalValueException((Throwable)invalidLexicalValueException);
        }
    }

    public byte getAttributeByteValue(int n) throws XMLStreamException {
        try {
            return XsTypeConverter.lexByte((CharSequence)this.getCurrentAttributeTrimCharSeq(n));
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidLexicalValueException((Throwable)numberFormatException);
        }
    }

    public short getAttributeShortValue(int n) throws XMLStreamException {
        try {
            return XsTypeConverter.lexShort((CharSequence)this.getCurrentAttributeTrimCharSeq(n));
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidLexicalValueException((Throwable)numberFormatException);
        }
    }

    public int getAttributeIntValue(int n) throws XMLStreamException {
        try {
            return XsTypeConverter.lexInt((CharSequence)this.getCurrentAttributeTrimCharSeq(n));
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidLexicalValueException((Throwable)numberFormatException);
        }
    }

    public long getAttributeLongValue(int n) throws XMLStreamException {
        try {
            return XsTypeConverter.lexLong((CharSequence)this.getCurrentAttributeTrimCharSeq(n));
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidLexicalValueException((Throwable)numberFormatException);
        }
    }

    public BigInteger getAttributeBigIntegerValue(int n) throws XMLStreamException {
        try {
            return XsTypeConverter.lexInteger((CharSequence)this.getCurrentAttributeTrimCharSeq(n));
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidLexicalValueException((Throwable)numberFormatException);
        }
    }

    public BigDecimal getAttributeBigDecimalValue(int n) throws XMLStreamException {
        try {
            return XsTypeConverter.lexDecimal((CharSequence)this.getCurrentAttributeTrimCharSeq(n));
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidLexicalValueException((Throwable)numberFormatException);
        }
    }

    public float getAttributeFloatValue(int n) throws XMLStreamException {
        try {
            return XsTypeConverter.lexFloat((CharSequence)this.getCurrentAttributeTrimCharSeq(n));
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidLexicalValueException((Throwable)numberFormatException);
        }
    }

    public double getAttributeDoubleValue(int n) throws XMLStreamException {
        try {
            return XsTypeConverter.lexDouble((CharSequence)this.getCurrentAttributeTrimCharSeq(n));
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidLexicalValueException((Throwable)numberFormatException);
        }
    }

    public InputStream getAttributeHexBinaryValue(int n) throws XMLStreamException {
        String string = ((Object)this.getCurrentAttributeTrimCharSeq(n)).toString();
        byte[] byArray = HexBin.decode((byte[])string.getBytes());
        if (byArray != null) {
            return new ByteArrayInputStream(byArray);
        }
        throw new InvalidLexicalValueException("invalid hexBinary value");
    }

    public InputStream getAttributeBase64Value(int n) throws XMLStreamException {
        String string = ((Object)this.getCurrentAttributeTrimCharSeq(n)).toString();
        byte[] byArray = Base64.decode((byte[])string.getBytes());
        if (byArray != null) {
            return new ByteArrayInputStream(byArray);
        }
        throw new InvalidLexicalValueException("invalid base64Binary value");
    }

    public XmlCalendar getAttributeCalendarValue(int n) throws XMLStreamException {
        try {
            return new GDateBuilder(this.getCurrentAttributeTrimCharSeq(n)).getCalendar();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidLexicalValueException((Throwable)illegalArgumentException);
        }
    }

    public Date getAttributeDateValue(int n) throws XMLStreamException {
        try {
            return new GDateBuilder(this.getCurrentAttributeTrimCharSeq(n)).getDate();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidLexicalValueException((Throwable)illegalArgumentException);
        }
    }

    public GDate getAttributeGDateValue(int n) throws XMLStreamException {
        try {
            return new GDate(this.getCurrentAttributeTrimCharSeq(n));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidLexicalValueException((Throwable)illegalArgumentException);
        }
    }

    public GDuration getAttributeGDurationValue(int n) throws XMLStreamException {
        try {
            return new GDuration(this.getCurrentAttributeTrimCharSeq(n));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidLexicalValueException((Throwable)illegalArgumentException);
        }
    }

    public QName getAttributeQNameValue(int n) throws XMLStreamException {
        try {
            return XsTypeConverter.lexQName((CharSequence)this.getCurrentAttributeTrimCharSeq(n), (NamespaceContext)this.getNamespaceContext());
        }
        catch (InvalidLexicalValueException invalidLexicalValueException) {
            throw new InvalidLexicalValueException((Throwable)invalidLexicalValueException);
        }
    }

    public String getAttributeStringValue(String string, String string2) throws XMLStreamException {
        return this.getAttributeValue(string, string2);
    }

    public String getAttributeStringValue(String string, String string2, int n) throws XMLStreamException {
        return XmlWhitespace.collapse((String)this.getAttributeValue(string, string2), (int)n);
    }

    public boolean getAttributeBooleanValue(String string, String string2) throws XMLStreamException {
        return XsTypeConverter.lexBoolean((CharSequence)this.getCurrentAttributeTrimCharSeq(string, string2));
    }

    public byte getAttributeByteValue(String string, String string2) throws XMLStreamException {
        CharSequence charSequence = this.getCurrentAttributeTrimCharSeq(string, string2);
        try {
            return XsTypeConverter.lexByte((CharSequence)charSequence);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidLexicalValueException((Throwable)numberFormatException);
        }
    }

    public short getAttributeShortValue(String string, String string2) throws XMLStreamException {
        CharSequence charSequence = this.getCurrentAttributeTrimCharSeq(string, string2);
        try {
            return XsTypeConverter.lexShort((CharSequence)charSequence);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidLexicalValueException((Throwable)numberFormatException);
        }
    }

    public int getAttributeIntValue(String string, String string2) throws XMLStreamException {
        CharSequence charSequence = this.getCurrentAttributeTrimCharSeq(string, string2);
        try {
            return XsTypeConverter.lexInt((CharSequence)charSequence);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidLexicalValueException((Throwable)numberFormatException);
        }
    }

    public long getAttributeLongValue(String string, String string2) throws XMLStreamException {
        CharSequence charSequence = this.getCurrentAttributeTrimCharSeq(string, string2);
        try {
            return XsTypeConverter.lexLong((CharSequence)charSequence);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidLexicalValueException((Throwable)numberFormatException);
        }
    }

    public BigInteger getAttributeBigIntegerValue(String string, String string2) throws XMLStreamException {
        CharSequence charSequence = this.getCurrentAttributeTrimCharSeq(string, string2);
        try {
            return XsTypeConverter.lexInteger((CharSequence)charSequence);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidLexicalValueException((Throwable)numberFormatException);
        }
    }

    public BigDecimal getAttributeBigDecimalValue(String string, String string2) throws XMLStreamException {
        CharSequence charSequence = this.getCurrentAttributeTrimCharSeq(string, string2);
        try {
            return XsTypeConverter.lexDecimal((CharSequence)charSequence);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidLexicalValueException((Throwable)numberFormatException);
        }
    }

    public float getAttributeFloatValue(String string, String string2) throws XMLStreamException {
        CharSequence charSequence = this.getCurrentAttributeTrimCharSeq(string, string2);
        try {
            return XsTypeConverter.lexFloat((CharSequence)charSequence);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidLexicalValueException((Throwable)numberFormatException);
        }
    }

    public double getAttributeDoubleValue(String string, String string2) throws XMLStreamException {
        CharSequence charSequence = this.getCurrentAttributeTrimCharSeq(string, string2);
        try {
            return XsTypeConverter.lexDouble((CharSequence)charSequence);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidLexicalValueException((Throwable)numberFormatException);
        }
    }

    public InputStream getAttributeHexBinaryValue(String string, String string2) throws XMLStreamException {
        CharSequence charSequence = this.getCurrentAttributeTrimCharSeq(string, string2);
        String string3 = ((Object)charSequence).toString();
        byte[] byArray = HexBin.decode((byte[])string3.getBytes());
        if (byArray != null) {
            return new ByteArrayInputStream(byArray);
        }
        throw new InvalidLexicalValueException("invalid hexBinary value");
    }

    public InputStream getAttributeBase64Value(String string, String string2) throws XMLStreamException {
        CharSequence charSequence = this.getCurrentAttributeTrimCharSeq(string, string2);
        String string3 = ((Object)charSequence).toString();
        byte[] byArray = Base64.decode((byte[])string3.getBytes());
        if (byArray != null) {
            return new ByteArrayInputStream(byArray);
        }
        throw new InvalidLexicalValueException("invalid base64Binary value");
    }

    public XmlCalendar getAttributeCalendarValue(String string, String string2) throws XMLStreamException {
        CharSequence charSequence = this.getCurrentAttributeTrimCharSeq(string, string2);
        try {
            return new GDateBuilder(charSequence).getCalendar();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidLexicalValueException((Throwable)illegalArgumentException);
        }
    }

    public Date getAttributeDateValue(String string, String string2) throws XMLStreamException {
        try {
            CharSequence charSequence = this.getCurrentAttributeTrimCharSeq(string, string2);
            return new GDateBuilder(charSequence).getDate();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidLexicalValueException((Throwable)illegalArgumentException);
        }
    }

    public GDate getAttributeGDateValue(String string, String string2) throws XMLStreamException {
        try {
            CharSequence charSequence = this.getCurrentAttributeTrimCharSeq(string, string2);
            return new GDate(charSequence);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidLexicalValueException((Throwable)illegalArgumentException);
        }
    }

    public GDuration getAttributeGDurationValue(String string, String string2) throws XMLStreamException {
        try {
            return new GDuration(this.getCurrentAttributeTrimCharSeq(string, string2));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidLexicalValueException((Throwable)illegalArgumentException);
        }
    }

    public QName getAttributeQNameValue(String string, String string2) throws XMLStreamException {
        CharSequence charSequence = this.getCurrentAttributeTrimCharSeq(string, string2);
        try {
            return XsTypeConverter.lexQName((CharSequence)charSequence, (NamespaceContext)this.getNamespaceContext());
        }
        catch (InvalidLexicalValueException invalidLexicalValueException) {
            throw new InvalidLexicalValueException((Throwable)invalidLexicalValueException);
        }
    }

    public void setDefaultValue(String string) throws XMLStreamException {
        this._defaultValue = string;
    }

    private CharSequence getCurrentTrimCharSeq() throws XMLStreamException {
        assert (this.contents.isEmpty());
        this.fillContents();
        CharSequence charSequence = this.getTrimCharSeq();
        charSequence = this.handleDefault(charSequence);
        this.contents.clear();
        return charSequence;
    }

    private CharSequence getCurrentPreserveCharSeq() throws XMLStreamException {
        assert (this.contents.isEmpty());
        this.fillContents();
        CharSequence charSequence = this.getPreserveCharSeq();
        charSequence = this.handleDefault(charSequence);
        this.contents.clear();
        return charSequence;
    }

    private CharSequence handleDefault(CharSequence charSequence) {
        if (charSequence.length() == 0 && this._defaultValue != null) {
            charSequence = SingleStringTrimWsCharSeq.create(this._defaultValue);
        }
        this._defaultValue = null;
        return charSequence;
    }

    private CharSequence getTrimCharSeq() {
        int n = this.contents.size();
        if (n == 0) {
            return "";
        }
        if (n == 1) {
            return SingleStringTrimWsCharSeq.create((CharSequence)this.contents.get(0));
        }
        return MultiStringTrimWsCharSeq.create(this.contents);
    }

    private CharSequence getPreserveCharSeq() {
        int n = this.contents.size();
        if (n == 0) {
            return "";
        }
        if (n == 1) {
            return (CharSequence)this.contents.get(0);
        }
        return MultiStringCharSeq.create(this.contents);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void fillContents() throws XMLStreamException {
        if (this.getEventType() == 7) {
            this.next();
        }
        if (this.isStartElement()) {
            this.next();
        }
        int n = 0;
        String string = null;
        int n2 = this.getEventType();
        block6: while (true) {
            switch (n2) {
                case 1: {
                    ++n;
                    string = "Unexpected element '" + this.getName() + "' in text content.";
                    break;
                }
                case 2: {
                    if (--n >= 0) break;
                    break block6;
                }
                case 4: 
                case 6: 
                case 9: 
                case 12: {
                    if (n != 0) break;
                    this.contents.add(this.getText());
                    break;
                }
                case 8: {
                    break block6;
                }
            }
            n2 = this.next();
        }
        if (string != null) {
            throw new XMLStreamException(string);
        }
    }

    private CharSequence getCurrentAttributeTrimCharSeq(int n) {
        return SingleStringTrimWsCharSeq.create(this.getAttributeValue(n));
    }

    private CharSequence getCurrentAttributeTrimCharSeq(String string, String string2) {
        return SingleStringTrimWsCharSeq.create(this.getAttributeValue(string, string2));
    }

    private static final class MultiStringCharSeq {
        private MultiStringCharSeq() {
        }

        public static CharSequence create(List list) {
            if (list.isEmpty()) {
                return "";
            }
            StringBuilder stringBuilder = new StringBuilder();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(list.get(i));
            }
            return stringBuilder;
        }
    }

    private static final class MultiStringTrimWsCharSeq {
        private MultiStringTrimWsCharSeq() {
        }

        public static CharSequence create(List list) {
            assert (!list.isEmpty());
            StringBuilder stringBuilder = new StringBuilder();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(list.get(i));
            }
            return SingleStringTrimWsCharSeq.create(stringBuilder);
        }
    }

    private static final class SingleStringTrimWsCharSeq
    implements CharSequence {
        private final String str;
        private final int start;
        private final int length;

        static CharSequence create(CharSequence charSequence) {
            int n;
            int n2;
            int n3 = charSequence.length();
            if (n3 == 0) {
                return "";
            }
            for (n2 = 0; n2 < n3 && WhitespaceUtils.isWhitespace(charSequence.charAt(n2)); ++n2) {
            }
            for (n = n3 - 1; n >= n2 && WhitespaceUtils.isWhitespace(charSequence.charAt(n)); --n) {
            }
            if (n2 == n + 1) {
                return "";
            }
            return charSequence.subSequence(n2, n + 1);
        }

        private SingleStringTrimWsCharSeq(String string, int n, int n2) {
            this.str = string;
            this.start = n;
            this.length = n2;
        }

        public int length() {
            return this.length;
        }

        public char charAt(int n) {
            return this.str.charAt(this.start + n);
        }

        public CharSequence subSequence(int n, int n2) {
            return this.str.subSequence(this.start + n, this.start + n2);
        }
    }
}

