/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.dom;

import java.io.FileReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import weblogic.xml.dom.DocumentImpl;
import weblogic.xml.dom.ElementNode;
import weblogic.xml.dom.Util;
import weblogic.xml.stax.XMLWriterBase;

public class DOMStreamWriter
extends XMLWriterBase {
    private Document document;
    private Node current;
    private Node sibling;

    public DOMStreamWriter(Document document) throws XMLStreamException {
        this.setStreamWriter((XMLStreamWriter)((Object)this));
        this.document = document;
        this.current = document;
    }

    public DOMStreamWriter(Document document, Node node) {
        this.setStreamWriter((XMLStreamWriter)((Object)this));
        this.document = document;
        this.current = node;
    }

    public DOMStreamWriter(Document document, Node node, Node node2) {
        this.setStreamWriter((XMLStreamWriter)((Object)this));
        this.document = document;
        this.current = node;
        this.sibling = node2;
    }

    public Node getCurrentNode() {
        return this.current;
    }

    public Document getDocument() {
        return this.document;
    }

    protected void openStartTag() throws XMLStreamException {
    }

    protected void closeStartTag() throws XMLStreamException {
        this.flushNamespace();
    }

    protected void openEndTag() throws XMLStreamException {
    }

    protected void closeEndTag() throws XMLStreamException {
    }

    protected String writeName(String string, String string2, String string3) throws XMLStreamException {
        return string;
    }

    private String getQualifiedName(String string, String string2, String string3) {
        if (!"".equals(string2)) {
            string = this.getPrefixInternal(string2);
        }
        String string4 = ElementNode.XMLNS_URI.equals(string2) ? "xmlns:" + string3 : (string == null || "".equals(string) ? string3 : string + ":" + string3);
        return string4;
    }

    private void report() {
        System.out.println("appended current:" + this.current);
        System.out.println(Util.printNode(this.document));
    }

    protected void writeStartElementInternal(String string, String string2) throws XMLStreamException {
        super.writeStartElementInternal(string, string2);
        String string3 = this.getQualifiedName("", string, string2);
        this.current = this.appendChild(this.document.createElementNS(string, string3));
    }

    protected void writeStartElementInternal(String string, String string2, String string3) throws XMLStreamException {
        super.writeStartElementInternal(string2, string3);
        String string4 = this.getQualifiedName(string, string2, string3);
        this.current = this.appendChild(this.document.createElementNS(string2, string4));
    }

    protected void write(String string) throws XMLStreamException {
        this.appendChild(this.document.createTextNode(string));
    }

    protected void write(char c) throws XMLStreamException {
        this.write(String.valueOf(c));
    }

    protected void write(char[] cArray) throws XMLStreamException {
        this.write(String.valueOf(cArray));
    }

    protected void write(char[] cArray, int n, int n2) throws XMLStreamException {
        this.write(String.valueOf(cArray, n, n2));
    }

    public void writeCharacters(String string) throws XMLStreamException {
        this.closeStartElement();
        this.write(string);
    }

    public void writeCharacters(char[] cArray, int n, int n2) throws XMLStreamException {
        this.closeStartElement();
        this.write(cArray, n, n2);
    }

    public void writeAttribute(String string, String string2) throws XMLStreamException {
        if (!this.isOpen()) {
            throw new XMLStreamException("A start element must be written before an attribute");
        }
        if (string == null) {
            throw new IllegalArgumentException("The local name of an attribute may not be null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("An attribute value may not be null");
        }
        this.writeAttribute("", string, string2);
    }

    public void writeAttribute(String string, String string2, String string3) throws XMLStreamException {
        if (!this.isOpen()) {
            throw new XMLStreamException("A start element must be written before an attribute");
        }
        if (string == null) {
            throw new IllegalArgumentException("The namespace URI of an attribute may not be null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("The local name of an attribute may not be null");
        }
        if (string3 == null) {
            throw new IllegalArgumentException("An attribute value may not be null");
        }
        this.prepareNamespace(string);
        Element element = (Element)this.current;
        element.setAttributeNS(string, this.getQualifiedName("", string, string2), string3);
    }

    public void writeAttribute(String string, String string2, String string3, String string4) throws XMLStreamException {
        if (!this.isOpen()) {
            throw new XMLStreamException("A start element must be written before an attribute");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("The namespace URI of an attribute may not be null");
        }
        if (string3 == null) {
            throw new IllegalArgumentException("The local name of an attribute may not be null");
        }
        if (string4 == null) {
            throw new IllegalArgumentException("An attribute value may not be null");
        }
        this.prepareNamespace(string2);
        this.context.bindNamespace(string, string2);
        Element element = (Element)this.current;
        element.setAttributeNS(string2, this.getQualifiedName(string, string2, string3), string4);
    }

    public void writeDefaultNamespace(String string) throws XMLStreamException {
        if (!this.isOpen()) {
            throw new XMLStreamException("A start element must be written before the default namespace");
        }
        Element element = (Element)this.current;
        element.setAttributeNS(ElementNode.XMLNS_URI, "xmlns", string);
        this.setPrefix("", string);
    }

    public void writeNamespace(String string, String string2) throws XMLStreamException {
        if (!this.isOpen()) {
            throw new XMLStreamException("A start element must be written before a namespace");
        }
        if (string == null || "".equals(string) || "xmlns".equals(string)) {
            this.writeDefaultNamespace(string2);
            return;
        }
        Element element = (Element)this.current;
        element.setAttributeNS(ElementNode.XMLNS_URI, "xmlns:" + string, string2);
        this.setPrefix(string, string2);
    }

    public void writeEmptyElement(String string, String string2) throws XMLStreamException {
        this.writeStartElement(string, string2);
        this.writeEndElement();
    }

    public void writeEmptyElement(String string, String string2, String string3) throws XMLStreamException {
        this.writeStartElement(string, string2, string3);
        this.writeEndElement();
    }

    public void writeEndElement() throws XMLStreamException {
        super.writeEndElement();
        this.current = this.current.getParentNode();
    }

    public void writeComment(String string) throws XMLStreamException {
        this.closeStartElement();
        this.appendChild(this.document.createComment(string));
    }

    public void writeProcessingInstruction(String string, String string2) throws XMLStreamException {
        this.closeStartElement();
        this.appendChild(this.document.createProcessingInstruction(string, string2));
    }

    public void writeCData(String string) throws XMLStreamException {
        this.closeStartElement();
        this.appendChild(this.document.createCDATASection(string));
    }

    public void writeStartDocument() throws XMLStreamException {
    }

    public void writeStartDocument(String string) throws XMLStreamException {
    }

    public void writeStartDocument(String string, String string2) throws XMLStreamException {
    }

    public void flush() throws XMLStreamException {
    }

    public void writeEndDocument() throws XMLStreamException {
    }

    private final Node appendChild(Node node) {
        if (this.sibling != null) {
            Node node2 = this.current.insertBefore(node, this.sibling);
            this.sibling = null;
            return node2;
        }
        return this.current.appendChild(node);
    }

    public static void main(String[] stringArray) throws Exception {
        DocumentImpl documentImpl = new DocumentImpl();
        DOMStreamWriter dOMStreamWriter = new DOMStreamWriter(documentImpl);
        XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
        XMLStreamReader xMLStreamReader = xMLInputFactory.createXMLStreamReader(new FileReader(stringArray[0]));
        while (xMLStreamReader.hasNext()) {
            dOMStreamWriter.write(xMLStreamReader);
            xMLStreamReader.next();
        }
        System.out.println(Util.printNode(documentImpl));
    }
}

