/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.dom;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import weblogic.xml.dom.ChildCountException;
import weblogic.xml.dom.DOMProcessingException;

public final class DOMUtils {
    public static final String XMLNS_URI = "http://www.w3.org/2000/xmlns/";
    private static final boolean debug = false;

    public static List getValuesByTagName(Element element, String string) throws DOMProcessingException {
        List list = DOMUtils.getElementsByTagName(element, string);
        Iterator iterator = list.iterator();
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        while (iterator.hasNext()) {
            arrayList.add(DOMUtils.getTextData((Element)iterator.next()));
        }
        return arrayList;
    }

    public static List getElementsByTagName(Element element, String string) throws DOMProcessingException {
        List list = DOMUtils.getOptionalElementsByTagName(element, string);
        if (list.size() == 0) {
            throw new ChildCountException(1, element.getNodeName(), string, 0);
        }
        return list;
    }

    public static String getOptionalValueByTagName(Element element, String string) throws DOMProcessingException {
        Element element2 = DOMUtils.getOptionalElementByTagName(element, string);
        if (element2 == null) {
            return null;
        }
        return DOMUtils.getTextData(element2);
    }

    public static String getValueByTagName(Element element, String string) throws DOMProcessingException {
        Element element2 = DOMUtils.getElementByTagName(element, string);
        return DOMUtils.getTextData(element2);
    }

    public static String getValueByTagNameNS(Element element, String string, String string2) throws DOMProcessingException {
        Element element2 = DOMUtils.getElementByTagNameNS(element, string, string2);
        return DOMUtils.getTextData(element2);
    }

    public static String getOptionalValueByTagNameNS(Element element, String string, String string2) throws DOMProcessingException {
        Element element2 = DOMUtils.getOptionalElementByTagNameNS(element, string, string2);
        return element2 == null ? null : DOMUtils.getTextData(element2);
    }

    public static Element getElementByTagName(Element element, String string) throws DOMProcessingException {
        Element element2 = DOMUtils.getOptionalElementByTagName(element, string);
        if (element2 == null) {
            throw new ChildCountException(1, element.getNodeName(), string, 0);
        }
        return element2;
    }

    public static Element getOptionalElementByTagName(Element element, String string) throws DOMProcessingException {
        List list = DOMUtils.getOptionalElementsByTagName(element, string);
        int n = list.size();
        switch (n) {
            case 0: {
                return null;
            }
            case 1: {
                return (Element)list.get(0);
            }
        }
        throw new ChildCountException(2, element.getNodeName(), string, n);
    }

    public static List getOptionalElementsByLocalName(Element element, String string) throws DOMProcessingException {
        NodeList nodeList = element.getChildNodes();
        ArrayList<Element> arrayList = new ArrayList<Element>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !(element2 = (Element)node).getLocalName().equals(string)) continue;
            arrayList.add(element2);
        }
        return arrayList;
    }

    public static Element getOptionalElementByLocalName(Element element, String string) throws DOMProcessingException {
        List list = DOMUtils.getOptionalElementsByLocalName(element, string);
        int n = list.size();
        switch (n) {
            case 0: {
                return null;
            }
            case 1: {
                return (Element)list.get(0);
            }
        }
        throw new ChildCountException(2, element.getNodeName(), string, n);
    }

    public static Element getElementByTagNameNS(Element element, String string, String string2) throws DOMProcessingException {
        Element element2 = DOMUtils.getOptionalElementByTagNameNS(element, string, string2);
        if (element2 == null) {
            throw new ChildCountException(1, element.getNodeName(), string2, 0);
        }
        return element2;
    }

    public static List getOptionalElementsByTagNameNS(Element element, String string, String string2) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            Element element2;
            if (!(node instanceof Element) || !string.equals((element2 = (Element)node).getNamespaceURI()) || !string2.equals(element2.getLocalName())) continue;
            arrayList.add(element2);
        }
        return arrayList;
    }

    public static Element getOptionalElementByTagNameNS(Element element, String string, String string2) throws DOMProcessingException {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            Element element2;
            if (!(node instanceof Element) || !string.equals((element2 = (Element)node).getNamespaceURI()) || !string2.equals(element2.getLocalName())) continue;
            return element2;
        }
        return null;
    }

    public static List getOptionalElementsByTagName(Element element, String string) throws DOMProcessingException {
        NodeList nodeList = element.getChildNodes();
        ArrayList<Element> arrayList = new ArrayList<Element>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !(element2 = (Element)node).getTagName().equals(string)) continue;
            arrayList.add(element2);
        }
        return arrayList;
    }

    public static String getTextData(Node node) throws DOMProcessingException {
        StringBuffer stringBuffer = new StringBuffer(80);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 3 && node2.getNodeType() != 4) continue;
            Text text = (Text)node2;
            stringBuffer.append(text.getData().trim());
        }
        return new String(stringBuffer.toString());
    }

    public static List getTextDataValues(NodeList nodeList) throws DOMProcessingException {
        int n = nodeList.getLength();
        ArrayList<String> arrayList = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(DOMUtils.getTextData(nodeList.item(i)));
        }
        return arrayList;
    }

    public static List getTextDataValues(List list) throws DOMProcessingException {
        int n = list.size();
        ArrayList<String> arrayList = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(DOMUtils.getTextData((Node)list.get(i)));
        }
        return arrayList;
    }

    public static boolean elementIsOneOf(Element element, String[] stringArray) {
        String string = element.getTagName();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean elementHas(Element element, String string) {
        return DOMUtils.getElementCount(element, string) > 0;
    }

    public static int getElementCount(Element element, String string) {
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        int n2 = nodeList.getLength();
        for (int i = 0; i < n2; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !string.equals(((Element)node).getTagName())) continue;
            ++n;
        }
        return n;
    }

    public static Element addValue(Element element, String string, String string2) {
        Element element2 = element.getOwnerDocument().createElement(string);
        element2.appendChild(element.getOwnerDocument().createTextNode(string2));
        element.appendChild(element2);
        return element2;
    }

    public static Element addValueNS(Element element, String string, String string2, String string3) {
        Element element2 = element.getOwnerDocument().createElementNS(string, string2);
        element2.appendChild(element.getOwnerDocument().createTextNode(string3));
        element.appendChild(element2);
        return element2;
    }

    public static void addNamespaceDeclaration(Element element, String string, String string2) {
        DOMUtils.addNamespaceDeclaration(element, string, string2, true);
    }

    public static void addNamespaceDeclaration(Element element, String string, String string2, boolean bl) {
        element.setAttributeNS(XMLNS_URI, "xmlns:" + string, string2);
    }

    public static String getNamespaceURI(Element element, String string) {
        return element.getAttributeNS(XMLNS_URI, "xmlns:" + string);
    }

    public static void setDefaultNamespace(Element element, String string) {
        element.setAttributeNS(XMLNS_URI, "xmlns", string);
    }

    public static void addTextData(Element element, String string) {
        element.appendChild(element.getOwnerDocument().createTextNode(string));
    }

    public static void addEmptyElement(Element element, String string) {
        element.appendChild(element.getOwnerDocument().createElement(string));
    }

    public static void copyNodes(Element element, NodeList nodeList) throws DOMProcessingException {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            element.appendChild(element.getOwnerDocument().importNode(nodeList.item(i), true));
        }
    }

    public static boolean isNameSpaceUriEmpty(Node node) {
        String string = node.getNamespaceURI();
        return string == null || string.length() == 0;
    }

    public static boolean isNameSpaceUriEmpty(QName qName) {
        String string = qName.getNamespaceURI();
        return string == null || string.length() == 0;
    }

    public static String getAttributeValueAsString(Element element, QName qName) {
        String string = qName.getNamespaceURI();
        String string2 = null;
        string2 = string != null && string.length() > 0 ? element.getAttributeNS(string, qName.getLocalPart()) : element.getAttribute(qName.getLocalPart());
        return string2;
    }

    public static boolean equalsQName(Node node, QName qName) {
        if (!node.getLocalName().equals(qName.getLocalPart())) {
            return false;
        }
        boolean bl = DOMUtils.isNameSpaceUriEmpty(node);
        boolean bl2 = DOMUtils.isNameSpaceUriEmpty(qName);
        if (bl) {
            return bl2;
        }
        if (bl2) {
            return bl;
        }
        return node.getNamespaceURI().equals(qName.getNamespaceURI());
    }

    public static Element getFirstElement(Node node, QName qName) {
        if (node.getNodeType() == 1 && DOMUtils.equalsQName(node, qName)) {
            return (Element)node;
        }
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            Element element = DOMUtils.getFirstElement(node2, qName);
            if (element == null) continue;
            return element;
        }
        return null;
    }

    public static String getTextContent(Element element, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 3 && node.getNodeType() != 4) continue;
            Text text = (Text)node;
            if (bl) {
                stringBuffer.append(text.getData().trim());
                continue;
            }
            stringBuffer.append(text.getData());
        }
        return new String(stringBuffer.toString());
    }
}

