/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.dom;

import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import weblogic.xml.dom.AttributeImpl;
import weblogic.xml.dom.DocumentFragmentNode;
import weblogic.xml.dom.ElementNode;
import weblogic.xml.dom.ImplementationFactory;
import weblogic.xml.dom.NodeImpl;
import weblogic.xml.dom.PINode;
import weblogic.xml.dom.TextNode;
import weblogic.xml.dom.Util;

public final class DocumentImpl
extends NodeImpl
implements Document {
    private String namespaceURI;
    private String localName;
    private ElementNode documentElement;

    public DocumentImpl() {
        this.setNodeType((short)9);
    }

    public DocumentImpl(String string, String string2) {
        this.namespaceURI = string;
        this.localName = Util.getLocalName(string2);
    }

    public String getNodeName() {
        return "#document";
    }

    public Document getOwnerDocument() {
        return this;
    }

    private void check(Node node) {
        if (node.getNodeType() == 1) {
            this.documentElement = (ElementNode)node;
        }
    }

    public Node appendChild(Node node) throws DOMException {
        this.check(node);
        return super.appendChild(node);
    }

    public Node removeChild(Node node) throws DOMException {
        if (node == this.documentElement) {
            this.documentElement = null;
        }
        return super.removeChild(node);
    }

    public Node insertBefore(Node node, Node node2) {
        this.check(node);
        return super.insertBefore(node, node2);
    }

    public Node getPreviousSibling() {
        return null;
    }

    public Node getNextSibling() {
        return null;
    }

    public String getNamespaceURI(String string) {
        return string;
    }

    public void setNamespaceURI(String string) {
        this.namespaceURI = string;
    }

    public void setLocalName(String string) {
        this.localName = string;
    }

    public String getLocalName() {
        return this.localName;
    }

    public DOMImplementation getImplementation() {
        return ImplementationFactory.newImplementation();
    }

    public DocumentType getDoctype() {
        return null;
    }

    public Element getDocumentElement() {
        return this.documentElement;
    }

    public Element createElement(String string) throws DOMException {
        ElementNode elementNode = new ElementNode();
        elementNode.setLocalName(string);
        elementNode.setOwnerDocument(this);
        return elementNode;
    }

    public DocumentFragment createDocumentFragment() {
        return new DocumentFragmentNode();
    }

    public Text createTextNode(String string) {
        TextNode textNode = new TextNode(string);
        this.setOwnerDocument(this);
        return textNode;
    }

    public Comment createComment(String string) {
        TextNode textNode = new TextNode(string);
        textNode.setOwnerDocument(this);
        return textNode.asComment();
    }

    public CDATASection createCDATASection(String string) throws DOMException {
        TextNode textNode = new TextNode(string);
        textNode.setOwnerDocument(this);
        return textNode.asCDATA();
    }

    public ProcessingInstruction createProcessingInstruction(String string, String string2) throws DOMException {
        PINode pINode = new PINode(string, string2);
        pINode.setOwnerDocument(this);
        return pINode;
    }

    public Attr createAttribute(String string) throws DOMException {
        AttributeImpl attributeImpl = new AttributeImpl();
        attributeImpl.setLocalName(string);
        return attributeImpl;
    }

    public EntityReference createEntityReference(String string) throws DOMException {
        throw new UnsupportedOperationException("NYI");
    }

    public Node importNode(Node node, boolean bl) throws DOMException {
        return node;
    }

    public Element createElementNS(String string, String string2) throws DOMException {
        ElementNode elementNode = new ElementNode(string, Util.getLocalName(string2), Util.getPrefix(string2));
        elementNode.setOwnerDocument(this);
        return elementNode;
    }

    public Attr createAttributeNS(String string, String string2) throws DOMException {
        AttributeImpl attributeImpl = new AttributeImpl();
        attributeImpl.setLocalName(Util.getLocalName(string2));
        attributeImpl.setNamespaceURI(string);
        attributeImpl.setPrefix(Util.getPrefix(string2));
        return attributeImpl;
    }

    public Element getElementById(String string) {
        return null;
    }

    public void print(StringBuffer stringBuffer, int n) {
        stringBuffer.append("DOCUMENT[" + this.namespaceURI + "][" + this.localName + "][\n");
        NodeList nodeList = this.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            NodeImpl nodeImpl = (NodeImpl)nodeList.item(i);
            if (nodeImpl == null) {
                System.out.println(i + " is null");
            }
            if (nodeImpl == this.documentElement) {
                stringBuffer.append("ROOT(" + i + ").->[");
            } else {
                stringBuffer.append("CHILD(" + i + ").->[");
            }
            nodeImpl.print(stringBuffer, n + 1);
            stringBuffer.append("]\n");
        }
        stringBuffer.append("]\n");
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.print(stringBuffer, 0);
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) throws Exception {
        DOMImplementation dOMImplementation = ImplementationFactory.newImplementation();
        Document document = dOMImplementation.createDocument("http://myuri", "prefix:document", null);
        Element element = document.createElement("doc");
        document.appendChild(element);
        document.insertBefore(document.createProcessingInstruction("pi1", "data1"), element);
        document.insertBefore(document.createTextNode("\n    \n"), element);
        document.appendChild(document.createProcessingInstruction("pi2", "data2"));
        document.appendChild(document.createTextNode("\n"));
        Element element2 = document.createElementNS("http://fruit", "a:apple");
        element.appendChild(element2);
        Element element3 = document.createElementNS("http://animal", "b:bear");
        element3.appendChild(document.createTextNode("some text about bears"));
        element.appendChild(element3);
        element.setAttribute("root", "value");
        System.out.println(document);
        document.removeChild(element);
        System.out.println(document);
        document.appendChild(element);
        System.out.println(document);
    }
}

