/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.dom;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;
import weblogic.xml.dom.AttributeImpl;
import weblogic.xml.dom.AttributeMap;
import weblogic.xml.dom.AttributeReference;
import weblogic.xml.dom.Builder;
import weblogic.xml.dom.NodeImpl;
import weblogic.xml.dom.Util;

public class ElementNode
extends NodeImpl
implements Element {
    private String tagName;
    private String namespaceURI;
    private String localName;
    private String prefix;
    private AttributeMap attributes;
    public static String XMLNS = "xmlns";
    public static String XMLNS_URI = "http://www.w3.org/2000/xmlns/";

    public ElementNode() {
        this.setNodeType((short)1);
    }

    public ElementNode(int n) {
        this();
        this.attributes = new AttributeMap(n);
    }

    public ElementNode(String string, String string2, String string3) {
        this();
        this.namespaceURI = string;
        this.localName = string2;
        this.prefix = string3;
    }

    public void setAttributes(AttributeMap attributeMap) {
        this.attributes = attributeMap;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public void setNamespaceURI(String string) {
        this.namespaceURI = string;
    }

    public void setLocalName(String string) {
        this.localName = string;
    }

    public String getLocalName() {
        return this.localName;
    }

    public void setPrefix(String string) {
        this.prefix = string;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getNodeName() {
        if (this.prefix != null) {
            return this.prefix + ":" + this.localName;
        }
        return this.localName;
    }

    public AttributeMap getAttributeMap() {
        return this.attributes;
    }

    public NamedNodeMap getAttributes() {
        if (this.attributes == null) {
            return Util.NAMED_NODE_MAP;
        }
        return this.attributes;
    }

    public String getAttribute(String string) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.getValue(string);
    }

    public Attr getAttributeNode(String string) {
        if (this.attributes == null) {
            return null;
        }
        int n = this.attributes.getAttributeIndex(string);
        if (n == -1) {
            return null;
        }
        return this.attributes.getAttribute(n);
    }

    public String getNamespaceURI(String string) {
        int n;
        if (this.attributes != null && (n = this.attributes.getAttributeIndex(XMLNS_URI, string)) != -1) {
            return this.attributes.getValue(n);
        }
        Node node = this.getParentNode();
        if (node == null) {
            return null;
        }
        if (node.getNodeType() != 1) {
            return null;
        }
        ElementNode elementNode = (ElementNode)node;
        return elementNode.getNamespaceURI(string);
    }

    public String getPrefix(String string) {
        Node node;
        if (this.attributes != null) {
            for (int i = 0; i < this.attributes.length(); ++i) {
                if (!string.equals(this.attributes.getValue(i)) || !XMLNS_URI.equals(this.attributes.getNamespaceURI(i))) continue;
                return this.attributes.getPrefix(i);
            }
        }
        if ((node = this.getParentNode()) == null) {
            return null;
        }
        if (node.getNodeType() != 1) {
            return null;
        }
        ElementNode elementNode = (ElementNode)node;
        return elementNode.getPrefix(string);
    }

    public String getDefaultNamespaceURI() {
        int n;
        if (this.attributes != null && (n = this.attributes.getAttributeIndex(XMLNS)) != -1) {
            return this.attributes.getValue(n);
        }
        Node node = this.getParentNode();
        if (node == null) {
            return null;
        }
        if (node.getNodeType() != 1) {
            return null;
        }
        ElementNode elementNode = (ElementNode)node;
        return elementNode.getDefaultNamespaceURI();
    }

    public int setNamespaceURI(String string, String string2) {
        int n = this.attributes.getAttributeIndex(XMLNS_URI, string);
        if (n == -1) {
            return this.attributes.addAttribute(XMLNS_URI, string, XMLNS, string2);
        }
        this.attributes.setAttribute(n, XMLNS_URI, string, XMLNS, string2);
        return n;
    }

    public Attr setNamespaceURI(Attr attr) {
        int n = this.setNamespaceURI(attr.getLocalName(), attr.getValue());
        return this.attributes.getAttribute(n);
    }

    public Attr getAttributeNodeNS(String string, String string2) {
        if (this.attributes == null) {
            return null;
        }
        int n = this.attributes.getAttributeIndex(string, string2);
        if (n == -1) {
            return null;
        }
        return this.attributes.getAttribute(n);
    }

    public String getAttributeNS(String string, String string2) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.getValue(string, string2);
    }

    public String getTagName() {
        return this.localName;
    }

    public boolean hasAttribute(String string) {
        if (this.attributes == null) {
            return false;
        }
        return this.attributes.getAttributeIndex(string) != -1;
    }

    public boolean hasAttributeNS(String string, String string2) {
        if (this.attributes == null) {
            return false;
        }
        return this.attributes.getAttributeIndex(string, string2) != -1;
    }

    public void removeAttribute(String string) {
        if (this.attributes == null) {
            return;
        }
        this.attributes.removeAttribute(this.attributes.getAttributeIndex(string));
    }

    public Attr removeAttributeNode(Attr attr) {
        if (this.attributes == null) {
            throw new DOMException(8, "The attribute provided is not a child of this Element");
        }
        Attr attr2 = (Attr)attr.cloneNode(false);
        AttributeReference attributeReference = (AttributeReference)attr;
        if (attributeReference.getOwnerElement() != this) {
            throw new DOMException(8, "The attribute provided is not a child of this Element");
        }
        int n = attributeReference.getIndex();
        this.attributes.removeAttribute(n);
        return attr2;
    }

    public void removeAttributeNS(String string, String string2) {
        if (this.attributes == null) {
            return;
        }
        int n = this.attributes.getAttributeIndex(string, string2);
        if (n == -1) {
            return;
        }
        this.attributes.removeAttribute(n);
    }

    public void setAttribute(String string, String string2) {
        int n;
        if (this.attributes == null) {
            this.attributes = new AttributeMap();
        }
        if ((n = this.attributes.getAttributeIndex(this.localName)) == -1) {
            this.attributes.addAttribute(null, string, null, string2);
        } else {
            this.attributes.setValue(n, string2);
        }
    }

    public Attr setAttributeNode(Attr attr) {
        int n;
        if (this.attributes == null) {
            this.attributes = new AttributeMap();
        }
        if (XMLNS.equals(attr.getPrefix())) {
            this.setNamespaceURI(attr);
        }
        if ((n = this.attributes.getAttributeIndex(attr.getNamespaceURI(), attr.getLocalName())) == -1) {
            int n2 = this.attributes.addAttribute(attr.getNamespaceURI(), attr.getLocalName(), attr.getPrefix(), attr.getValue());
            return this.attributes.getAttribute(n2);
        }
        this.attributes.setAttribute(n, attr.getNamespaceURI(), attr.getLocalName(), attr.getPrefix(), attr.getValue());
        return this.attributes.getAttribute(n);
    }

    public Attr setAttributeNodeNS(Attr attr) {
        return this.setAttributeNode(attr);
    }

    public boolean hasAttributes() {
        if (this.attributes == null) {
            return false;
        }
        return this.attributes.getLength() > 0;
    }

    public void setAttributeNS(String string, String string2, String string3, String string4) {
        if (this.attributes == null) {
            this.attributes = new AttributeMap();
        }
        if (XMLNS.equals(string2)) {
            this.setNamespaceURI(string3, string4);
            return;
        }
        int n = this.attributes.getAttributeIndex(string, string3);
        if (n == -1) {
            this.attributes.addAttribute(string, string3, string2, string4);
        } else {
            this.attributes.setPrefix(n, string2);
            this.attributes.setValue(n, string4);
        }
    }

    public void setAttributeNS(String string, String string2, String string3) {
        String string4 = Util.getPrefix(string2);
        String string5 = Util.getLocalName(string2);
        this.setAttributeNS(string, string4, string5, string3);
    }

    public void printName(StringBuffer stringBuffer) {
        String string = this.getNamespaceURI();
        String string2 = this.getPrefix();
        if (string != null && !"".equals(string)) {
            stringBuffer.append("['" + string + "']:");
        }
        if (this.prefix != null) {
            stringBuffer.append(string2 + ":");
        }
        stringBuffer.append(this.getLocalName());
    }

    public void print(StringBuffer stringBuffer, int n) {
        stringBuffer.append("<");
        this.printName(stringBuffer);
        if (this.attributes != null) {
            stringBuffer.append(this.attributes.toString());
        }
        if (!this.hasChildNodes()) {
            stringBuffer.append("/>");
            return;
        }
        stringBuffer.append(">");
        NodeList nodeList = this.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            NodeImpl nodeImpl = (NodeImpl)nodeList.item(i);
            nodeImpl.print(stringBuffer, n + 1);
        }
        stringBuffer.append("</");
        this.printName(stringBuffer);
        stringBuffer.append(">");
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.print(stringBuffer, 0);
        return stringBuffer.toString();
    }

    public ElementNode read(XMLStreamReader xMLStreamReader) throws IOException {
        try {
            return Builder.read(this, xMLStreamReader);
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    public ElementNode read(InputStream inputStream) throws IOException {
        try {
            return this.read(XMLInputFactory.newInstance().createXMLStreamReader(inputStream));
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    public static void main(String[] stringArray) throws Exception {
        ElementNode elementNode = new ElementNode();
        elementNode.setLocalName("test_node");
        elementNode.setAttribute("a", "apple");
        elementNode.setAttribute("b", "banana");
        elementNode.setAttribute("c", "cherry");
        System.out.println("Node at Start=" + elementNode);
        elementNode.getAttributeNode("a").setValue("apples");
        elementNode.getAttributeNode("b").setValue("bananas");
        elementNode.getAttributeNode("c").setValue("cherrys");
        System.out.println("Node after mod=" + elementNode);
        elementNode.removeAttribute("a");
        System.out.println("Node after removal=" + elementNode);
        System.out.println("isnull=" + elementNode.getAttributeNode("a"));
        Attr attr = elementNode.setAttributeNode(new AttributeImpl(elementNode, null, null, "d", "donut"));
        System.out.println("Node after mod=" + elementNode);
        attr.setValue("donuts");
        attr.setPrefix("d");
        System.out.println("Node after mod=" + elementNode);
        NamedNodeMap namedNodeMap = elementNode.getAttributes();
        Attr attr2 = new AttributeImpl(elementNode, null, null, "e", "elephant");
        attr2 = (Attr)namedNodeMap.setNamedItem(attr2);
        System.out.println("Node after att map mod=" + elementNode);
        attr2.setValue("elephants");
        System.out.println("Node after att map mod=" + elementNode);
        ElementNode elementNode2 = new ElementNode();
        elementNode2.setLocalName("n1");
        elementNode2.setAttributeNS(null, "xmlns:a", "http://a");
        elementNode2.setAttributeNS(null, "xmlns:b", "http://b");
        elementNode2.setAttributeNS(null, "xmlns", "http://default");
        elementNode2.setAttributeNS("http://b", "b:banana", "food");
        elementNode2.setAttributeNS("http://a", "a:apple", "fruit");
        ElementNode elementNode3 = new ElementNode();
        elementNode3.setLocalName("n2");
        elementNode2.appendChild(elementNode3);
        System.out.println(elementNode2);
        System.out.println("parent:" + elementNode3.getNamespaceURI("b"));
        System.out.println("default:" + elementNode3.getDefaultNamespaceURI());
    }

    public void setIdAttributeNode(Attr attr, boolean bl) throws DOMException {
        throw new UnsupportedOperationException("This class does not support JDK1.5");
    }

    public void setIdAttributeNS(String string, String string2, boolean bl) throws DOMException {
        throw new UnsupportedOperationException("This class does not support JDK1.5");
    }

    public void setIdAttribute(String string, boolean bl) throws DOMException {
        throw new UnsupportedOperationException("This class does not support JDK1.5");
    }

    public TypeInfo getSchemaTypeInfo() throws DOMException {
        throw new UnsupportedOperationException("This class does not support JDK1.5");
    }
}

