/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.dom;

import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import weblogic.xml.dom.ElementNode;
import weblogic.xml.dom.NamespaceUtils;

public class NamespaceContextNode
implements NamespaceContext {
    private final Element current;

    public NamespaceContextNode(Element element) {
        this.current = element;
    }

    public String getNamespaceURI(String string) {
        if (string == null) {
            throw new IllegalArgumentException("null prefix");
        }
        if ("xml".equals(string)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if ("xmlns".equals(string)) {
            return "http://www.w3.org/2000/xmlns/";
        }
        if (this.current == null) {
            return null;
        }
        return this.getNamespaceURI(this.current, string);
    }

    public String getPrefix(String string) {
        if (string == null) {
            throw new IllegalArgumentException("null namespaceURI");
        }
        if ("http://www.w3.org/XML/1998/namespace".equals(string)) {
            return "xml";
        }
        if ("http://www.w3.org/2000/xmlns/".equals(string)) {
            return "xmlns";
        }
        if (this.current == null) {
            return null;
        }
        return this.getPrefix(this.current, string);
    }

    private String getNamespaceURI(Element element, String string) {
        String string2 = NamespaceUtils.getNamespaceOnElement((Element)element, (String)string);
        if (string2 != null) {
            return string2;
        }
        Node node = element.getParentNode();
        if (node == null) {
            return null;
        }
        if (node.getNodeType() != 1) {
            return null;
        }
        return this.getNamespaceURI((Element)node, string);
    }

    public String getPrefix(Element element, String string) {
        String string2 = NamespaceUtils.getPrefixOnElement((Node)element, (String)string, (boolean)true);
        if (string2 != null) {
            return string2;
        }
        Node node = element.getParentNode();
        if (node == null) {
            return null;
        }
        if (node.getNodeType() != 1) {
            return null;
        }
        return this.getPrefix((Element)node, string);
    }

    private void collectPrefixes(Element element, String string, ArrayList arrayList) {
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            if (!attr.getValue().equals(string) || !attr.getNamespaceURI().equals(ElementNode.XMLNS_URI)) continue;
            arrayList.add(attr.getLocalName());
        }
        Node node = element.getParentNode();
        if (node == null) {
            return;
        }
        if (node.getNodeType() != 1) {
            return;
        }
        this.collectPrefixes((Element)node, string, arrayList);
    }

    public Iterator getPrefixes(String string) {
        ArrayList arrayList = new ArrayList();
        this.collectPrefixes(this.current, string, arrayList);
        return arrayList.iterator();
    }
}

