/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.dom;

import java.util.Iterator;
import javax.xml.soap.Name;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.UserDataHandler;
import weblogic.xml.dom.ChildIterator;
import weblogic.xml.dom.DOMStreamReader;
import weblogic.xml.dom.NodeIterator;
import weblogic.xml.dom.NodeListImpl;
import weblogic.xml.dom.Util;
import weblogic.xml.stax.ReaderToWriter;

public class NodeImpl
implements Node,
NodeList,
Cloneable {
    private Document ownerDocument;
    private NodeImpl parent;
    private NodeImpl firstChild;
    private NodeImpl lastChild;
    private NodeImpl previousSibling;
    private NodeImpl nextSibling;
    private int numChildren = 0;
    private short nodeType;
    private String nodeName;
    private String nodeValue;
    private String localName;
    private transient NodeImpl currentNode = this.firstChild;
    private transient int currentNodeCount = 0;
    private static final boolean debug = false;

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String string) {
        this.nodeName = string;
    }

    public String getNodeValue() throws DOMException {
        return this.nodeValue;
    }

    public void setNodeValue(String string) throws DOMException {
        this.nodeValue = string;
    }

    public void setNodeType(short s) {
        this.nodeType = s;
    }

    public short getNodeType() {
        return this.nodeType;
    }

    public Node getParentNode() {
        return this.parent;
    }

    public NodeList getChildNodes() {
        if (this.firstChild == null) {
            return Util.EMPTY_NODELIST;
        }
        return this;
    }

    public Node getFirstChild() {
        return this.firstChild;
    }

    public Node getLastChild() {
        return this.lastChild;
    }

    public Node getPreviousSibling() {
        return this.previousSibling;
    }

    public Node getNextSibling() {
        return this.nextSibling;
    }

    public NamedNodeMap getAttributes() {
        return null;
    }

    public void setOwnerDocument(Document document) {
        this.ownerDocument = document;
    }

    public Document getOwnerDocument() {
        if (this.ownerDocument == null && this.parent != null) {
            this.ownerDocument = this.parent.getOwnerDocument();
        }
        return this.ownerDocument;
    }

    public void setParentNode(Node node) {
        this.parent = (NodeImpl)node;
    }

    public Node insertBefore(Node node, Node node2) throws DOMException {
        if (node == null) {
            throw new NullPointerException("newChild may not be null");
        }
        if (node2 == null) {
            return null;
        }
        if (node == node2) {
            return node;
        }
        if (node.getNodeType() == 11) {
            while (node.hasChildNodes()) {
                this.insertBefore(node.getFirstChild(), node2);
            }
            return node;
        }
        NodeImpl nodeImpl = (NodeImpl)node2;
        if (nodeImpl.parent != this) {
            throw new DOMException(8, "Unable to insert before the refChild because it is not a child of this node");
        }
        NodeImpl nodeImpl2 = (NodeImpl)node;
        if (nodeImpl2.parent != null) {
            nodeImpl2.parent.removeChild(nodeImpl2);
        }
        ++this.numChildren;
        nodeImpl2.parent = this;
        if (this.firstChild == node2) {
            this.firstChild = nodeImpl2;
        } else {
            nodeImpl.previousSibling.nextSibling = nodeImpl2;
        }
        nodeImpl2.nextSibling = nodeImpl;
        nodeImpl.previousSibling = nodeImpl2;
        this.resetCache();
        return nodeImpl2;
    }

    public Node replaceChild(Node node, Node node2) throws DOMException {
        if (node == null) {
            throw new NullPointerException("newChild may not be null");
        }
        this.insertBefore(node, node2);
        this.removeChild(node2);
        this.resetCache();
        return node2;
    }

    public Node removeChild(Node node) throws DOMException {
        if (node == null) {
            return null;
        }
        NodeImpl nodeImpl = (NodeImpl)node;
        if (nodeImpl.parent != this) {
            throw new DOMException(8, "Attempt to removeChild that is not a child of this Node");
        }
        nodeImpl.parent = null;
        --this.numChildren;
        if (this.firstChild == nodeImpl) {
            this.firstChild = this.firstChild.nextSibling;
            if (this.lastChild == nodeImpl) {
                this.lastChild = this.firstChild;
            }
            this.resetCache();
            return nodeImpl;
        }
        if (this.lastChild == nodeImpl) {
            this.lastChild = this.lastChild.previousSibling;
            this.resetCache();
            return nodeImpl;
        }
        nodeImpl.previousSibling.nextSibling = nodeImpl.nextSibling;
        this.resetCache();
        return nodeImpl;
    }

    public Node appendChild(Node node) throws DOMException {
        if (node == this) {
            throw new DOMException(3, "A Node may not be its own child");
        }
        if (node == null) {
            throw new NullPointerException("newChild may not be null");
        }
        if (node.getNodeType() == 11) {
            while (node.hasChildNodes()) {
                this.appendChild(node.getFirstChild());
            }
            return node;
        }
        NodeImpl nodeImpl = (NodeImpl)node;
        if (nodeImpl.parent != null) {
            nodeImpl.parent.removeChild(nodeImpl);
        }
        nodeImpl.parent = this;
        if (this.firstChild == null) {
            this.numChildren = 1;
            this.firstChild = nodeImpl;
            this.lastChild = nodeImpl;
            this.resetCache();
            return nodeImpl;
        }
        ++this.numChildren;
        this.lastChild.nextSibling = nodeImpl;
        nodeImpl.previousSibling = this.lastChild;
        this.lastChild = nodeImpl;
        this.resetCache();
        return nodeImpl;
    }

    public boolean hasChildNodes() {
        return this.numChildren != 0;
    }

    public void removeChildren() {
        this.firstChild = null;
        this.lastChild = null;
        this.numChildren = 0;
        this.resetCache();
    }

    public Node cloneNode(boolean bl) {
        NodeImpl nodeImpl;
        try {
            nodeImpl = (NodeImpl)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException.toString());
        }
        nodeImpl.removeChildren();
        nodeImpl.parent = null;
        if (bl) {
            NodeImpl nodeImpl2 = this.firstChild;
            while (nodeImpl2 != null) {
                nodeImpl.appendChild(nodeImpl2.cloneNode(true));
                nodeImpl2 = nodeImpl2.nextSibling;
            }
        }
        return nodeImpl;
    }

    public void normalize() {
    }

    public boolean isSupported(String string, String string2) {
        return false;
    }

    public String getNamespaceURI() {
        return null;
    }

    public String getPrefix() {
        return null;
    }

    public void setPrefix(String string) throws DOMException {
    }

    public String getLocalName() {
        return null;
    }

    public boolean hasAttributes() {
        return false;
    }

    public Iterator getChildren() {
        return new ChildIterator(this);
    }

    private void resetCache() {
        this.currentNode = this.firstChild;
        this.currentNodeCount = 0;
    }

    public int getLength() {
        return this.numChildren;
    }

    public Node item(int n) {
        if (n >= this.numChildren) {
            throw new IndexOutOfBoundsException(n + " greater than " + " the number of chilren " + this.numChildren);
        }
        if (this.currentNodeCount == n) {
            if (this.currentNode == null) {
                throw new NullPointerException("Internal Error: null child");
            }
            return this.currentNode;
        }
        switch (n) {
            case 0: {
                this.currentNode = this.firstChild;
                this.currentNodeCount = 0;
                if (this.currentNode == null) {
                    throw new NullPointerException("Internal Error: null child");
                }
                return this.currentNode;
            }
            case 1: {
                this.currentNode = this.firstChild.nextSibling;
                this.currentNodeCount = 1;
                if (this.currentNode == null) {
                    throw new NullPointerException("Internal Error: null child");
                }
                return this.currentNode;
            }
            case 2: {
                this.currentNode = this.firstChild.nextSibling.nextSibling;
                this.currentNodeCount = 2;
                if (this.currentNode == null) {
                    throw new NullPointerException("Internal Error: null child");
                }
                return this.currentNode;
            }
        }
        if (this.currentNodeCount + 1 == n) {
            this.currentNode = this.currentNode.nextSibling;
            ++this.currentNodeCount;
            if (this.currentNode == null) {
                throw new NullPointerException("Internal Error: null child");
            }
            return this.currentNode;
        }
        if (this.currentNodeCount - 1 == n) {
            this.currentNode = this.currentNode.previousSibling;
            --this.currentNodeCount;
            if (this.currentNode == null) {
                throw new NullPointerException("Internal Error: null child");
            }
            return this.currentNode;
        }
        if (this.numChildren - 1 == n) {
            this.currentNode = this.lastChild;
            if (this.currentNode == null) {
                throw new NullPointerException("Internal Error: null child");
            }
            this.currentNodeCount = this.numChildren - 1;
            return this.currentNode;
        }
        this.currentNode = this.firstChild.nextSibling.nextSibling.nextSibling;
        this.currentNodeCount = 3;
        for (int i = 3; i < this.numChildren; ++i) {
            if (i == n) {
                if (this.currentNode == null) {
                    throw new NullPointerException("Internal Error: null child");
                }
                return this.currentNode;
            }
            this.currentNode = this.currentNode.nextSibling;
            ++this.currentNodeCount;
        }
        throw new DOMException(8, "child " + n + " not found");
    }

    public NodeIterator iterator() {
        return new NodeIterator(this);
    }

    public void print(StringBuffer stringBuffer, int n) {
        stringBuffer.append("NoData");
    }

    public void write(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        ReaderToWriter readerToWriter = new ReaderToWriter(xMLStreamWriter);
        XMLStreamReader xMLStreamReader = this.reader();
        while (xMLStreamReader.hasNext()) {
            readerToWriter.write(xMLStreamReader);
            xMLStreamReader.next();
        }
    }

    public NodeList getElementsByTagName(String string) {
        NodeListImpl nodeListImpl = new NodeListImpl();
        NodeIterator nodeIterator = this.iterator();
        nodeIterator.next();
        while (nodeIterator.hasNext()) {
            Node node = nodeIterator.nextNode();
            if (node.getNodeType() != 1 || !string.equals(((Element)node).getTagName())) continue;
            nodeListImpl.add(node);
        }
        return nodeListImpl;
    }

    public NodeList getElementsByTagNameNS(String string, String string2) {
        NodeListImpl nodeListImpl = new NodeListImpl();
        NodeIterator nodeIterator = this.iterator();
        nodeIterator.next();
        while (nodeIterator.hasNext()) {
            Node node = nodeIterator.nextNode();
            if (node.getNodeType() != 1 || !string2.equals(node.getLocalName()) || string != null && !"*".equals(string) && !string.equals(node.getNamespaceURI())) continue;
            nodeListImpl.add(node);
        }
        return nodeListImpl;
    }

    public XMLStreamReader reader() throws XMLStreamException {
        return new DOMStreamReader(this);
    }

    public Node createChild(Name name) {
        throw new IllegalStateException("createChild is abstract");
    }

    public Node renameNode(Node node, String string, String string2) throws DOMException {
        throw new UnsupportedOperationException("This class does not support JDK1.5");
    }

    public void normalizeDocument() throws DOMException {
        throw new UnsupportedOperationException("This class does not support JDK1.5");
    }

    public DOMConfiguration getDomConfig() throws DOMException {
        throw new UnsupportedOperationException("This class does not support JDK1.5");
    }

    public void setDocumentURI(String string) throws DOMException {
        throw new UnsupportedOperationException("This class does not support JDK1.5");
    }

    public String getDocumentURI() throws DOMException {
        throw new UnsupportedOperationException("This class does not support JDK1.5");
    }

    public Node adoptNode(Node node) throws DOMException {
        throw new UnsupportedOperationException("This class does not support JDK1.5");
    }

    public void setStrictErrorChecking(boolean bl) throws DOMException {
        throw new UnsupportedOperationException("This class does not support JDK1.5");
    }

    public boolean getStrictErrorChecking() throws DOMException {
        throw new UnsupportedOperationException("This class does not support JDK1.5");
    }

    public void setXmlVersion(String string) throws DOMException {
        throw new UnsupportedOperationException("This class does not support JDK1.5");
    }

    public String getXmlVersion() throws DOMException {
        throw new UnsupportedOperationException("This class does not support JDK1.5");
    }

    public void setXmlStandalone(boolean bl) throws DOMException {
        throw new UnsupportedOperationException("This class does not support JDK1.5");
    }

    public boolean getXmlStandalone() throws DOMException {
        throw new UnsupportedOperationException("This class does not support JDK1.5");
    }

    public String getXmlEncoding() throws DOMException {
        throw new UnsupportedOperationException("This class does not support JDK1.5");
    }

    public String getInputEncoding() throws DOMException {
        throw new UnsupportedOperationException("This class does not support JDK1.5");
    }

    public Object getUserData(String string) throws DOMException {
        throw new UnsupportedOperationException("This class does not support JDK1.5");
    }

    public Object setUserData(String string, Object object, UserDataHandler userDataHandler) throws DOMException {
        throw new UnsupportedOperationException("This class does not support JDK1.5");
    }

    public Object getFeature(String string, String string2) throws DOMException {
        throw new UnsupportedOperationException("This class does not support JDK1.5");
    }

    public boolean isEqualNode(Node node) throws DOMException {
        throw new UnsupportedOperationException("This class does not support JDK1.5");
    }

    public String lookupNamespaceURI(String string) throws DOMException {
        throw new UnsupportedOperationException("This class does not support JDK1.5");
    }

    public boolean isDefaultNamespace(String string) throws DOMException {
        throw new UnsupportedOperationException("This class does not support JDK1.5");
    }

    public String lookupPrefix(String string) throws DOMException {
        throw new UnsupportedOperationException("This class does not support JDK1.5");
    }

    public boolean isSameNode(Node node) throws DOMException {
        throw new UnsupportedOperationException("This class does not support JDK1.5");
    }

    public void setTextContent(String string) throws DOMException {
        throw new UnsupportedOperationException("This class does not support JDK1.5");
    }

    public String getTextContent() throws DOMException {
        throw new UnsupportedOperationException("This class does not support JDK1.5");
    }

    public short compareDocumentPosition(Node node) throws DOMException {
        throw new UnsupportedOperationException("This class does not support JDK1.5");
    }

    public String getBaseURI() throws DOMException {
        throw new UnsupportedOperationException("This class does not support JDK1.5");
    }
}

