/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.dom;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.w3c.dom.Node;

public class NodeIterator
implements Iterator {
    private final Node startNode;
    private Node currentNode;
    private Node nextNode;

    public NodeIterator(Node node) {
        this.startNode = this.nextNode = node;
    }

    private void advance() {
        this.currentNode = this.nextNode;
        this.nextNode = this.findNext();
    }

    public Object next() {
        return this.nextNode();
    }

    public void remove() {
        this.current().getParentNode().removeChild(this.current());
        this.advance();
    }

    public Node current() {
        if (this.currentNode == null) {
            throw new NoSuchElementException("The current node is null please call next() before using accessor methods");
        }
        return this.currentNode;
    }

    public Node nextNode() {
        if (this.nextNode == null) {
            throw new NoSuchElementException("Unable to advance the node iterator");
        }
        this.advance();
        return this.current();
    }

    private Node findNext() {
        Node node = this.currentNode.getFirstChild();
        if (node != null) {
            return node;
        }
        node = this.currentNode.getNextSibling();
        if (node != null) {
            return node;
        }
        if (this.currentNode == this.startNode) {
            return null;
        }
        for (node = this.currentNode.getParentNode(); node != null && node != this.startNode; node = node.getParentNode()) {
            if (node.getNextSibling() == null) continue;
            return node.getNextSibling();
        }
        return null;
    }

    public boolean hasNext() {
        return this.nextNode != null;
    }
}

