/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.dom;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ResourceEntityResolver
implements EntityResolver {
    private static final boolean debug = false;
    private static final boolean verbose = false;
    protected Map entityCatalog = new HashMap();
    private boolean unresolvedIsFatal = false;

    public void setUnresolvedIsFatal(boolean bl) {
        this.unresolvedIsFatal = bl;
    }

    public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
        if (string == null) {
            return null;
        }
        InputSource inputSource = null;
        EntityResource entityResource = (EntityResource)this.entityCatalog.get(string);
        if (entityResource == null) {
            String string3 = "Could not locate public Id " + string + "\nin entityCatalog";
            if (this.unresolvedIsFatal) {
                throw new SAXException(string3);
            }
            return null;
        }
        InputStream inputStream = null;
        if (entityResource != null) {
            inputStream = entityResource.getResourceAsStream();
        }
        if (inputStream == null) {
            String string4 = "ResourceEntityResolver: did not resolve entity for publicId = " + string + " with resource name " + entityResource.getResourceName();
            if (this.unresolvedIsFatal) {
                throw new SAXException(string4);
            }
            return null;
        }
        inputSource = new InputSource(inputStream);
        inputSource.setPublicId(string);
        return inputSource;
    }

    public void addEntityResource(String string, String string2) {
        this.addEntityResource(string, string2, null);
    }

    public void addEntityResource(String string, String string2, Class clazz) {
        this.entityCatalog.put(string, new EntityResource(string2, clazz));
    }

    public String toString() {
        return this.entityCatalog.toString();
    }

    protected static class EntityResource {
        private final String name;
        private final Class clazz;

        public EntityResource(String string, Class clazz) {
            this.name = string;
            this.clazz = clazz;
        }

        public String getResourceName() {
            return this.name;
        }

        public Class getResourceClass() {
            return this.clazz;
        }

        public InputStream getResourceAsStream() {
            if (this.clazz == null) {
                return this.getClass().getResourceAsStream(this.name);
            }
            return this.clazz.getResourceAsStream(this.name);
        }

        public String toString() {
            return this.name + "/" + this.clazz;
        }
    }
}

