/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.dom;

import org.w3c.dom.CDATASection;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Text;
import weblogic.xml.dom.ChildNode;

public class TextNode
extends ChildNode
implements CharacterData,
CDATASection,
Text,
Comment {
    private String dataCache;
    private StringBuffer modifiableData;

    public TextNode() {
        this.setNodeType((short)3);
    }

    public TextNode(String string) {
        this();
        this.dataCache = string;
    }

    public String getData() throws DOMException {
        if (this.dataCache != null) {
            return this.dataCache;
        }
        return this.modifiableData.toString();
    }

    public void setData(String string) throws DOMException {
        this.dataCache = string;
        this.modifiableData = null;
    }

    public int getLength() {
        if (this.dataCache != null) {
            return this.dataCache.length();
        }
        if (this.modifiableData != null) {
            return this.modifiableData.length();
        }
        return 0;
    }

    public String substringData(int n, int n2) throws DOMException {
        if (this.dataCache != null) {
            return this.dataCache.substring(n, n2);
        }
        if (this.modifiableData != null) {
            return this.modifiableData.substring(n, n2);
        }
        return null;
    }

    private void modifyOnWrite() {
        if (this.dataCache != null) {
            this.modifiableData = new StringBuffer(this.dataCache);
            this.dataCache = null;
        }
    }

    public void appendData(String string) throws DOMException {
        this.modifiableData.append(string);
    }

    public void insertData(int n, String string) throws DOMException {
        this.modifiableData.insert(n, string);
    }

    public void deleteData(int n, int n2) throws DOMException {
        this.modifiableData.delete(n, n2);
    }

    public void replaceData(int n, int n2, String string) throws DOMException {
        this.modifiableData.replace(n, n2, string);
    }

    public Text splitText(int n) throws DOMException {
        TextNode textNode = new TextNode();
        String string = this.substringData(0, n);
        String string2 = this.substringData(n, this.getLength() - n);
        this.setData(string);
        textNode.setData(string2);
        this.getParentNode().insertBefore(textNode, this.getNextSibling());
        return textNode;
    }

    public String getNodeName() {
        switch (this.getNodeType()) {
            case 8: {
                return "#comment";
            }
            case 4: {
                return "#cdata-section";
            }
        }
        return "#text";
    }

    public String getNodeValue() {
        return this.getData();
    }

    public void setNodeValue(String string) {
        this.setData(string);
    }

    public Comment asComment() {
        this.setNodeType((short)8);
        return this;
    }

    public CDATASection asCDATA() {
        this.setNodeType((short)4);
        return this;
    }

    public void print(StringBuffer stringBuffer, int n) {
        stringBuffer.append(this.toString());
    }

    public String toString() {
        String string = this.getData();
        if (string == null) {
            string = "";
        }
        switch (this.getNodeType()) {
            case 8: {
                return "<!--" + string + "-->";
            }
            case 4: {
                return "<![CDATA[" + string + "]]>";
            }
        }
        return string;
    }

    public Text replaceWholeText(String string) throws DOMException {
        throw new UnsupportedOperationException("This class does not support JDK1.5");
    }

    public String getWholeText() throws DOMException {
        throw new UnsupportedOperationException("This class does not support JDK1.5");
    }

    public boolean isElementContentWhitespace() throws DOMException {
        throw new UnsupportedOperationException("This class does not support JDK1.5");
    }
}

