/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.dom;

import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;

public final class Util {
    public static final NodeList EMPTY_NODELIST = new NodeList(){

        public int getLength() {
            return 0;
        }

        public Node item(int n) {
            return null;
        }
    };
    public static final NamedNodeMap NAMED_NODE_MAP = new NamedNodeMap(){

        public int getLength() {
            return 0;
        }

        public Node getNamedItem(String string) {
            return null;
        }

        public Node getNamedItemNS(String string, String string2) {
            return null;
        }

        public Node item(int n) {
            return null;
        }

        public Node removeNamedItem(String string) {
            return null;
        }

        public Node removeNamedItemNS(String string, String string2) {
            return null;
        }

        public Node setNamedItem(Node node) {
            throw new UnsupportedOperationException("This NamedNodeMap is readOnly");
        }

        public Node setNamedItemNS(Node node) {
            throw new UnsupportedOperationException("This NamedNodeMap is readOnly");
        }
    };

    private Util() {
    }

    public static final String getPrefix(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(58);
        if (n < 0) {
            return null;
        }
        return string.substring(0, n);
    }

    public static final String getLocalName(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(58);
        if (n < 0) {
            return string;
        }
        return string.substring(n + 1);
    }

    public static String printNode(Node node) {
        StringBuffer stringBuffer = new StringBuffer();
        switch (node.getNodeType()) {
            case 10: {
                stringBuffer.append("<xml version=\"1.0\">\n");
                break;
            }
            case 9: {
                Document document = (Document)node;
                stringBuffer.append(Util.printNode(document.getDocumentElement()));
                break;
            }
            case 11: {
                NodeList nodeList = node.getChildNodes();
                int n = nodeList.getLength();
                for (int i = 0; i < n; ++i) {
                    stringBuffer.append(Util.printNode(nodeList.item(i)));
                }
                break;
            }
            case 1: {
                String string = node.getNodeName();
                stringBuffer.append("<" + string);
                NamedNodeMap namedNodeMap = node.getAttributes();
                for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                    Node node2 = namedNodeMap.item(i);
                    stringBuffer.append(" " + node2.getNodeName() + "=\"" + node2.getNodeValue() + "\"");
                }
                stringBuffer.append(">");
                NodeList nodeList = node.getChildNodes();
                if (nodeList != null) {
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        stringBuffer.append(Util.printNode(nodeList.item(i)));
                    }
                }
                stringBuffer.append("</" + string + ">");
                break;
            }
            case 8: {
                stringBuffer.append("<!--" + ((Comment)node).getData() + "-->\n");
                break;
            }
            case 3: 
            case 4: {
                stringBuffer.append(node.getNodeValue());
                break;
            }
            case 7: {
                ProcessingInstruction processingInstruction = (ProcessingInstruction)node;
                stringBuffer.append("<?" + processingInstruction.getTarget() + " " + processingInstruction.getData() + "?>");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unable to process " + node);
            }
        }
        return stringBuffer.toString();
    }
}

