/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.dom;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import weblogic.xml.dom.DOMStreamReader;
import weblogic.xml.dom.DocumentImpl;
import weblogic.xml.dom.Util;

public class XMLStreamIterator
implements Iterator {
    private static final int OPEN = 1;
    private static final int CLOSE = 2;
    private static final int VISIT = 3;
    private Node currentNode;
    private Node nextNode;
    private Node root;
    private int currenState;
    private int nextState;

    public XMLStreamIterator(Node node) {
        if (node.getNodeType() == 1) {
            this.nextNode = node;
            this.root = node;
            this.nextState = 1;
        } else {
            this.root = node;
            this.nextNode = node;
            this.nextState = 3;
        }
    }

    private void advance() {
        this.currentNode = this.nextNode;
        this.currenState = this.nextState;
        this.nextNode = this.findNext();
    }

    public Object next() {
        return this.nextNode();
    }

    public void remove() {
        this.current().getParentNode().removeChild(this.current());
        this.advance();
    }

    public Node current() {
        if (this.currentNode == null) {
            throw new NoSuchElementException("The current node is null please call next() before using accessor methods");
        }
        return this.currentNode;
    }

    public Node nextNode() {
        if (this.nextNode == null) {
            throw new NoSuchElementException("Unable to advance the node iterator");
        }
        this.advance();
        return this.current();
    }

    public boolean isOpen() {
        return this.currenState == 1;
    }

    public boolean isClosed() {
        return this.currenState == 2;
    }

    private Node findNext() {
        switch (this.currenState) {
            case 1: {
                Node node = this.currentNode.getFirstChild();
                if (node != null) {
                    this.nextState = node.getNodeType() == 1 ? 1 : 3;
                    return node;
                }
                node = this.currentNode;
                this.nextState = 2;
                return node;
            }
            case 3: {
                Node node = this.currentNode != this.root ? this.currentNode.getNextSibling() : null;
                if (node != null) {
                    this.nextState = node.getNodeType() == 1 ? 1 : 3;
                    return node;
                }
                node = this.currentNode != this.root ? this.currentNode.getParentNode() : null;
                this.nextState = 2;
                return node;
            }
            case 2: {
                Node node = this.currentNode != this.root ? this.currentNode.getNextSibling() : null;
                if (node != null) {
                    this.nextState = node.getNodeType() == 1 ? 1 : 3;
                    return node;
                }
                node = this.currentNode != this.root ? this.currentNode.getParentNode() : null;
                this.nextState = 2;
                return node;
            }
        }
        return null;
    }

    public boolean hasNext() {
        return this.nextNode != null;
    }

    public static void main(String[] stringArray) throws Exception {
        DocumentImpl documentImpl = new DocumentImpl();
        Element element = documentImpl.createElement("parent");
        documentImpl.appendChild(element);
        System.out.println("----------------[ empty root node]");
        XMLStreamIterator xMLStreamIterator = new XMLStreamIterator(element);
        while (xMLStreamIterator.hasNext()) {
            System.out.println(xMLStreamIterator.next());
        }
        DOMStreamReader dOMStreamReader = new DOMStreamReader(element);
        while (dOMStreamReader.hasNext()) {
            System.out.println(dOMStreamReader.toString());
            dOMStreamReader.next();
        }
        System.out.println("----------------[ dump]");
        element.appendChild(documentImpl.createComment(" this is a comment "));
        Element element2 = documentImpl.createElement("child1");
        element.appendChild(element2);
        Element element3 = documentImpl.createElement("text");
        element3.appendChild(documentImpl.createTextNode("sometext"));
        element.appendChild(element3);
        Element element4 = documentImpl.createElement("child2");
        element.appendChild(element4);
        element4.appendChild(documentImpl.createElement("a"));
        element4.appendChild(documentImpl.createElement("b"));
        element4.appendChild(documentImpl.createElement("c"));
        System.out.println(Util.printNode(documentImpl));
        System.out.println("----------------[ root node]");
        xMLStreamIterator = new XMLStreamIterator(element);
        while (xMLStreamIterator.hasNext()) {
            System.out.println(xMLStreamIterator.next());
        }
        System.out.println("----------------[ text node]");
        xMLStreamIterator = new XMLStreamIterator(element3);
        while (xMLStreamIterator.hasNext()) {
            System.out.println(xMLStreamIterator.next());
        }
        System.out.println("----------------[ child node]");
        xMLStreamIterator = new XMLStreamIterator(element4);
        while (xMLStreamIterator.hasNext()) {
            System.out.println(xMLStreamIterator.next());
        }
        System.out.println("----------------[ empty child node]");
        xMLStreamIterator = new XMLStreamIterator(element2);
        while (xMLStreamIterator.hasNext()) {
            System.out.println(xMLStreamIterator.next());
        }
        System.out.println("----------------[ root node]");
        dOMStreamReader = new DOMStreamReader(element);
        while (dOMStreamReader.hasNext()) {
            System.out.println(dOMStreamReader.toString());
            dOMStreamReader.next();
        }
        System.out.println("----------------[ text node]");
        dOMStreamReader = new DOMStreamReader(element3);
        while (dOMStreamReader.hasNext()) {
            System.out.println(dOMStreamReader.toString());
            dOMStreamReader.next();
        }
        System.out.println("----------------[ child node]");
        dOMStreamReader = new DOMStreamReader(element4);
        while (dOMStreamReader.hasNext()) {
            System.out.println(dOMStreamReader.toString());
            dOMStreamReader.next();
        }
        System.out.println("----------------[ empty child node]");
        dOMStreamReader = new DOMStreamReader(element2);
        while (dOMStreamReader.hasNext()) {
            System.out.println(dOMStreamReader.toString());
            dOMStreamReader.next();
        }
    }
}

