/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.dtdc;

import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Hashtable;
import java.util.Locale;
import org.xml.sax.AttributeList;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class BaseParser
implements Parser,
AttributeList,
Locator {
    protected DocumentHandler dh;
    protected int currentLine = 1;
    protected int lastLinePosition = 0;
    protected int current = 0;
    protected int end = 0;
    protected int startCharacterData = -1;
    protected Hashtable ids = new Hashtable();
    protected String[] names;
    protected String[] types;
    protected String[] values;
    protected int numAttributes = 0;
    protected Hashtable htypes = new Hashtable();
    protected Hashtable hvalues = new Hashtable();

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ " + this.getClass().getName() + ", " + "currentLine=" + this.currentLine + ", currentColumn=" + (this.current - this.lastLinePosition) + ", attributes=[");
        for (int i = 0; i < this.numAttributes; ++i) {
            stringBuffer.append(this.names[i] + "=(" + this.types[i] + ")" + this.values[i]);
            if (i == this.numAttributes - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]]");
        return stringBuffer.toString();
    }

    public int getLineNumber() {
        return this.currentLine;
    }

    public int getColumnNumber() {
        return this.current - this.lastLinePosition;
    }

    public String getPublicId() {
        return null;
    }

    public String getSystemId() {
        return null;
    }

    public void setLocale(Locale locale) {
        if (!Locale.getDefault().equals(locale)) {
            throw new Error("Operation unsupported, locale cannot differ from the default");
        }
    }

    public void setEntityResolver(EntityResolver entityResolver) {
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
    }

    public void setDocumentHandler(DocumentHandler documentHandler) {
        this.dh = documentHandler;
    }

    public void parse(String string) throws IOException, SAXException {
        this.parse(new File(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputSource inputSource) throws IOException, SAXException {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        BufferedReader bufferedReader = BaseParser.getBufferedReader(inputSource);
        try {
            int n;
            char[] cArray = new char[2048];
            while ((n = bufferedReader.read(cArray)) != -1) {
                charArrayWriter.write(cArray, 0, n);
            }
            this.parse(charArrayWriter.toCharArray());
        }
        finally {
            bufferedReader.close();
        }
    }

    public abstract void parse(char[] var1) throws SAXException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(File file) throws IOException, SAXException {
        FileReader fileReader = new FileReader(file);
        try {
            char[] cArray = new char[(int)file.length()];
            fileReader.read(cArray, 0, cArray.length);
            this.parse(cArray);
        }
        finally {
            fileReader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputStream inputStream) throws IOException, SAXException {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            int n;
            char[] cArray = new char[2048];
            while ((n = bufferedReader.read(cArray)) != -1) {
                charArrayWriter.write(cArray, 0, n);
            }
            this.parse(charArrayWriter.toCharArray());
        }
        finally {
            bufferedReader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputStream inputStream, String string) throws IOException, SAXException {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, string));
        try {
            int n;
            char[] cArray = new char[2048];
            while ((n = bufferedReader.read(cArray)) != -1) {
                charArrayWriter.write(cArray, 0, n);
            }
            this.parse(charArrayWriter.toCharArray());
        }
        finally {
            bufferedReader.close();
        }
    }

    protected final void nextLine() {
        ++this.currentLine;
        this.lastLinePosition = this.current;
    }

    protected final void eatComment(char[] cArray) throws SAXException {
        this.sendCharacters(cArray, 4);
        while (true) {
            if (cArray[this.current++] == '-' && cArray[this.current] == '-' && cArray[this.current + 1] == '>') {
                this.current += 2;
                break;
            }
            if (cArray[this.current] != '\n') continue;
            this.nextLine();
        }
        this.startCharacterData = -1;
    }

    protected final void sendCharacters(char[] cArray, int n) throws SAXException {
        if (this.startCharacterData != -1) {
            this.dh.characters(cArray, this.startCharacterData, this.current - n - this.startCharacterData);
            this.startCharacterData = -1;
        }
    }

    protected final void match(char[] cArray, String string, String string2, int n) throws SAXParseException {
        for (int i = string.length() - 1; i >= 0; --i) {
            if (cArray[this.current + i] == string.charAt(i)) continue;
            throw new SAXParseException("Could not parse " + string2 + ", starting at line " + n, this);
        }
        this.current += string.length();
    }

    protected void reset() {
        for (int i = this.numAttributes - 1; i >= 0; --i) {
            this.names[i] = null;
            this.types[i] = null;
            this.values[i] = null;
        }
        this.numAttributes = 0;
        this.htypes.clear();
        this.hvalues.clear();
    }

    public int getLength() {
        return this.numAttributes;
    }

    public String getName(int n) {
        return this.names[n];
    }

    public String getType(int n) {
        return this.types[n];
    }

    public String getValue(int n) {
        return this.values[n];
    }

    public String getType(String string) {
        return (String)this.htypes.get(string);
    }

    public String getValue(String string) {
        return (String)this.hvalues.get(string);
    }

    public String _readAttribute(char[] cArray) throws SAXException {
        char[] cArray2;
        char c;
        char c2;
        StringBuffer stringBuffer = null;
        ++this.current;
        while ((c2 = cArray[this.current++]) == ' ' || c2 == '\t' || c2 == '\n' || c2 == '\r') {
        }
        if (c2 != '\"' && c2 != '\'') {
            throw new SAXParseException("Invalid attribute", this);
        }
        int n = this.current;
        while ((c = cArray[this.current++]) != c2) {
            switch (c) {
                case '&': {
                    cArray2 = new char[this.current - n];
                    int n2 = this.current;
                    this.handleEscapes(cArray);
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer();
                    }
                    System.arraycopy(cArray, n, cArray2, 0, n2 - n);
                    stringBuffer.append(new String(cArray2));
                    n = this.current;
                    break;
                }
                case '<': {
                    if (cArray[this.current] == '!' && cArray[this.current + 1] == '[' && cArray[this.current + 2] == 'C' && cArray[this.current + 3] == 'D' && cArray[this.current + 4] == 'A' && cArray[this.current + 5] == 'T' && cArray[this.current + 6] == 'A' && cArray[this.current + 7] == '[') {
                        cArray2 = new char[this.current - n - 1];
                        if (stringBuffer == null) {
                            stringBuffer = new StringBuffer();
                        }
                        System.arraycopy(cArray, n, cArray2, 0, this.current - n - 1);
                        stringBuffer.append(new String(cArray2));
                        this.current += 8;
                        n = this.current;
                        int n3 = 0;
                        block9: while (true) {
                            switch (cArray[this.current++]) {
                                case ']': {
                                    if (cArray[this.current] == ']' && cArray[this.current + 1] == '>') {
                                        this.current += 2;
                                        n3 = this.current - 3;
                                        break block9;
                                    }
                                }
                                default: {
                                    continue block9;
                                }
                            }
                            break;
                        }
                        cArray2 = new char[n3 - n];
                        System.arraycopy(cArray, n, cArray2, 0, n3 - n);
                        stringBuffer.append(new String(cArray2));
                        n = this.current;
                        break;
                    }
                    throw new SAXParseException("Illegal character in input: <", this);
                }
            }
        }
        cArray2 = new char[this.current - n - 1];
        System.arraycopy(cArray, n, cArray2, 0, this.current - n - 1);
        String string = new String(cArray2);
        if (stringBuffer != null) {
            return stringBuffer.append(string).toString();
        }
        return string;
    }

    protected void putAttribute(String string, String string2, String string3) {
        this.hvalues.put(string, string3);
        this.names[this.numAttributes] = string;
        this.types[this.numAttributes] = string2;
        this.values[this.numAttributes++] = string3;
    }

    protected void handleEscapes(char[] cArray) throws SAXException {
        int n = this.current;
        block0 : switch (cArray[this.current]) {
            case 'l': {
                if (cArray[this.current + 1] == 't' && cArray[this.current + 2] == ';') {
                    this.compress(cArray, '<', 3);
                    break;
                }
                throw new SAXParseException("Invalid character sequence", this);
            }
            case 'g': {
                if (cArray[this.current + 1] == 't' && cArray[this.current + 2] == ';') {
                    this.compress(cArray, '>', 3);
                    break;
                }
                throw new SAXParseException("Invalid character sequence", this);
            }
            case 'q': {
                if (cArray[this.current + 1] == 'u' && cArray[this.current + 2] == 'o' && cArray[this.current + 3] == 't' && cArray[this.current + 4] == ';') {
                    this.compress(cArray, '\"', 5);
                    break;
                }
                throw new SAXParseException("Invalid character sequence", this);
            }
            case 'a': {
                switch (cArray[this.current + 1]) {
                    case 'm': {
                        if (cArray[this.current + 2] == 'p' && cArray[this.current + 3] == ';') {
                            this.compress(cArray, '&', 4);
                            break block0;
                        }
                        throw new SAXParseException("Invalid character sequence", this);
                    }
                    case 'p': {
                        if (cArray[this.current + 2] == 'o' && cArray[this.current + 3] == 's' && cArray[this.current + 4] == ';') {
                            this.compress(cArray, '\'', 5);
                            break block0;
                        }
                        throw new SAXParseException("Invalid character sequence", this);
                    }
                }
            }
        }
        if (this.startCharacterData != -1) {
            this.dh.characters(cArray, this.startCharacterData, n - this.startCharacterData);
            this.startCharacterData = this.current;
        }
    }

    protected void handleCDATA(char[] cArray) throws SAXException {
        if (this.startCharacterData != -1) {
            this.dh.characters(cArray, this.startCharacterData, this.current - 9 - this.startCharacterData);
        }
        int n = this.current;
        block3: while (true) {
            switch (cArray[this.current++]) {
                case ']': {
                    if (cArray[this.current] != ']' || cArray[this.current + 1] != '>') continue block3;
                    char[] cArray2 = new char[this.current - n - 1];
                    System.arraycopy(cArray, n, cArray2, 0, this.current - n - 1);
                    String string = new String(cArray2);
                    this.current += 2;
                    this.dh.characters(cArray, n, this.current - 3 - n);
                    this.startCharacterData = this.current;
                    return;
                }
            }
        }
    }

    private void compress(char[] cArray, char c, int n) {
        cArray[this.current - 1] = c;
        this.current += n;
    }

    private static BufferedReader getBufferedReader(InputSource inputSource) {
        Reader reader = inputSource.getCharacterStream();
        if (reader == null) {
            String string = inputSource.getSystemId();
            try {
                reader = new FileReader(string);
            }
            catch (FileNotFoundException fileNotFoundException) {
                try {
                    URL uRL = new URL(inputSource.getSystemId());
                    reader = new InputStreamReader(uRL.openStream());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (reader == null) {
            return null;
        }
        return new BufferedReader(reader, 1000);
    }
}

