/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.dtdc;

import com.ibm.xml.parser.AttDef;
import com.ibm.xml.parser.DTD;
import com.ibm.xml.parser.ElementDecl;
import com.ibm.xml.parser.InsertableElement;
import com.ibm.xml.parser.Parser;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import weblogic.utils.Getopt2;
import weblogic.utils.compiler.BadOutputException;
import weblogic.utils.compiler.CodeGenerationException;
import weblogic.utils.compiler.CodeGenerator;
import weblogic.xml.dtdc.ElementOutput;
import weblogic.xml.dtdc.NameMangler;

public class DTD2Java
extends CodeGenerator {
    private static final boolean debug = false;
    private static final boolean verbose = false;
    private static final String EOL = System.getProperty("line.separator");
    static final String PACKAGE = "package";
    private ElementOutput currentOutput;
    private Vector outputs;
    private DTD dtd;
    private String packageName;
    private AttDef currentAttribute;
    private String currentSubElement;

    public DTD2Java(Getopt2 getopt2) {
        super(getopt2);
        getopt2.addOption(PACKAGE, "weblogic.xml.objects", "Name of the base package for objects");
    }

    protected void extractOptionValues(Getopt2 getopt2) {
        this.packageName = getopt2.getOption(PACKAGE, "weblogic.xml.objects");
    }

    public Enumeration outputs(Object[] objectArray) throws Exception {
        String[] stringArray = (String[])objectArray;
        this.outputs = new Vector();
        for (int i = 0; i < stringArray.length; ++i) {
            File file = new File(new File(stringArray[i]).getAbsolutePath());
            FileInputStream fileInputStream = new FileInputStream(file);
            Parser parser2 = new Parser(file.getParentFile().toURL().toString());
            DTD dTD = parser2.readDTDStream((InputStream)fileInputStream);
            Enumeration enumeration = dTD.getElementDeclarations();
            while (enumeration.hasMoreElements()) {
                ElementDecl elementDecl = (ElementDecl)enumeration.nextElement();
                String string = elementDecl.getName();
                String string2 = this.packageName;
                string2 = string2 + NameMangler.getpackage(string);
                this.outputs.addElement(new ElementOutput(NameMangler.upcase(NameMangler.depackage(string)) + ".java", string2, "element.j", elementDecl, dTD));
            }
        }
        return this.outputs.elements();
    }

    protected void prepare(CodeGenerator.Output output) throws BadOutputException {
        this.currentOutput = (ElementOutput)output;
    }

    public ElementDecl getElement() {
        return this.currentOutput.getElementDecl();
    }

    public DTD getDTD() {
        return this.currentOutput.getDTD();
    }

    public String element_realname() {
        return this.getElement().getName();
    }

    public String element_name() {
        return NameMangler.depackage(this.getElement().getName());
    }

    public String element_class_name() {
        return NameMangler.upcase(this.element_name());
    }

    public String package_name() {
        return this.packageName;
    }

    public String is_empty() {
        return this.getElement().getContentType() == 1 ? "true" : "false";
    }

    public String attributes() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.getDTD().getAttributeDeclarations(this.getElement().getName());
        while (enumeration.hasMoreElements()) {
            this.currentAttribute = (AttDef)enumeration.nextElement();
            stringBuffer.append(this.parse(this.getProductionRule("attribute")));
        }
        return stringBuffer.toString();
    }

    public String set_attributes() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.getDTD().getAttributeDeclarations(this.getElement().getName());
        while (enumeration.hasMoreElements()) {
            this.currentAttribute = (AttDef)enumeration.nextElement();
            stringBuffer.append(this.parse(this.getProductionRule("set_attribute")));
        }
        return stringBuffer.toString();
    }

    public String attribute_realname() {
        return this.currentAttribute.getName();
    }

    public String attribute_name() {
        return NameMangler.depackage(this.currentAttribute.getName());
    }

    public String attribute_varname() {
        return (this.attribute_name() + "Value").replace(':', '_').replace('-', '_');
    }

    public String attribute_default() {
        int n = this.currentAttribute.getDefaultType();
        if (n == 1 || n == -1) {
            return this.currentAttribute.getDefaultStringValue();
        }
        return "";
    }

    public String attribute_value_getter() {
        return "get" + NameMangler.upcase(this.attribute_name()) + "Attribute";
    }

    public String attribute_value_setter() {
        return "set" + NameMangler.upcase(this.attribute_name()) + "Attribute";
    }

    public String subelements() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        Hashtable hashtable = this.getDTD().prepareTable(this.getElement().getName());
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            InsertableElement insertableElement = (InsertableElement)hashtable.get(enumeration.nextElement());
            if (this.getDTD().getElementDeclaration(insertableElement.name) == null) continue;
            this.currentSubElement = NameMangler.depackage(insertableElement.name);
            stringBuffer.append(this.parse(this.getProductionRule("subelement")));
        }
        return stringBuffer.toString();
    }

    public String sub_element_name() {
        return NameMangler.depackage(this.currentSubElement);
    }

    public String sub_element_varname() {
        return this.sub_element_name() + "SubElements";
    }

    public String sub_elements_getter() {
        return this.sub_element_getter() + "s";
    }

    public String sub_element_class_name() {
        return NameMangler.upcase(this.sub_element_name());
    }

    public String sub_element_getter() {
        return "get" + NameMangler.upcase(this.sub_element_name()) + "Element";
    }

    public String sub_element_adder() {
        return "add" + NameMangler.upcase(this.sub_element_name()) + "Element";
    }
}

