/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.dtdc;

import com.ibm.xml.parser.AttDef;
import com.ibm.xml.parser.DTD;
import com.ibm.xml.parser.ElementDecl;
import com.ibm.xml.parser.InsertableElement;
import com.ibm.xml.parser.Parser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;
import weblogic.utils.Getopt2;
import weblogic.utils.compiler.BadOutputException;
import weblogic.utils.compiler.CodeGenerationException;
import weblogic.utils.compiler.CodeGenerator;
import weblogic.xml.dtdc.NameMangler;
import weblogic.xml.dtdc.ParserOutput;

public class DTD2Parser
extends CodeGenerator {
    private static final boolean debug = false;
    private static final boolean verbose = false;
    private static final String EOL = System.getProperty("line.separator");
    private static final String ROOT = "root";
    private ParserOutput currentOutput;
    private Vector outputs;
    private DTD dtd;
    private String root;
    private String packageName;
    private ElementDecl element;
    SortedMap allAttributes = this.createTreeMap();
    AttDef currentAttribute;
    private static int depth = 0;
    private boolean writingAttribute = false;

    public DTD2Parser(Getopt2 getopt2) {
        super(getopt2);
        getopt2.addOption("package", "weblogic.xml.parsers", "Name of the base package for objects");
        getopt2.addOption(ROOT, "xsl:stylesheet", "Root element of the DTD");
    }

    protected void extractOptionValues(Getopt2 getopt2) {
        this.packageName = getopt2.getOption("package", "weblogic.xml.objects");
        this.root = getopt2.getOption(ROOT);
    }

    public Enumeration outputs(Object[] objectArray) throws Exception {
        String[] stringArray = (String[])objectArray;
        this.outputs = new Vector();
        for (int i = 0; i < stringArray.length; ++i) {
            File file = new File(new File(stringArray[i]).getAbsolutePath());
            FileInputStream fileInputStream = new FileInputStream(file);
            Parser parser2 = new Parser(file.getParentFile().toURL().toString());
            DTD dTD = parser2.readDTDStream((InputStream)fileInputStream);
            if (this.root == null) {
                String string = file.getName();
                this.root = string.substring(0, string.lastIndexOf("."));
            }
            this.outputs.addElement(new ParserOutput(NameMangler.upcase(NameMangler.depackage(this.root)) + "Parser.java", this.packageName, "parser.j", dTD, this.root));
        }
        return this.outputs.elements();
    }

    protected void prepare(CodeGenerator.Output output) throws BadOutputException {
        this.currentOutput = (ParserOutput)output;
    }

    public DTD getDTD() {
        return this.currentOutput.getDTD();
    }

    public String package_name() {
        return this.packageName;
    }

    public String element_class_name() {
        return NameMangler.upcase(NameMangler.depackage(this.root));
    }

    public String parser_class_name() {
        return this.element_class_name() + "Parser";
    }

    public String parser() {
        TreeMap treeMap = this.createTreeMap();
        treeMap.put("<?xml", "// Ignore XML version\nwhile(chars[current++] != '>');");
        treeMap.put("<!DOCTYPE", "// Ignore DTD specification\nwhile(chars[current++] != '>');");
        treeMap.put(" ", "// Ignore whitespace");
        treeMap.put("\t", "// Ignore whitespace");
        treeMap.put("\r", "// Ignore whitespace");
        treeMap.put("\n", "nextLine();");
        treeMap.put("<!--", "eatComment(chars);");
        depth = 0;
        this.element = this.getDTD().getElementDeclaration(this.root);
        if (this.element == null) {
            throw new Error("No element <" + this.root + "> found in DTD");
        }
        treeMap.put("<" + this.root, this.readElement());
        depth = 3;
        this.writingAttribute = false;
        return this.match(treeMap, "chars[current++]", true);
    }

    public String readElement() {
        StringBuffer stringBuffer = new StringBuffer();
        DTD2Parser.format(stringBuffer, "sendCharacters(chars, " + (this.element.getName().length() + 1) + ");");
        DTD2Parser.format(stringBuffer, "read" + NameMangler.upcase(NameMangler.depackage(this.element.getName())) + "(chars);");
        return stringBuffer.toString();
    }

    public String element_name() {
        return this.element.getName();
    }

    public String attribute_name() {
        return NameMangler.depackage(this.currentAttribute.getName()) + "Value";
    }

    public String attribute_realname() {
        return this.currentAttribute.getName();
    }

    public String attribute_typename() {
        return NameMangler.depackage(this.currentAttribute.getName()) + "Type";
    }

    public String attribute_type() {
        return AttDef.S_TYPESTR[this.currentAttribute.getDeclaredType()];
    }

    public String read_element_declarations() throws CodeGenerationException {
        Enumeration enumeration = this.getDTD().getElementDeclarations();
        StringBuffer stringBuffer = new StringBuffer();
        depth = 2;
        while (enumeration.hasMoreElements()) {
            this.element = (ElementDecl)enumeration.nextElement();
            stringBuffer.append(this.parse(this.getProductionRule("read_element_declaration")));
        }
        return stringBuffer.toString();
    }

    public String read_element_method_name() {
        return "read" + NameMangler.upcase(NameMangler.depackage(this.element.getName()));
    }

    public String read_element_attributes_method_name() {
        return "read" + NameMangler.upcase(NameMangler.depackage(this.element.getName())) + "Attributes";
    }

    public void readAttributes(StringBuffer stringBuffer) {
        DTD2Parser.format(stringBuffer, "read" + NameMangler.upcase(NameMangler.depackage(this.element.getName())) + "Attributes(chars);");
    }

    public String declare_required_attributes() {
        Enumeration enumeration = this.getDTD().getAttributeDeclarations(this.element.getName());
        StringBuffer stringBuffer = new StringBuffer();
        depth = 1;
        while (enumeration.hasMoreElements()) {
            AttDef attDef = (AttDef)enumeration.nextElement();
            if (attDef.getDefaultType() != 2) continue;
            DTD2Parser.format(stringBuffer, "boolean " + NameMangler.depackage(attDef.getName()) + "Found = false;");
        }
        return stringBuffer.toString();
    }

    public String required_flag() {
        return NameMangler.depackage(this.currentAttribute.getName()) + "Found";
    }

    public String set_defaults() {
        return "";
    }

    public String set_attribute_found() {
        if (this.currentAttribute.getDefaultType() == 2) {
            return this.required_flag() + " = true;";
        }
        return "// not required";
    }

    public String ensure_unique() {
        if (this.currentAttribute.getDeclaredType() == 2) {
            return "if(ids.put(value, this) != null) throw new SAXParseException(\"Duplicate ID found: \" + value, this);";
        }
        return "// not an id";
    }

    public String ensure_required_attributes() {
        Enumeration enumeration = this.getDTD().getAttributeDeclarations(this.element.getName());
        StringBuffer stringBuffer = new StringBuffer();
        depth = 2;
        while (enumeration.hasMoreElements()) {
            AttDef attDef = (AttDef)enumeration.nextElement();
            if (attDef.getDefaultType() != 2) continue;
            DTD2Parser.format(stringBuffer, "if(!" + NameMangler.depackage(attDef.getName()) + "Found) throw new SAXParseException(\"Required attribute " + attDef.getName() + " not found\", this);");
        }
        return stringBuffer.toString();
    }

    public String read_attributes() throws CodeGenerationException {
        Enumeration enumeration = this.getDTD().getAttributeDeclarations(this.element.getName());
        TreeMap treeMap = this.createTreeMap();
        treeMap.put(" ", "// Ignore whitespace");
        treeMap.put("\t", "// Ignore whitespace");
        treeMap.put("\r", "// Ignore whitespace");
        treeMap.put("\n", "// Next line\ncurrentLine++;\nlastLinePosition=current;");
        treeMap.put("/>", "// Done\nemptyTag=true;done=true;");
        treeMap.put(">", "// Done\ndone = true;");
        depth = 0;
        while (enumeration.hasMoreElements()) {
            this.currentAttribute = (AttDef)enumeration.nextElement();
            this.allAttributes.put(this.currentAttribute.getName(), this.currentAttribute);
            treeMap.put(this.currentAttribute.getName(), this.parse(this.getProductionRule("readAttribute")));
        }
        depth = 2;
        this.writingAttribute = true;
        return this.match(treeMap, "chars[current++]", false);
    }

    public String read_element() {
        if (this.element.getContentType() == 1) {
            return "done = true;";
        }
        ElementDecl elementDecl = this.element;
        TreeMap treeMap = this.createTreeMap();
        treeMap.put(" ", "// Ignore whitespace");
        treeMap.put("\t", "// Ignore whitespace");
        treeMap.put("\r", "// Ignore whitespace");
        treeMap.put("\n", "nextLine();");
        treeMap.put("</" + this.element.getName() + ">", "sendCharacters(chars, " + (this.element.getName().length() + 3) + ");\n" + "done = true;");
        treeMap.put("&", "handleEscapes(chars);");
        treeMap.put("<![CDATA[", "handleCDATA(chars);");
        treeMap.put("<!--", "eatComment(chars);");
        Hashtable hashtable = this.getDTD().prepareTable(this.element.getName());
        Enumeration enumeration = hashtable.keys();
        depth = 0;
        while (enumeration.hasMoreElements()) {
            InsertableElement insertableElement = (InsertableElement)hashtable.get(enumeration.nextElement());
            this.element = this.getDTD().getElementDeclaration(insertableElement.name);
            if (this.element == null) continue;
            treeMap.put("<" + insertableElement.name, this.readElement());
        }
        depth = 2;
        this.element = elementDecl;
        this.writingAttribute = false;
        return this.match(treeMap, "chars[current++]", false);
    }

    public String max_attributes() {
        return "" + this.allAttributes.size();
    }

    public String set_attribute_types() {
        depth = 2;
        Iterator iterator = this.allAttributes.keySet().iterator();
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            AttDef attDef = (AttDef)this.allAttributes.get(iterator.next());
            DTD2Parser.format(stringBuffer, "htypes.put(\"" + attDef.getName() + "\", \"" + AttDef.S_TYPESTR[attDef.getDeclaredType()] + "\");");
        }
        return stringBuffer.toString();
    }

    public String valid_attribute() {
        if (this.currentAttribute.getDeclaredType() == 10) {
            StringBuffer stringBuffer = new StringBuffer();
            Enumeration enumeration = this.currentAttribute.elements();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                stringBuffer.append(" && !value.equals(\"" + string + "\")");
            }
            return stringBuffer.toString();
        }
        if (this.currentAttribute.getDefaultType() == 1) {
            return "&& !value.equals(\"" + this.currentAttribute.getDefaultStringValue() + "\")";
        }
        return "&& false";
    }

    private static StringBuffer format(StringBuffer stringBuffer, String string) {
        for (int i = depth; i > 0; --i) {
            stringBuffer.append("  ");
        }
        return stringBuffer.append(string).append(EOL);
    }

    private static StringBuffer format(StringBuffer stringBuffer, String string, boolean bl) {
        if (bl) {
            try {
                String string2;
                BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
                while ((string2 = bufferedReader.readLine()) != null) {
                    DTD2Parser.format(stringBuffer, string2);
                }
            }
            catch (IOException iOException) {}
        } else {
            DTD2Parser.format(stringBuffer, string);
        }
        return stringBuffer;
    }

    private String match(SortedMap sortedMap, String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        this.makeSwitch(stringBuffer, sortedMap, sortedMap, 0, string, null, bl);
        return stringBuffer.toString();
    }

    private SortedMap makeTreeAtCurrentLookahead(Iterator iterator, SortedMap sortedMap, int n) {
        String string = null;
        if (n == 0) {
            return sortedMap;
        }
        TreeMap treeMap = this.createTreeMap();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (string == null) {
                treeMap.put(string2, sortedMap.get(string2));
                string = string2;
                continue;
            }
            if (string2.length() >= n && string.length() >= n && string2.charAt(n - 1) == string.charAt(n - 1)) {
                treeMap.put(string2, sortedMap.get(string2));
                continue;
            }
            return treeMap;
        }
        return treeMap;
    }

    private void makeSwitch(StringBuffer stringBuffer, SortedMap sortedMap, SortedMap sortedMap2, int n, String string, String string2, boolean bl) {
        DTD2Parser.format(stringBuffer, "switch(" + string + ") {");
        Iterator iterator = sortedMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            SortedMap sortedMap3 = sortedMap.tailMap(string3);
            int n2 = this.makeCase(stringBuffer, sortedMap3, sortedMap2, n, string, bl);
            while (--n2 > 0) {
                iterator.next();
            }
        }
        this.makeDefault(stringBuffer, n, string2, bl);
    }

    private void makeDefault(StringBuffer stringBuffer, int n, String string, boolean bl) {
        DTD2Parser.format(stringBuffer, "default:");
        ++depth;
        if (this.writingAttribute || n != 0) {
            if (!bl && string != null && string.charAt(0) == '<') {
                DTD2Parser.format(stringBuffer, "current -= 2; sendCharacters(chars, 0); done = true; continue;");
            } else {
                DTD2Parser.format(stringBuffer, "throw new SAXParseException(\"Could not parse: " + this.element.getName() + " starting at line \" + startLine, this);");
            }
        } else {
            DTD2Parser.format(stringBuffer, "if(startCharacterData == -1) startCharacterData = current - 1;");
        }
        --depth;
        DTD2Parser.format(stringBuffer, "}");
    }

    private int makeCase(StringBuffer stringBuffer, SortedMap sortedMap, SortedMap sortedMap2, int n, String string, boolean bl) {
        String string2 = (String)sortedMap.firstKey();
        SortedMap sortedMap3 = this.makeTreeAtCurrentLookahead(sortedMap.keySet().iterator(), sortedMap2, n + 1);
        if (string2.length() == n) {
            sortedMap3.remove(string2);
            DTD2Parser.format(stringBuffer, "case '\\t': case ' ': case '\\r': case '\\n':");
            if (this.writingAttribute) {
                DTD2Parser.format(stringBuffer, "case '=':");
            } else {
                DTD2Parser.format(stringBuffer, "case '>':");
            }
            ++depth;
            DTD2Parser.format(stringBuffer, "current--;");
            DTD2Parser.format(stringBuffer, sortedMap2.get(string2).toString(), true);
            DTD2Parser.format(stringBuffer, "continue;");
        } else {
            String string3;
            char c = string2.charAt(n);
            switch (c) {
                case '\t': {
                    string3 = "\\t";
                    break;
                }
                case '\r': {
                    string3 = "\\r";
                    break;
                }
                case '\n': {
                    string3 = "\\n";
                    break;
                }
                default: {
                    string3 = new Character(c).toString();
                }
            }
            DTD2Parser.format(stringBuffer, "case '" + string3 + "':");
            ++depth;
            if (sortedMap3.size() != 1) {
                this.makeSwitch(stringBuffer, sortedMap3, sortedMap2, n + 1, string, string3, bl);
            } else {
                if (string3.charAt(0) == '/') {
                    DTD2Parser.format(stringBuffer, "try {");
                    ++depth;
                }
                if (string2.length() != n + 1) {
                    StringBuffer stringBuffer2 = new StringBuffer();
                    stringBuffer2.append("match(chars, \"");
                    for (int i = 0; i < string2.length() - n - 1; ++i) {
                        stringBuffer2.append(string2.charAt(i + n + 1));
                    }
                    stringBuffer2.append("\", \"" + this.element.getName() + "\", startLine);");
                    DTD2Parser.format(stringBuffer, stringBuffer2.toString());
                }
                DTD2Parser.format(stringBuffer, sortedMap2.get(string2).toString(), true);
                if (string3.charAt(0) == '/') {
                    --depth;
                    DTD2Parser.format(stringBuffer, "} catch(Exception e) { current -= 2; sendCharacters(chars, 0); done = true; continue; }");
                }
                DTD2Parser.format(stringBuffer, "continue;");
            }
        }
        --depth;
        return sortedMap3.size();
    }

    public TreeMap createTreeMap() {
        TreeMap treeMap = new TreeMap(new Comparator(){

            public int compare(Object object, Object object2) {
                String string = (String)object;
                String string2 = (String)object2;
                return string.compareTo(string2);
            }
        });
        return treeMap;
    }
}

