/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.dtdc;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Stack;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.ParserFactory;
import weblogic.xml.dtdc.GeneratedElement;
import weblogic.xml.dtdc.NameMangler;

public class Handler
implements DocumentHandler {
    private Stack stack = new Stack();
    private Object topLevel;
    private boolean verbose;
    private String packageName = "weblogic.xml.objects";
    private Map map;
    private ClassLoader loader = this.getClass().getClassLoader();

    public static void main(String[] stringArray) throws Exception {
        try {
            Handler handler = new Handler();
            Parser parser2 = ParserFactory.makeParser("com.ibm.xml.parser.SAXDriver");
            parser2.setDocumentHandler(handler);
            parser2.parse(stringArray[0]);
        }
        catch (SAXParseException sAXParseException) {
            System.out.println("** Parsing error, line " + sAXParseException.getLineNumber() + ", column " + sAXParseException.getColumnNumber() + ", uri " + sAXParseException.getSystemId());
            System.out.println("   " + sAXParseException.getMessage());
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            exception.printStackTrace();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public Handler() {
    }

    public Handler(boolean bl) {
        this.verbose = bl;
    }

    public Handler(String string, boolean bl) {
        this(bl);
        this.packageName = string;
    }

    public Handler(Map map, String string, boolean bl) {
        this(string, bl);
        this.map = map;
    }

    public void setPackageName(String string) {
        this.packageName = string;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.loader = classLoader;
    }

    public Object getTopLevel() {
        return this.topLevel;
    }

    public void setDocumentLocator(Locator locator) {
        if (this.verbose) {
            System.out.println("setDocumentLocator: " + locator);
        }
    }

    public void startDocument() throws SAXException {
        if (this.verbose) {
            System.out.println("startDocument");
        }
    }

    public void endDocument() throws SAXException {
        if (this.verbose) {
            System.out.println("endDocument");
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        if (this.verbose) {
            System.out.println("ignorableWhitespace: " + n2);
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        Object object;
        if (this.verbose) {
            System.out.println("characters: [");
            object = new char[n2];
            System.arraycopy(cArray, n, object, 0, n2);
            System.out.print((char[])object);
            System.out.println("]");
        }
        object = (NameValuePair)this.stack.peek();
        char[] cArray2 = new char[n2];
        System.arraycopy(cArray, n, cArray2, 0, n2);
        try {
            Method method = ((NameValuePair)object).value.getClass().getMethod("addDataElement", String.class);
            method.invoke(((NameValuePair)object).value, new String(cArray2));
        }
        catch (Exception exception) {
            throw new SAXException("Could not add data to element: " + ((NameValuePair)object).value + " because " + ((InvocationTargetException)exception).getTargetException());
        }
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        if (this.verbose) {
            System.out.println("processingInstruction: " + string + " <- " + string2);
        }
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        try {
            String string2 = this.packageName + NameMangler.getpackage(string);
            String string3 = this.map == null || this.map.get(string) == null ? string2 + "." + NameMangler.upcase(NameMangler.depackage(string)) : (String)this.map.get(string);
            GeneratedElement generatedElement = this.loader == null ? (GeneratedElement)Class.forName(string3).newInstance() : (GeneratedElement)this.loader.loadClass(string3).newInstance();
            generatedElement.initialize(string, attributeList);
            this.stack.push(new NameValuePair(string, generatedElement));
            if (this.verbose) {
                System.out.println("startElement: " + string + " -> " + attributeList);
            }
        }
        catch (Exception exception) {
            if (this.verbose) {
                exception.printStackTrace();
            }
            throw new SAXException(exception);
        }
    }

    public void endElement(String string) throws SAXException {
        if (this.verbose) {
            System.out.println("endElement: " + string);
        }
        NameValuePair nameValuePair = (NameValuePair)this.stack.pop();
        if (this.stack.empty()) {
            this.topLevel = nameValuePair.value;
            return;
        }
        String string2 = "add" + NameMangler.upcase(NameMangler.depackage(string)) + "Element";
        NameValuePair nameValuePair2 = (NameValuePair)this.stack.peek();
        try {
            Method method = this.loader == null ? nameValuePair2.value.getClass().getMethod(string2, Class.forName(this.packageName + "." + NameMangler.upcase(NameMangler.depackage(nameValuePair.name)))) : nameValuePair2.value.getClass().getMethod(string2, this.loader.loadClass(this.packageName + "." + NameMangler.upcase(NameMangler.depackage(nameValuePair.name))));
            method.invoke(nameValuePair2.value, nameValuePair.value);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (this.verbose) {
                throwable.printStackTrace();
            }
            if (throwable instanceof Exception) {
                throw new SAXException((Exception)throwable);
            }
            throw (Error)throwable;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new SAXException("Could not find " + string2 + "(" + nameValuePair.value.getClass() + ") in " + nameValuePair2.name);
        }
        catch (Exception exception) {
            if (this.verbose) {
                exception.printStackTrace();
            }
            throw new SAXException(exception);
        }
    }

    private static class NameValuePair {
        String name;
        Object value;

        NameValuePair(String string, Object object) {
            this.name = string;
            this.value = object;
        }
    }
}

