/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.dtdc;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import weblogic.xml.dtdc.DataElement;
import weblogic.xml.dtdc.GeneratedElement;

public abstract class XmlElement
implements GeneratedElement {
    protected List dataElements = new ArrayList();
    protected Map attributeValues = new HashMap();
    protected List subElements = new ArrayList();

    public List getDataElements() {
        return this.dataElements;
    }

    public XmlElement _addDataElement(String string) {
        DataElement dataElement = new DataElement(string);
        this.getDataElements().add(dataElement);
        this.getSubElements().add(dataElement);
        return this;
    }

    public Map getAttributeValues() {
        return this.attributeValues;
    }

    public void toXML(PrintWriter printWriter) throws IOException {
        this.toXML(printWriter, 0);
    }

    public void toXML(PrintWriter printWriter, int n) throws IOException {
        Object object;
        Object object22;
        for (int i = n; i > 0; --i) {
            printWriter.print("  ");
        }
        printWriter.print("<" + this.getElementName());
        for (Object object22 : this.getAttributeValues().keySet()) {
            object = (String)this.attributeValues.get(object22);
            if (object == null) continue;
            if (((String)(object = this.convert((String)object))).indexOf("\"") != -1) {
                printWriter.print(" " + (String)object22 + "='" + this.convert((String)object) + "'");
                continue;
            }
            printWriter.print(" " + (String)object22 + "=\"" + this.convert((String)object) + "\"");
        }
        if (this.isEmpty()) {
            printWriter.println("/>");
            return;
        }
        printWriter.println(">");
        object22 = this.getSubElements().iterator();
        while (object22.hasNext()) {
            object = (GeneratedElement)object22.next();
            object.toXML(printWriter, n + 1);
            if (object22.hasNext() || !(object instanceof DataElement)) continue;
            printWriter.println();
        }
        for (int i = n; i > 0; --i) {
            printWriter.print("  ");
        }
        printWriter.println("</" + this.getElementName() + ">");
    }

    protected String convert(String string) {
        return string;
    }

    public List getSubElements() {
        return this.subElements;
    }

    public abstract boolean isEmpty();

    public boolean equals(Object object) {
        if (object instanceof XmlElement) {
            XmlElement xmlElement = (XmlElement)object;
            if (!xmlElement.getElementName().equals(this.getElementName())) {
                return false;
            }
            Iterator iterator = this.getAttributeValues().keySet().iterator();
            Iterator iterator2 = xmlElement.getAttributeValues().keySet().iterator();
            while (iterator.hasNext() && iterator2.hasNext()) {
                Object k;
                Object k2 = iterator.next();
                if (!k2.equals(k = iterator2.next())) {
                    return false;
                }
                if (this.getAttributeValues().get(k2).equals(this.getAttributeValues().get(k))) continue;
                return false;
            }
            if (iterator.hasNext() != iterator2.hasNext()) {
                return false;
            }
            Iterator iterator3 = this.getSubElements().iterator();
            Iterator iterator4 = xmlElement.getSubElements().iterator();
            while (iterator3.hasNext() && iterator4.hasNext()) {
                if (iterator3.next().equals(iterator4.next())) continue;
                return false;
            }
            return iterator3.hasNext() == iterator4.hasNext();
        }
        return false;
    }
}

