/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.jaxp;

import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Parser;
import weblogic.xml.XMLLogger;
import weblogic.xml.jaxp.WebLogicSAXParserFactory;
import weblogic.xml.jaxp.XMLContext;
import weblogic.xml.registry.RegistryEntityResolver;
import weblogic.xml.registry.XMLRegistryException;
import weblogic.xml.sax.XMLInputSource;
import weblogic.xml.util.Debug;

class ParserCreationHelper {
    static Debug.DebugFacility dbg = XMLContext.dbg;
    private XMLInputSource inputSource;
    private RegistryEntityResolver registry;

    public ParserCreationHelper(RegistryEntityResolver registryEntityResolver) {
        this.registry = registryEntityResolver;
    }

    public SAXParserFactory getCustomSAXParserFactory(XMLInputSource xMLInputSource) {
        String string = xMLInputSource.getPublicIdInternal();
        String string2 = xMLInputSource.getDoctypeSystemIdInternal();
        String string3 = xMLInputSource.getRootTagInternal();
        this.inputSource = xMLInputSource;
        SAXParserFactory sAXParserFactory = null;
        try {
            sAXParserFactory = this.registry.getSAXParserFactory(string, string2, string3);
        }
        catch (XMLRegistryException xMLRegistryException) {
            XMLLogger.logXMLRegistryException((String)xMLRegistryException.getMessage());
        }
        return sAXParserFactory;
    }

    public SAXParserFactory getDefaultSAXParserFactory() {
        SAXParserFactory sAXParserFactory = null;
        try {
            sAXParserFactory = this.registry.getSAXParserFactory();
        }
        catch (XMLRegistryException xMLRegistryException) {
            XMLLogger.logXMLRegistryException((String)xMLRegistryException.getMessage());
        }
        if (sAXParserFactory == null) {
            sAXParserFactory = new WebLogicSAXParserFactory();
            dbg.println(2, "Could not get SAXParserFactory from the registry. Instantiating WebLogicSAXParserFactory");
        }
        return sAXParserFactory;
    }

    public Parser getCustomParser(XMLInputSource xMLInputSource) {
        String string = xMLInputSource.getPublicIdInternal();
        String string2 = xMLInputSource.getDoctypeSystemIdInternal();
        String string3 = xMLInputSource.getRootTagInternal();
        this.inputSource = xMLInputSource;
        Parser parser2 = null;
        try {
            parser2 = this.registry.getParser(string, string2, string3);
        }
        catch (XMLRegistryException xMLRegistryException) {
            if (dbg.areDebuggingAt(2)) {
                xMLRegistryException.printStackTrace();
            }
            XMLLogger.logXMLRegistryException((String)xMLRegistryException.getMessage());
        }
        return parser2;
    }
}

