/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.jaxp;

import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import weblogic.xml.jaxp.ReParsingEventQueue;

public class ReParsingContentHandler
implements ContentHandler,
ReParsingEventQueue.EventHandler {
    private ReParsingEventQueue queue = null;
    private ContentHandler contentHandler = null;
    private static final int CHARACTERS = 1;
    private static final int END_DOCUMENT = 2;
    private static final int END_ELEMENT = 3;
    private static final int END_PREFIX_MAPPING = 4;
    private static final int IGNORABLE_WHITESPACE = 5;
    private static final int PROCESSING_INSTRUCTION = 6;
    private static final int SET_DOCUMENT_LOCATOR = 7;
    private static final int SKIPPED_ENTITY = 8;
    private static final int START_DOCUMENT = 9;
    private static final int START_ELEMENT = 10;
    private static final int START_PREFIX_MAPPING = 11;

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.contentHandler != null) {
            EventInfo eventInfo = new EventInfo();
            eventInfo.ch = cArray;
            eventInfo.start = n;
            eventInfo.length = n2;
            this.queue.addEvent(eventInfo, this, 1);
        }
    }

    public void endDocument() throws SAXException {
        if (this.contentHandler != null) {
            EventInfo eventInfo = new EventInfo();
            this.queue.addEvent(eventInfo, this, 2);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.contentHandler != null) {
            EventInfo eventInfo = new EventInfo();
            eventInfo.uri = string;
            eventInfo.localName = string2;
            eventInfo.qName = string3;
            this.queue.addEvent(eventInfo, this, 3);
        }
    }

    public void endPrefixMapping(String string) throws SAXException {
        if (this.contentHandler != null) {
            EventInfo eventInfo = new EventInfo();
            eventInfo.prefix = string;
            this.queue.addEvent(eventInfo, this, 4);
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        if (this.contentHandler != null) {
            EventInfo eventInfo = new EventInfo();
            eventInfo.ch = cArray;
            eventInfo.start = n;
            eventInfo.length = n2;
            this.queue.addEvent(eventInfo, this, 5);
        }
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        if (this.contentHandler != null) {
            EventInfo eventInfo = new EventInfo();
            eventInfo.target = string;
            eventInfo.data = string2;
            this.queue.addEvent(eventInfo, this, 6);
        }
    }

    public void setDocumentLocator(Locator locator) {
        if (this.contentHandler != null) {
            EventInfo eventInfo = new EventInfo();
            eventInfo.locator = locator;
            this.queue.addEvent(eventInfo, this, 7);
        }
    }

    public void skippedEntity(String string) throws SAXException {
        if (this.contentHandler != null) {
            EventInfo eventInfo = new EventInfo();
            eventInfo.name = string;
            this.queue.addEvent(eventInfo, this, 8);
        }
    }

    public void startDocument() throws SAXException {
        if (this.contentHandler != null) {
            EventInfo eventInfo = new EventInfo();
            this.queue.addEvent(eventInfo, this, 9);
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.contentHandler != null) {
            EventInfo eventInfo = new EventInfo();
            eventInfo.uri = string;
            eventInfo.localName = string2;
            eventInfo.qName = string3;
            eventInfo.atts = attributes;
            this.queue.addEvent(eventInfo, this, 10);
        }
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        if (this.contentHandler != null) {
            EventInfo eventInfo = new EventInfo();
            eventInfo.prefix = string;
            eventInfo.uri = string2;
            this.queue.addEvent(eventInfo, this, 11);
        }
    }

    public void registerQueue(ReParsingEventQueue reParsingEventQueue) {
        this.queue = reParsingEventQueue;
    }

    public void sendEvent(ReParsingEventQueue.EventInfo eventInfo) throws SAXException {
        EventInfo eventInfo2 = (EventInfo)eventInfo;
        int n = eventInfo2.type;
        switch (n) {
            case 1: {
                this.contentHandler.characters(eventInfo2.ch, eventInfo2.start, eventInfo2.length);
                break;
            }
            case 2: {
                this.contentHandler.endDocument();
                break;
            }
            case 3: {
                this.contentHandler.endElement(eventInfo2.uri, eventInfo2.localName, eventInfo2.qName);
                break;
            }
            case 4: {
                this.contentHandler.endPrefixMapping(eventInfo2.prefix);
                break;
            }
            case 5: {
                this.contentHandler.ignorableWhitespace(eventInfo2.ch, eventInfo2.start, eventInfo2.length);
                break;
            }
            case 6: {
                this.contentHandler.processingInstruction(eventInfo2.target, eventInfo2.data);
                break;
            }
            case 7: {
                this.contentHandler.setDocumentLocator(eventInfo2.locator);
                break;
            }
            case 8: {
                this.contentHandler.skippedEntity(eventInfo2.name);
                break;
            }
            case 9: {
                this.contentHandler.startDocument();
                break;
            }
            case 10: {
                this.contentHandler.startElement(eventInfo2.uri, eventInfo2.localName, eventInfo2.qName, eventInfo2.atts);
                break;
            }
            case 11: {
                this.contentHandler.startPrefixMapping(eventInfo2.prefix, eventInfo2.uri);
            }
        }
    }

    private class EventInfo
    extends ReParsingEventQueue.EventInfo {
        public char[] ch;
        public int start;
        public int length;
        public String uri;
        public String localName;
        public String qName;
        public String prefix;
        public String target;
        public String data;
        public Locator locator;
        public String name;
        public Attributes atts;

        private EventInfo() {
        }
    }
}

