/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.jaxp;

import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import weblogic.xml.jaxp.ReParsingEventQueue;

public class ReParsingDocumentHandler
implements DocumentHandler,
ReParsingEventQueue.EventHandler {
    private ReParsingEventQueue queue = null;
    private DocumentHandler documentHandler = null;
    private static final int CHARACTERS = 1;
    private static final int END_DOCUMENT = 2;
    private static final int END_ELEMENT = 3;
    private static final int IGNORABLE_WHITESPACE = 5;
    private static final int PROCESSING_INSTRUCTION = 6;
    private static final int SET_DOCUMENT_LOCATOR = 7;
    private static final int START_DOCUMENT = 9;
    private static final int START_ELEMENT = 10;

    public void setDocumentHandler(DocumentHandler documentHandler) {
        this.documentHandler = documentHandler;
    }

    public DocumentHandler getDocumentHandler() {
        return this.documentHandler;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.documentHandler != null) {
            EventInfo eventInfo = new EventInfo();
            eventInfo.ch = cArray;
            eventInfo.start = n;
            eventInfo.length = n2;
            this.queue.addEvent(eventInfo, this, 1);
        }
    }

    public void endDocument() throws SAXException {
        if (this.documentHandler != null) {
            EventInfo eventInfo = new EventInfo();
            this.queue.addEvent(eventInfo, this, 2);
        }
    }

    public void endElement(String string) throws SAXException {
        if (this.documentHandler != null) {
            EventInfo eventInfo = new EventInfo();
            eventInfo.name = string;
            this.queue.addEvent(eventInfo, this, 3);
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        if (this.documentHandler != null) {
            EventInfo eventInfo = new EventInfo();
            eventInfo.ch = cArray;
            eventInfo.start = n;
            eventInfo.length = n2;
            this.queue.addEvent(eventInfo, this, 5);
        }
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        if (this.documentHandler != null) {
            EventInfo eventInfo = new EventInfo();
            eventInfo.target = string;
            eventInfo.data = string2;
            this.queue.addEvent(eventInfo, this, 6);
        }
    }

    public void setDocumentLocator(Locator locator) {
        if (this.documentHandler != null) {
            EventInfo eventInfo = new EventInfo();
            eventInfo.locator = locator;
            this.queue.addEvent(eventInfo, this, 7);
        }
    }

    public void startDocument() throws SAXException {
        if (this.documentHandler != null) {
            EventInfo eventInfo = new EventInfo();
            this.queue.addEvent(eventInfo, this, 9);
        }
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        if (this.documentHandler != null) {
            EventInfo eventInfo = new EventInfo();
            eventInfo.name = string;
            eventInfo.atts = attributeList;
            this.queue.addEvent(eventInfo, this, 10);
        }
    }

    public void registerQueue(ReParsingEventQueue reParsingEventQueue) {
        this.queue = reParsingEventQueue;
    }

    public void sendEvent(ReParsingEventQueue.EventInfo eventInfo) throws SAXException {
        EventInfo eventInfo2 = (EventInfo)eventInfo;
        int n = eventInfo2.type;
        switch (n) {
            case 1: {
                this.documentHandler.characters(eventInfo2.ch, eventInfo2.start, eventInfo2.length);
                break;
            }
            case 2: {
                this.documentHandler.endDocument();
                break;
            }
            case 3: {
                this.documentHandler.endElement(eventInfo2.name);
                break;
            }
            case 5: {
                this.documentHandler.ignorableWhitespace(eventInfo2.ch, eventInfo2.start, eventInfo2.length);
                break;
            }
            case 6: {
                this.documentHandler.processingInstruction(eventInfo2.target, eventInfo2.data);
                break;
            }
            case 7: {
                this.documentHandler.setDocumentLocator(eventInfo2.locator);
                break;
            }
            case 9: {
                this.documentHandler.startDocument();
                break;
            }
            case 10: {
                this.documentHandler.startElement(eventInfo2.name, eventInfo2.atts);
            }
        }
    }

    private class EventInfo
    extends ReParsingEventQueue.EventInfo {
        public char[] ch;
        public int start;
        public int length;
        public String target;
        public String data;
        public Locator locator;
        public String name;
        public AttributeList atts;

        private EventInfo() {
        }
    }
}

