/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.jaxp;

import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import weblogic.xml.jaxp.ReParsingEventQueue;
import weblogic.xml.jaxp.ReParsingStatus;

public class ReParsingErrorHandler
implements ErrorHandler,
ReParsingEventQueue.EventHandler {
    private ReParsingEventQueue queue = null;
    private ErrorHandler errorHandler = null;
    private ReParsingStatus status = null;
    private static final int ERROR = 1;
    private static final int FATAL_ERROR = 2;
    private static final int WARNING = 3;

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void hookStatus(ReParsingStatus reParsingStatus) {
        this.status = reParsingStatus;
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        if (this.status != null) {
            this.status.error = sAXParseException;
        }
        if (this.errorHandler != null) {
            EventInfo eventInfo = new EventInfo();
            eventInfo.exception = sAXParseException;
            this.queue.addEvent(eventInfo, this, 1);
        }
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        if (this.status != null) {
            this.status.error = sAXParseException;
        }
        if (this.errorHandler == null) {
            throw sAXParseException;
        }
        EventInfo eventInfo = new EventInfo();
        eventInfo.exception = sAXParseException;
        this.queue.addEvent(eventInfo, this, 2);
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        if (this.errorHandler != null) {
            EventInfo eventInfo = new EventInfo();
            eventInfo.exception = sAXParseException;
            this.queue.addEvent(eventInfo, this, 3);
        }
    }

    public void registerQueue(ReParsingEventQueue reParsingEventQueue) {
        this.queue = reParsingEventQueue;
    }

    public void sendEvent(ReParsingEventQueue.EventInfo eventInfo) throws SAXException {
        EventInfo eventInfo2 = (EventInfo)eventInfo;
        int n = eventInfo2.type;
        switch (n) {
            case 1: {
                this.errorHandler.error(eventInfo2.exception);
                break;
            }
            case 2: {
                this.errorHandler.fatalError(eventInfo2.exception);
                break;
            }
            case 3: {
                this.errorHandler.warning(eventInfo2.exception);
            }
        }
    }

    private class EventInfo
    extends ReParsingEventQueue.EventInfo {
        public SAXParseException exception;

        private EventInfo() {
        }
    }
}

