/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.jaxp;

import java.util.ArrayList;
import java.util.List;
import org.xml.sax.SAXException;

public class ReParsingEventQueue {
    private List<EventInfo> events = new ArrayList<EventInfo>();
    private List<EventInfo> lastEvents = new ArrayList<EventInfo>();

    public void addEvent(EventInfo eventInfo, EventHandler eventHandler, int n) {
        eventInfo.owner = eventHandler;
        eventInfo.type = n;
        this.events.add(eventInfo);
    }

    public void clearAllEvents() {
        this.lastEvents.clear();
        this.events.clear();
    }

    public void shiftLastEvents() {
        this.lastEvents.clear();
        this.lastEvents.addAll(this.events);
        this.events.clear();
    }

    public void reSendLastEvents() throws SAXException {
        for (EventInfo eventInfo : this.lastEvents) {
            EventHandler eventHandler = eventInfo.owner;
            eventHandler.sendEvent(eventInfo);
        }
    }

    protected static interface EventHandler {
        public void sendEvent(EventInfo var1) throws SAXException;

        public void registerQueue(ReParsingEventQueue var1);
    }

    protected static class EventInfo {
        public EventHandler owner = null;
        public int type = 0;

        protected EventInfo() {
        }
    }
}

