/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.jaxp;

import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import weblogic.xml.jaxp.ReParsingEventQueue;

public class ReParsingLexicalHandler
implements LexicalHandler,
ReParsingEventQueue.EventHandler {
    private static final int COMMENT = 1;
    private static final int END_CDATA = 2;
    private static final int END_DTD = 3;
    private static final int END_ENTITY = 4;
    private static final int START_CDATA = 5;
    private static final int START_DTD = 6;
    private static final int START_ENTITY = 7;
    private ReParsingEventQueue queue = null;
    private LexicalHandler lexicalHandler = null;

    public void setLexicalHandler(LexicalHandler lexicalHandler) {
        this.lexicalHandler = lexicalHandler;
    }

    public LexicalHandler getLexicalHandler() {
        return this.lexicalHandler;
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        if (this.lexicalHandler != null) {
            EventInfo eventInfo = new EventInfo();
            eventInfo.ch = cArray;
            eventInfo.start = n;
            eventInfo.length = n2;
            this.queue.addEvent(eventInfo, this, 1);
        }
    }

    public void endCDATA() throws SAXException {
        if (this.lexicalHandler != null) {
            EventInfo eventInfo = new EventInfo();
            this.queue.addEvent(eventInfo, this, 2);
        }
    }

    public void endDTD() throws SAXException {
        if (this.lexicalHandler != null) {
            EventInfo eventInfo = new EventInfo();
            this.queue.addEvent(eventInfo, this, 3);
        }
    }

    public void endEntity(String string) throws SAXException {
        if (this.lexicalHandler != null) {
            EventInfo eventInfo = new EventInfo();
            eventInfo.name = string;
            this.queue.addEvent(eventInfo, this, 4);
        }
    }

    public void startCDATA() throws SAXException {
        if (this.lexicalHandler != null) {
            EventInfo eventInfo = new EventInfo();
            this.queue.addEvent(eventInfo, this, 5);
        }
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
        if (this.lexicalHandler != null) {
            EventInfo eventInfo = new EventInfo();
            eventInfo.name = string;
            eventInfo.publicId = string2;
            eventInfo.systemId = string3;
            this.queue.addEvent(eventInfo, this, 6);
        }
    }

    public void startEntity(String string) throws SAXException {
        if (this.lexicalHandler != null) {
            EventInfo eventInfo = new EventInfo();
            eventInfo.name = string;
            this.queue.addEvent(eventInfo, this, 7);
        }
    }

    public void registerQueue(ReParsingEventQueue reParsingEventQueue) {
        this.queue = reParsingEventQueue;
    }

    public void sendEvent(ReParsingEventQueue.EventInfo eventInfo) throws SAXException {
        EventInfo eventInfo2 = (EventInfo)eventInfo;
        int n = eventInfo2.type;
        switch (n) {
            case 1: {
                this.lexicalHandler.comment(eventInfo2.ch, eventInfo2.start, eventInfo2.length);
                break;
            }
            case 2: {
                this.lexicalHandler.endCDATA();
                break;
            }
            case 3: {
                this.lexicalHandler.endDTD();
                break;
            }
            case 4: {
                this.lexicalHandler.endEntity(eventInfo2.name);
                break;
            }
            case 5: {
                this.lexicalHandler.startCDATA();
                break;
            }
            case 6: {
                this.lexicalHandler.startDTD(eventInfo2.name, eventInfo2.publicId, eventInfo2.systemId);
                break;
            }
            case 7: {
                this.lexicalHandler.startEntity(eventInfo2.name);
            }
        }
    }

    private class EventInfo
    extends ReParsingEventQueue.EventInfo {
        public String systemId;
        public String publicId;
        public String name;
        public int length;
        public int start;
        public char[] ch;

        private EventInfo() {
        }
    }
}

