/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.jaxp;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.Schema;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import weblogic.logging.NonCatalogLogger;
import weblogic.xml.XMLLogger;
import weblogic.xml.jaxp.ChainingEntityResolver;
import weblogic.xml.jaxp.DOMFactoryProperties;
import weblogic.xml.jaxp.ReParsingErrorHandler;
import weblogic.xml.jaxp.ReParsingEventQueue;
import weblogic.xml.jaxp.ReParsingStatus;
import weblogic.xml.jaxp.WebLogicDocumentBuilderFactory;
import weblogic.xml.registry.ReParsingEntityNotChangedException;
import weblogic.xml.registry.RegistryEntityResolver;
import weblogic.xml.registry.XMLRegistryException;
import weblogic.xml.sax.XMLInputSource;
import weblogic.xml.util.InputSourceUtil;

public class RegistryDocumentBuilder
extends DocumentBuilder {
    static NonCatalogLogger logger = new NonCatalogLogger(RegistryDocumentBuilder.class.getName());
    private DocumentBuilder builder;
    private DOMFactoryProperties factoryProperties;
    private final ChainingEntityResolver chainingEntityResolver = new ChainingEntityResolver();
    private ReParsingErrorHandler errorHandlerProxy = new ReParsingErrorHandler();
    private RegistryEntityResolver registry;
    private InputStream jaxpSchemaSource = null;
    private XMLInputSource xmlInputSource = null;
    private Map<String, DocumentBuilder> cache = new HashMap<String, DocumentBuilder>();

    protected RegistryDocumentBuilder(DOMFactoryProperties dOMFactoryProperties) {
        try {
            this.factoryProperties = dOMFactoryProperties;
            this.registry = new RegistryEntityResolver();
            this.chainingEntityResolver.pushEntityResolver(this.registry);
        }
        catch (XMLRegistryException xMLRegistryException) {
            throw new FactoryConfigurationError((Exception)((Object)xMLRegistryException), "Could not access XML Registry. " + xMLRegistryException.getMessage());
        }
    }

    public DOMImplementation getDOMImplementation() {
        if (this.builder == null) {
            try {
                this.builder = this.getDocumentBuilder(null);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                XMLLogger.logParserConfigurationException((String)parserConfigurationException.getMessage());
                return null;
            }
            catch (IOException iOException) {
                XMLLogger.logParserConfigurationException((String)iOException.getMessage());
                return null;
            }
        }
        return this.builder.getDOMImplementation();
    }

    public boolean isNamespaceAware() {
        return this.factoryProperties.get(DOMFactoryProperties.NAMESPACEAWARE);
    }

    public boolean isValidating() {
        return this.factoryProperties.get(DOMFactoryProperties.VALIDATING);
    }

    public Document newDocument() {
        if (this.builder == null) {
            try {
                this.builder = this.getDocumentBuilder(null);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                XMLLogger.logParserConfigurationException((String)parserConfigurationException.getMessage());
                return null;
            }
            catch (IOException iOException) {
                XMLLogger.logParserConfigurationException((String)iOException.getMessage());
                return null;
            }
        }
        return this.builder.newDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document parse(InputSource inputSource) throws SAXException, IOException {
        if (inputSource == null) {
            throw new IllegalArgumentException("InputSource is missing for DocumentBuilder.parse(InputSource)");
        }
        try {
            Document document;
            ReParsingEventQueue reParsingEventQueue;
            block33: {
                try {
                    this.builder = this.getDocumentBuilder(inputSource);
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    throw new SAXException(parserConfigurationException);
                }
                boolean bl = this.isHandleEntityInvalidation(inputSource);
                if (!bl) {
                    if (this.errorHandlerProxy.getErrorHandler() != null) {
                        this.builder.setErrorHandler(this.errorHandlerProxy.getErrorHandler());
                    }
                    Document document2 = this.builder.parse(inputSource);
                    return document2;
                }
                boolean bl2 = false;
                reParsingEventQueue = new ReParsingEventQueue();
                try {
                    ReParsingStatus reParsingStatus = new ReParsingStatus();
                    this.registry.hookStatus(reParsingStatus);
                    this.errorHandlerProxy.hookStatus(reParsingStatus);
                    this.errorHandlerProxy.registerQueue(reParsingEventQueue);
                    SAXParseException sAXParseException = null;
                    Document document3 = null;
                    try {
                        InputSourceUtil.transformInputSource(inputSource);
                    }
                    catch (Exception exception) {
                        reParsingStatus.inLastReParsing = true;
                    }
                    int n = 0;
                    while (true) {
                        if (n >= 2) {
                            reParsingStatus.inLastReParsing = true;
                        }
                        try {
                            document3 = this.builder.parse(inputSource);
                            sAXParseException = null;
                        }
                        catch (SAXParseException sAXParseException2) {
                            sAXParseException = sAXParseException2;
                            reParsingStatus.error = sAXParseException2;
                        }
                        catch (ReParsingEntityNotChangedException reParsingEntityNotChangedException) {
                            bl2 = true;
                            break;
                        }
                        if (!reParsingStatus.needReParse()) break;
                        reParsingStatus.prepareReParsing();
                        reParsingEventQueue.shiftLastEvents();
                        try {
                            if (this.allowCached(this.builder)) {
                                this.builder.reset();
                                this.setupDocumentBuilder(this.builder);
                            } else {
                                this.builder = this.getDocumentBuilder(inputSource);
                            }
                            InputSourceUtil.resetInputSource(inputSource);
                        }
                        catch (Exception exception) {
                            break;
                        }
                        ++n;
                    }
                    if (sAXParseException != null) {
                        throw sAXParseException;
                    }
                    document = document3;
                    this.registry.hookStatus(null);
                    this.errorHandlerProxy.hookStatus(null);
                    if (bl2) break block33;
                    reParsingEventQueue.shiftLastEvents();
                }
                catch (Throwable throwable) {
                    this.registry.hookStatus(null);
                    this.errorHandlerProxy.hookStatus(null);
                    if (!bl2) {
                        reParsingEventQueue.shiftLastEvents();
                    }
                    try {
                        reParsingEventQueue.reSendLastEvents();
                    }
                    finally {
                        reParsingEventQueue.clearAllEvents();
                        this.errorHandlerProxy.registerQueue(null);
                    }
                    throw throwable;
                }
            }
            try {
                reParsingEventQueue.reSendLastEvents();
            }
            finally {
                reParsingEventQueue.clearAllEvents();
                this.errorHandlerProxy.registerQueue(null);
            }
            return document;
        }
        finally {
            if (this.jaxpSchemaSource != null) {
                this.jaxpSchemaSource.reset();
            }
            if (this.xmlInputSource != null) {
                this.xmlInputSource = null;
            }
        }
    }

    private boolean isHandleEntityInvalidation(InputSource inputSource) {
        String string = null;
        try {
            if (this.registry.hasDocumentSpecificEntityEntries() && this.registry.hasHandleEntityInvalidationSetSupport()) {
                if (this.xmlInputSource == null) {
                    this.xmlInputSource = new XMLInputSource(inputSource);
                }
                String string2 = this.xmlInputSource.getPublicIdInternal();
                String string3 = this.xmlInputSource.getDoctypeSystemIdInternal();
                string = this.registry.getHandleEntityInvalidation(string2, string3);
            }
            if (string == null) {
                string = this.registry.getHandleEntityInvalidation();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "true".equals(string);
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        if (this.chainingEntityResolver.getResolverCount() == 2) {
            this.chainingEntityResolver.popEntityResolver();
        }
        this.chainingEntityResolver.pushEntityResolver(entityResolver);
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandlerProxy.setErrorHandler(errorHandler);
        if (this.builder != null) {
            this.builder.setErrorHandler(this.errorHandlerProxy);
        }
    }

    private DocumentBuilder getDocumentBuilder(InputSource inputSource) throws ParserConfigurationException, IOException {
        String string;
        DocumentBuilder documentBuilder = null;
        Object object = null;
        if (this.xmlInputSource != null) {
            this.xmlInputSource = null;
        }
        if (inputSource != null && this.registry.hasDocumentSpecificParserEntries()) {
            this.xmlInputSource = new XMLInputSource(inputSource);
            object = this.getCustomDocumentBuilderFactory(this.xmlInputSource);
        }
        if (object == null) {
            object = this.getDefaultDocumentBuilderFactory();
        }
        if (this.cache.containsKey(string = object.getClass().getName())) {
            documentBuilder = this.cache.get(string);
        } else {
            documentBuilder = ((DocumentBuilderFactory)object).newDocumentBuilder();
            if (this.allowCached(documentBuilder)) {
                this.cache.put(string, documentBuilder);
            }
        }
        this.setupDocumentBuilder(documentBuilder);
        return documentBuilder;
    }

    private boolean allowCached(DocumentBuilder documentBuilder) {
        return documentBuilder.getClass().getName().indexOf("org.apache.xerces") == -1 || !documentBuilder.isValidating();
    }

    private DocumentBuilderFactory getCustomDocumentBuilderFactory(XMLInputSource xMLInputSource) throws IllegalArgumentException {
        DocumentBuilderFactory documentBuilderFactory;
        block3: {
            documentBuilderFactory = null;
            String string = xMLInputSource.getPublicIdInternal();
            String string2 = xMLInputSource.getDoctypeSystemIdInternal();
            String string3 = xMLInputSource.getRootTagInternal();
            try {
                documentBuilderFactory = this.registry.getDocumentBuilderFactory(string, string2, string3);
                if (documentBuilderFactory != null) {
                    this.setupDocumentBuilderFactory(documentBuilderFactory);
                }
            }
            catch (XMLRegistryException xMLRegistryException) {
                if (!this.registry.hasDocumentSpecificParserEntries()) break block3;
                XMLLogger.logXMLRegistryException((String)xMLRegistryException.getMessage());
            }
        }
        return documentBuilderFactory;
    }

    private DocumentBuilderFactory getDefaultDocumentBuilderFactory() throws IllegalArgumentException {
        DocumentBuilderFactory documentBuilderFactory = null;
        try {
            documentBuilderFactory = this.registry.getDocumentBuilderFactory();
        }
        catch (XMLRegistryException xMLRegistryException) {
            XMLLogger.logXMLRegistryException((String)xMLRegistryException.getMessage());
        }
        if (documentBuilderFactory == null) {
            documentBuilderFactory = new WebLogicDocumentBuilderFactory();
        }
        this.setupDocumentBuilderFactory(documentBuilderFactory);
        return documentBuilderFactory;
    }

    private void setupDocumentBuilder(DocumentBuilder documentBuilder) {
        documentBuilder.setErrorHandler(this.errorHandlerProxy);
        documentBuilder.setEntityResolver(this.chainingEntityResolver);
    }

    private void setupDocumentBuilderFactory(DocumentBuilderFactory documentBuilderFactory) {
        Schema schema;
        documentBuilderFactory.setCoalescing(this.factoryProperties.get(DOMFactoryProperties.COALESCING));
        documentBuilderFactory.setExpandEntityReferences(this.factoryProperties.get(DOMFactoryProperties.EXPANDENTITYREFERENCES));
        documentBuilderFactory.setIgnoringComments(this.factoryProperties.get(DOMFactoryProperties.IGNORINGCOMMENTS));
        documentBuilderFactory.setIgnoringElementContentWhitespace(this.factoryProperties.get(DOMFactoryProperties.IGNORINGELEMENTCONTENTWHITESPACE));
        if (this.factoryProperties.isSetExplicitly(DOMFactoryProperties.NAMESPACEAWARE)) {
            documentBuilderFactory.setNamespaceAware(this.factoryProperties.get(DOMFactoryProperties.NAMESPACEAWARE));
        }
        documentBuilderFactory.setValidating(this.factoryProperties.get(DOMFactoryProperties.VALIDATING));
        if (this.factoryProperties.get(DOMFactoryProperties.XINCL)) {
            documentBuilderFactory.setXIncludeAware(true);
        }
        if ((schema = (Schema)this.factoryProperties.getAttribute(DOMFactoryProperties.SCHEMA)) != null) {
            documentBuilderFactory.setSchema(schema);
        }
        Iterator iterator = this.factoryProperties.attributes();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object object = this.factoryProperties.getAttribute(string);
            if (DOMFactoryProperties.SCHEMA.equals(string)) continue;
            try {
                documentBuilderFactory.setAttribute(string, object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                XMLLogger.logPropertyNotAccepted((String)string, (String)object.toString(), (String)illegalArgumentException.getMessage());
            }
        }
    }

    public Schema getSchema() {
        return (Schema)this.factoryProperties.getAttribute(DOMFactoryProperties.SCHEMA);
    }

    public boolean isXIncludeAware() {
        return this.factoryProperties.get(DOMFactoryProperties.XINCL);
    }

    void setJaxpSchemaSource(InputStream inputStream) {
        this.jaxpSchemaSource = inputStream;
    }

    public void reset() {
        this.errorHandlerProxy.setErrorHandler(null);
        for (DocumentBuilder documentBuilder : this.cache.values()) {
            documentBuilder.reset();
        }
    }
}

