/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.jaxp;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.Schema;
import weblogic.utils.Debug;
import weblogic.xml.XMLLogger;
import weblogic.xml.jaxp.DOMFactoryProperties;
import weblogic.xml.jaxp.RegistryDocumentBuilder;
import weblogic.xml.jaxp.WebLogicDocumentBuilderFactory;
import weblogic.xml.jaxp.XMLContext;
import weblogic.xml.registry.XMLRegistry;
import weblogic.xml.registry.XMLRegistryException;
import weblogic.xml.util.CachedInputStream;
import weblogic.xml.util.Debug;

public class RegistryDocumentBuilderFactory
extends DocumentBuilderFactory {
    static Debug.DebugFacility dbg = XMLContext.dbg;
    private DOMFactoryProperties factoryProperties = new DOMFactoryProperties();
    private DocumentBuilderFactory factory = null;
    private boolean docSpecificParser = false;
    private static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private CachedInputStream jaxpSchemaStream = null;

    public Object getAttribute(String string) throws IllegalArgumentException {
        try {
            XMLRegistry[] xMLRegistryArray = XMLRegistry.getXMLRegistryPath();
            if (this.factory == null) {
                for (int i = 0; i < xMLRegistryArray.length; ++i) {
                    this.factory = xMLRegistryArray[i].getDocumentBuilderFactory();
                    this.docSpecificParser = xMLRegistryArray[i].hasDocumentSpecificParserEntries();
                    if (this.factory != null) break;
                }
            }
            if (this.factory == null) {
                this.factory = new WebLogicDocumentBuilderFactory();
                this.docSpecificParser = false;
                this.factory.getAttribute(string);
            } else if (!this.docSpecificParser) {
                this.factory.getAttribute(string);
            }
        }
        catch (XMLRegistryException xMLRegistryException) {
            // empty catch block
        }
        return this.factoryProperties.getAttribute(string);
    }

    public boolean isCoalescing() {
        return this.factoryProperties.get(DOMFactoryProperties.COALESCING);
    }

    public boolean isExpandEntityReferences() {
        return this.factoryProperties.get(DOMFactoryProperties.EXPANDENTITYREFERENCES);
    }

    public boolean isIgnoringComments() {
        return this.factoryProperties.get(DOMFactoryProperties.IGNORINGCOMMENTS);
    }

    public boolean isIgnoringElementContentWhitespace() {
        return this.factoryProperties.get(DOMFactoryProperties.IGNORINGELEMENTCONTENTWHITESPACE);
    }

    public boolean isNamespaceAware() {
        return this.factoryProperties.get(DOMFactoryProperties.NAMESPACEAWARE);
    }

    public boolean isValidating() {
        return this.factoryProperties.get(DOMFactoryProperties.VALIDATING);
    }

    public DocumentBuilder newDocumentBuilder() throws ParserConfigurationException {
        RegistryDocumentBuilder registryDocumentBuilder = new RegistryDocumentBuilder((DOMFactoryProperties)this.factoryProperties.clone());
        registryDocumentBuilder.setJaxpSchemaSource(this.jaxpSchemaStream);
        registryDocumentBuilder.setJaxpSchemaSource(this.jaxpSchemaStream);
        return registryDocumentBuilder;
    }

    public void setAttribute(String string, Object object) throws IllegalArgumentException {
        try {
            object = this.filterJaxpStream(string, object);
            XMLRegistry[] xMLRegistryArray = XMLRegistry.getXMLRegistryPath();
            if (this.factory == null) {
                for (int i = 0; i < xMLRegistryArray.length; ++i) {
                    this.factory = xMLRegistryArray[i].getDocumentBuilderFactory();
                    this.docSpecificParser = xMLRegistryArray[i].hasDocumentSpecificParserEntries();
                    if (this.factory != null) break;
                }
            }
            if (this.factory == null) {
                this.factory = new WebLogicDocumentBuilderFactory();
                this.docSpecificParser = false;
                this.factory.setAttribute(string, object);
            } else if (!this.docSpecificParser) {
                this.factory.setAttribute(string, object);
            }
        }
        catch (XMLRegistryException xMLRegistryException) {
            // empty catch block
        }
        this.factoryProperties.setAttribute(string, object);
    }

    public void setCoalescing(boolean bl) {
        this.factoryProperties.put(DOMFactoryProperties.COALESCING, bl);
    }

    public void setExpandEntityReferences(boolean bl) {
        this.factoryProperties.put(DOMFactoryProperties.EXPANDENTITYREFERENCES, bl);
    }

    public void setIgnoringComments(boolean bl) {
        this.factoryProperties.put(DOMFactoryProperties.IGNORINGCOMMENTS, bl);
    }

    public void setIgnoringElementContentWhitespace(boolean bl) {
        this.factoryProperties.put(DOMFactoryProperties.IGNORINGELEMENTCONTENTWHITESPACE, bl);
    }

    public void setNamespaceAware(boolean bl) {
        this.factoryProperties.put(DOMFactoryProperties.NAMESPACEAWARE, bl);
    }

    public void setValidating(boolean bl) {
        this.factoryProperties.put(DOMFactoryProperties.VALIDATING, bl);
    }

    public boolean getFeature(String string) {
        return this.factoryProperties.get(string);
    }

    public void setFeature(String string, boolean bl) {
        this.factoryProperties.put(string, bl);
    }

    public boolean isXIncludeAware() throws UnsupportedOperationException {
        return this.factoryProperties.get(DOMFactoryProperties.XINCL);
    }

    public void setXIncludeAware(boolean bl) throws UnsupportedOperationException {
        this.factoryProperties.put(DOMFactoryProperties.XINCL, bl);
    }

    public Schema getSchema() throws UnsupportedOperationException {
        return (Schema)this.factoryProperties.getAttribute(DOMFactoryProperties.SCHEMA);
    }

    public void setSchema(Schema schema) throws UnsupportedOperationException {
        this.factoryProperties.setAttribute(DOMFactoryProperties.SCHEMA, schema);
    }

    private Object filterJaxpStream(String string, Object object) {
        if (string != null && string.equals(JAXP_SCHEMA_SOURCE)) {
            if (object instanceof InputStream) {
                try {
                    if (this.jaxpSchemaStream != null) {
                        this.closeJaxpSchemaStream();
                    }
                    this.jaxpSchemaStream = new CachedInputStream((InputStream)object);
                    return this.jaxpSchemaStream;
                }
                catch (IOException iOException) {
                    XMLLogger.logIOException((String)iOException.getMessage());
                    throw new IllegalArgumentException("Error caching stream for http://java.sun.com/xml/jaxp/properties/schemaSource " + iOException.toString());
                }
            }
            if (this.jaxpSchemaStream != null) {
                try {
                    this.closeJaxpSchemaStream();
                }
                catch (IOException iOException) {
                    XMLLogger.logIOException((String)iOException.getMessage());
                    throw new IllegalArgumentException("Error Processing Attribute http://java.sun.com/xml/jaxp/properties/schemaSource " + iOException.toString());
                }
            }
        }
        return object;
    }

    private void closeJaxpSchemaStream() throws IOException {
        Debug.assertion((this.jaxpSchemaStream != null ? 1 : 0) != 0, (String)"JaxpSchemaStream cannot be null");
        try {
            this.jaxpSchemaStream.closeAll();
        }
        catch (IOException iOException) {
            XMLLogger.logIOException((String)iOException.getMessage());
            throw iOException;
        }
    }
}

