/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.jaxp;

import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.Schema;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import weblogic.xml.jaxp.ChainingEntityResolver;
import weblogic.xml.jaxp.ParserCreationHelper;
import weblogic.xml.jaxp.ReParsingDTDHandler;
import weblogic.xml.jaxp.ReParsingDocumentHandler;
import weblogic.xml.jaxp.ReParsingErrorHandler;
import weblogic.xml.jaxp.ReParsingEventQueue;
import weblogic.xml.jaxp.ReParsingStatus;
import weblogic.xml.jaxp.SAXFactoryProperties;
import weblogic.xml.jaxp.XMLContext;
import weblogic.xml.registry.ReParsingEntityNotChangedException;
import weblogic.xml.registry.RegistryEntityResolver;
import weblogic.xml.registry.XMLRegistryException;
import weblogic.xml.sax.XMLInputSource;
import weblogic.xml.util.Debug;
import weblogic.xml.util.InputSourceUtil;
import weblogicx.xml.parser.BaseParser;

public class RegistryParser
implements Parser {
    static Debug.DebugFacility dbg = XMLContext.dbg;
    private RegistryEntityResolver registry;
    private ChainingEntityResolver chainingEntityResolver;
    private ReParsingDocumentHandler documentHandlerProxy = new ReParsingDocumentHandler();
    private ReParsingDTDHandler dtdHandlerProxy = new ReParsingDTDHandler();
    private ReParsingErrorHandler errorHandlerProxy = new ReParsingErrorHandler();
    private Locale locale;
    private Parser parser;
    private SAXFactoryProperties saxFactoryProperties;
    private XMLInputSource xmlInputSource = null;
    private SAXParser saxParser = null;
    private Map<String, SAXParser> cache = new HashMap<String, SAXParser>();

    public RegistryParser() {
        try {
            this.registry = new RegistryEntityResolver();
            this.chainingEntityResolver = new ChainingEntityResolver();
            this.chainingEntityResolver.pushEntityResolver(this.registry);
            this.saxFactoryProperties = new SAXFactoryProperties();
        }
        catch (XMLRegistryException xMLRegistryException) {
            AssertionError assertionError = new AssertionError((Object)"Could not create RegistryParser.");
            ((Throwable)((Object)assertionError)).initCause((Throwable)((Object)xMLRegistryException));
            throw assertionError;
        }
    }

    protected RegistryParser(SAXParser sAXParser, SAXFactoryProperties sAXFactoryProperties) {
        try {
            this.registry = new RegistryEntityResolver();
            this.chainingEntityResolver = new ChainingEntityResolver();
            this.chainingEntityResolver.pushEntityResolver(this.registry);
            this.saxFactoryProperties = sAXFactoryProperties;
            if (sAXParser != null) {
                this.parser = sAXParser.getParser();
                this.parser.setEntityResolver(this.chainingEntityResolver);
            }
        }
        catch (XMLRegistryException xMLRegistryException) {
            throw new FactoryConfigurationError((Exception)((Object)xMLRegistryException), "Could not access XML Registry. " + xMLRegistryException.getMessage());
        }
        catch (SAXException sAXException) {
            throw new FactoryConfigurationError(sAXException, "Could not create parser. " + sAXException.getMessage());
        }
        catch (NullPointerException nullPointerException) {
            throw new FactoryConfigurationError(nullPointerException, "Could not create parser. " + nullPointerException.getMessage());
        }
    }

    public RegistryEntityResolver getRegistry() {
        return this.registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputSource inputSource) throws SAXException, IOException {
        block30: {
            if (inputSource == null) {
                throw new IllegalArgumentException("InputSource is missing.");
            }
            try {
                try {
                    this.parser = this.getParserInternal(inputSource);
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    throw new SAXException(parserConfigurationException);
                }
                boolean bl = this.isHandleEntityInvalidation(inputSource);
                if (!bl) {
                    if (this.errorHandlerProxy.getErrorHandler() != null) {
                        this.parser.setErrorHandler(this.errorHandlerProxy.getErrorHandler());
                    }
                    if (this.documentHandlerProxy.getDocumentHandler() != null) {
                        this.parser.setDocumentHandler(this.documentHandlerProxy.getDocumentHandler());
                    }
                    if (this.dtdHandlerProxy.getDTDHandler() != null) {
                        this.parser.setDTDHandler(this.dtdHandlerProxy.getDTDHandler());
                    }
                    this.parser.parse(inputSource);
                    break block30;
                }
                boolean bl2 = false;
                ReParsingEventQueue reParsingEventQueue = new ReParsingEventQueue();
                try {
                    ReParsingStatus reParsingStatus = new ReParsingStatus();
                    this.registry.hookStatus(reParsingStatus);
                    this.errorHandlerProxy.hookStatus(reParsingStatus);
                    this.errorHandlerProxy.registerQueue(reParsingEventQueue);
                    this.documentHandlerProxy.registerQueue(reParsingEventQueue);
                    this.dtdHandlerProxy.registerQueue(reParsingEventQueue);
                    SAXParseException sAXParseException = null;
                    Object var7_8 = null;
                    try {
                        InputSourceUtil.transformInputSource(inputSource);
                    }
                    catch (Exception exception) {
                        reParsingStatus.inLastReParsing = true;
                    }
                    int n = 0;
                    while (true) {
                        if (n >= 2) {
                            reParsingStatus.inLastReParsing = true;
                        }
                        try {
                            this.parser.parse(inputSource);
                            sAXParseException = null;
                        }
                        catch (SAXParseException sAXParseException2) {
                            sAXParseException = sAXParseException2;
                            reParsingStatus.error = sAXParseException2;
                        }
                        catch (ReParsingEntityNotChangedException reParsingEntityNotChangedException) {
                            bl2 = true;
                            break;
                        }
                        if (!reParsingStatus.needReParse()) break;
                        reParsingStatus.prepareReParsing();
                        reParsingEventQueue.shiftLastEvents();
                        try {
                            this.saxParser.reset();
                            this.parser = this.saxParser.getParser();
                            this.setupParser();
                            InputSourceUtil.resetInputSource(inputSource);
                        }
                        catch (Exception exception) {
                            break;
                        }
                        ++n;
                    }
                    if (sAXParseException != null) {
                        throw sAXParseException;
                    }
                }
                finally {
                    this.registry.hookStatus(null);
                    this.errorHandlerProxy.hookStatus(null);
                    if (!bl2) {
                        reParsingEventQueue.shiftLastEvents();
                    }
                    try {
                        reParsingEventQueue.reSendLastEvents();
                    }
                    finally {
                        reParsingEventQueue.clearAllEvents();
                        this.errorHandlerProxy.registerQueue(null);
                        this.documentHandlerProxy.registerQueue(null);
                        this.dtdHandlerProxy.registerQueue(null);
                    }
                }
            }
            finally {
                if (this.xmlInputSource != null) {
                    this.xmlInputSource = null;
                }
            }
        }
    }

    private boolean isHandleEntityInvalidation(InputSource inputSource) {
        String string = null;
        try {
            if (this.registry.hasDocumentSpecificEntityEntries() && this.registry.hasHandleEntityInvalidationSetSupport()) {
                if (this.xmlInputSource == null) {
                    this.xmlInputSource = new XMLInputSource(inputSource);
                }
                String string2 = this.xmlInputSource.getPublicIdInternal();
                String string3 = this.xmlInputSource.getDoctypeSystemIdInternal();
                string = this.registry.getHandleEntityInvalidation(string2, string3);
            }
            if (string == null) {
                string = this.registry.getHandleEntityInvalidation();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "true".equals(string);
    }

    public void parse(String string) throws SAXException, IOException {
        if (string == null) {
            throw new IllegalArgumentException("System ID is missing.");
        }
        this.parse(new InputSource(string));
    }

    public void setDocumentHandler(DocumentHandler documentHandler) {
        this.documentHandlerProxy.setDocumentHandler(documentHandler);
        if (this.parser != null) {
            this.parser.setDocumentHandler(documentHandler);
        }
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandlerProxy.setErrorHandler(errorHandler);
        if (this.parser != null) {
            this.parser.setErrorHandler(errorHandler);
        }
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        if (dbg.areDebuggingAt(2)) {
            int n = this.chainingEntityResolver.getResolverCount();
            dbg.assertion(n == 1 || n == 2);
        }
        if (this.chainingEntityResolver.getResolverCount() == 2) {
            this.chainingEntityResolver.popEntityResolver();
        }
        this.chainingEntityResolver.pushEntityResolver(entityResolver);
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        this.dtdHandlerProxy.setDTDHandler(dTDHandler);
        if (this.parser != null) {
            this.parser.setDTDHandler(dTDHandler);
        }
    }

    public void setLocale(Locale locale) throws SAXException {
        this.locale = locale;
        if (this.parser != null) {
            this.parser.setLocale(locale);
        }
    }

    private Parser getParserInternal(InputSource inputSource) throws ParserConfigurationException, SAXException, IOException {
        if (this.xmlInputSource != null) {
            this.xmlInputSource = null;
        }
        if (this.registry.hasDocumentSpecificParserEntries()) {
            this.xmlInputSource = new XMLInputSource(inputSource);
            this.parser = this.getParser(this.xmlInputSource);
        } else {
            this.parser = this.getParser(null);
        }
        this.setupParser();
        return this.parser;
    }

    private Parser getParser(XMLInputSource xMLInputSource) throws ParserConfigurationException, SAXException {
        Parser parser2 = null;
        SAXParserFactory sAXParserFactory = null;
        ParserCreationHelper parserCreationHelper = new ParserCreationHelper(this.registry);
        if (xMLInputSource != null) {
            parser2 = parserCreationHelper.getCustomParser(xMLInputSource);
        }
        if (parser2 != null) {
            if (this.parser instanceof BaseParser && (this.saxFactoryProperties.get(SAXFactoryProperties.VALIDATING) || this.saxFactoryProperties.get(SAXFactoryProperties.NAMESPACEAWARE))) {
                throw new ParserConfigurationException("Custom-generated parser " + parser2.getClass().getName() + " cannot be used. This parser is neither validating nor namespaceaware.");
            }
        } else {
            String string;
            if (xMLInputSource != null) {
                sAXParserFactory = parserCreationHelper.getCustomSAXParserFactory(xMLInputSource);
            }
            if (sAXParserFactory == null) {
                sAXParserFactory = parserCreationHelper.getDefaultSAXParserFactory();
            }
            if (this.cache.containsKey(string = sAXParserFactory.getClass().getName())) {
                this.saxParser = this.cache.get(string);
                parser2 = this.saxParser.getParser();
            } else {
                Schema schema;
                sAXParserFactory.setValidating(this.saxFactoryProperties.get(SAXFactoryProperties.VALIDATING));
                if (this.saxFactoryProperties.isSetExplicitly(SAXFactoryProperties.NAMESPACEAWARE)) {
                    sAXParserFactory.setNamespaceAware(this.saxFactoryProperties.get(SAXFactoryProperties.NAMESPACEAWARE));
                }
                if ((schema = (Schema)this.saxFactoryProperties.getProperty(SAXFactoryProperties.SCHEMA)) != null) {
                    sAXParserFactory.setSchema(schema);
                }
                if (this.saxFactoryProperties.get(SAXFactoryProperties.XINCL)) {
                    sAXParserFactory.setXIncludeAware(true);
                }
                this.saxParser = sAXParserFactory.newSAXParser();
                this.cache.put(string, this.saxParser);
                parser2 = this.saxParser.getParser();
            }
        }
        return parser2;
    }

    private void setupParser() throws SAXException {
        this.parser.setDocumentHandler(this.documentHandlerProxy);
        this.parser.setErrorHandler(this.errorHandlerProxy);
        this.parser.setDTDHandler(this.dtdHandlerProxy);
        if (this.locale != null) {
            this.parser.setLocale(this.locale);
        }
        this.parser.setEntityResolver(this.chainingEntityResolver);
    }

    void reset() {
        this.documentHandlerProxy.setDocumentHandler(null);
        this.errorHandlerProxy.setErrorHandler(null);
        this.dtdHandlerProxy.setDTDHandler(null);
        this.resetCachedSAXParsers();
    }

    private void resetCachedSAXParsers() {
        for (SAXParser sAXParser : this.cache.values()) {
            sAXParser.reset();
        }
    }
}

